/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;

public class RESTTestUtils {
    static final String LOG4J_PATH = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/log4j.properties";

    static String getResourceDescriptor(File f) throws Exception {
        return IOUtils.toString((InputStream)new FileInputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveReportToFile(HttpResponse httpRes, String fileName, ReportOutputFormat fileFormat) throws Exception {
        InputStream is = httpRes.getEntity().getContent();
        FileOutputStream os = new FileOutputStream("src/main/java/com/jaspersoft/jasperserver/rest/test/serverresources/report/outputFiles/" + fileName + "." + (Object)((Object)fileFormat));
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, n);
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static HttpRequestBase assembleRequest(ResourceDescriptor rd, HttpRequestBase httpReq) {
        Marshaller m = new Marshaller();
        String rdXml = m.writeResourceDescriptor(rd);
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new ByteArrayInputStream(rdXml.getBytes()));
        ((HttpEntityEnclosingRequestBase)httpReq).setEntity((HttpEntity)reqEntity);
        return httpReq;
    }

    public static void assertCorrectFileSize(String fileName, Integer minimumSize) {
        File exportedFile = new File(fileName);
        if (minimumSize == null) {
            minimumSize = 0;
        }
        Assert.assertTrue((exportedFile.length() >= (long)minimumSize.intValue() ? 1 : 0) != 0);
    }

    public static void assertValidResponseCode(int expectedCode, int actualCode) throws Exception {
        Assert.assertTrue((String)("Basic response check did not pass; Expected code = " + expectedCode + "; Actual code = " + actualCode), (boolean)RESTTestUtils.isValidResponse(expectedCode, actualCode));
    }

    public static boolean isValidResponse(int expected_Code, int actualCode) throws Exception {
        return actualCode == expected_Code;
    }

    public static void assertValid404ResponseCode(int actualCode) throws Exception {
        RESTTestUtils.assertValidResponseCode(404, actualCode);
    }

    public static enum ReportOutputFormat {
        html("HTML"),
        pdf("PDF"),
        rtf("RTF"),
        xls("XLS"),
        csv("CSV"),
        xml("XML"),
        jrprint("JRPRINT");

        private String format;

        private ReportOutputFormat(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }

        public boolean equals(String format) {
            return this.toString().equals(format);
        }
    }
}

