/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ObjectPermissionImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.rest.test.RESTTest;
import com.jaspersoft.jasperserver.rest.test.RESTTestUtilsAndConsts;
import com.jaspersoft.jasperserver.rest.utils.JAXBList;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PUTTest
extends RESTTest {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.httpReqCE = new HttpPut();
        this.httpReqPro = new HttpPut();
    }

    @Test
    public void Put200OlapUnit() throws Exception {
        this.putSampleResource_PRO("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/olapUnit_revenue_view.xml", "/resource/supermart/salesByMonth/");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/supermart/salesByMonth/JUNIT_RevenueView");
    }

    @Test
    public void testVerify_cant_create_domain_with_demo_user() throws Exception {
    }

    @Test
    public void Job_Put_200() throws Exception {
        this.putSampleJob_CE();
        int ceJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_CE());
        this.sendAndAssert_CE((HttpRequestBase)new HttpGet(), "/job/" + ceJobIndex);
        this.deleteJob(ceJobIndex, false);
        this.putSampleJob_PRO();
        int proJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_PRO());
        this.sendAndAssert_PRO((HttpRequestBase)new HttpGet(), "/job/" + proJobIndex);
        this.deleteJob(proJobIndex, true);
    }

    @Test
    public void Job_MultiOutput_Put_200() throws Exception {
        this.putSampleResource_CE("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/job/multiOutputFormats_uri.reports.samples.allAccounts.xml", "/job");
        int ceJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_CE());
        this.sendAndAssert_CE((HttpRequestBase)new HttpGet(), "/job/" + ceJobIndex);
        this.deleteJob(ceJobIndex, false);
        this.putSampleResource_PRO("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/job/multiOutputFormats_uri.reports.samples.allAccounts.xml", "/job");
        int proJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_PRO());
        this.sendAndAssert_PRO((HttpRequestBase)new HttpGet(), "/job/" + proJobIndex);
        this.deleteJob(proJobIndex, true);
    }

    @Test
    public void User_Put_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_CE.xml", 201);
        this.sendAndAssert_PRO(this.httpReqPro, "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_PRO.xml", 201);
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER%7Corganization_1");
    }

    @Test
    public void User_Put_Post_UPDATE_WITH_EMPTY_TENANT_400() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_PRO.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPost(), "/user/JUNIT_USER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_PRO_NO_TENANT_ID_NEW_PASSWORD.xml", 200);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER");
    }

    @Test
    public void User_Put_200_LOGIN_AS_NEW_USER() throws Exception {
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_CE.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_PRO.xml", 201);
        this.loginToServer("JUNIT_USER", "JUNIT_USER", "JUNIT_USER", "JUNIT_USER");
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER", 400);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER", 400);
        this.loginToServer();
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER");
    }

    @Test
    public void User_Put_400_NoTenantIdInAMultiTenantEnviorment() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant.xml", 201);
        this.sendAndAssert_PRO(this.httpReqPro, "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_PRO_NO_TENANT_ID.xml", 400);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/2");
    }

    @Test
    public void Role_Put_200() throws Exception {
    }

    @Test
    public void Role_Put_400_UNSUPPORTED_CHAR() throws Exception {
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce_ILLEGAL_CHARS.xml", 400);
    }

    @Test
    public void Role_Put_400_PUT_ROOT_ROLE() throws Exception {
        this.loginToPROServer("superuser", "superuser");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro_NO_TENANT.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT");
    }

    @Test
    public void Role_Put_400_PUT_ROOT_ROLE_ORGANIZATIONS() throws Exception {
        this.loginToPROServer("superuser", "superuser");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro_ROOT_ROLE.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT");
    }

    @Test
    public void Permission_Put_200() throws Exception {
        this.putSampleFolder();
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_ce_uri.reports.xml", 200);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_pro_uri.reports.xml", 200);
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("roles", "ROLE_ANONYMOUS, ROLE_ETL_ADMIN, ROLE_USER"));
        qparams.add((NameValuePair)new BasicNameValuePair("users", "joeuser, etladmin"));
        HttpResponse res = this.sendRequestCE((HttpRequestBase)new HttpDelete(), "/permission/JUNIT_NEW_FOLDER", qparams);
        Assert.assertTrue((String)"wrong return value: ", (boolean)this.isValidResposnse(res, 200));
        res = this.sendRequestPRO((HttpRequestBase)new HttpDelete(), "/permission/JUNIT_NEW_FOLDER", qparams);
        Assert.assertTrue((String)"wrong return value: ", (boolean)this.isValidResposnse(res, 200));
        this.deleteSampleFolder();
    }

    @Test
    public void Permission_Put_404_MALFORMED_URI() throws Exception {
        this.putSampleFolder();
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_ce_uri.reports_MALFORMED_URI_1.xml", 404);
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_ce_uri.reports_MALFORMED_URI_2.xml", 404);
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_ce_uri.reports_MALFORMED_URI_3.xml", 404);
        this.deleteSampleFolder();
    }

    @Test
    public void Permission_Put_200_CHANGE_YOUR_OWN_PERMISSIONS() throws Exception {
        this.putSampleFolder();
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_ce_uri.reports_FOR_SUPERUSER_ANDMINISTRATOR.xml", 403);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_pro_uri.reports_FOR_SUPERUSER_ANDMINISTRATOR.xml", 403);
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("roles", "ROLE_ADMINISTRATOR, ROLE_SUPERUSER"));
        qparams.add((NameValuePair)new BasicNameValuePair("users", "jasperadmin"));
        HttpResponse res = this.sendRequestCE((HttpRequestBase)new HttpDelete(), "/permission/JUNIT_NEW_FOLDER", qparams);
        Assert.assertTrue((String)"wrong return value: ", (boolean)this.isValidResposnse(res, 403));
        res = this.sendRequestPRO((HttpRequestBase)new HttpDelete(), "/permission/JUNIT_NEW_FOLDER", qparams);
        Assert.assertTrue((String)"wrong return value: ", (boolean)this.isValidResposnse(res, 403));
        this.deleteSampleFolder();
    }

    @Test
    public void Attribute_Put_201() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/attribute/joeuser", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/attributes/attributes.xml", 201);
        this.sendAndAssert_PRO(this.httpReqPro, "/attribute/joeuser%7Corganization_1", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/attributes/attributes.xml", 201);
    }

    @Test
    public void Attribute_Put_201_FOR_NEW_USER() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_CE.xml", 201);
        this.sendAndAssert_CE(this.httpReqCE, "/attribute/JUNIT_USER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/attributes/attributes.xml", 201);
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER");
        this.sendAndAssert_PRO(this.httpReqPro, "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_PRO.xml", 201);
        this.sendAndAssert_PRO(this.httpReqPro, "/attribute/JUNIT_USER%7Corganization_1", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/attributes/attributes.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER%7Corganization_1");
    }

    @Test
    public void Attribute_Put_404_ATTRIBUTES_TO_A_NONEXISTING_USER() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/attribute/none_existing_user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/attributes/attributes.xml", 400);
        this.sendAndAssert_PRO(this.httpReqPro, "/attribute/none_existing_user%7Corganization_1", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/attributes/attributes.xml", 400);
    }

    @Test
    public void Organization_Put_201() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant.xml", 201);
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/2nd_level_tenant.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPost(), "/organization/2", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_update.xml", 200);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/2_chiled");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/2");
    }

    @Test
    public void Organization_Put_400_UPDATE_WITH_WRONG_ORG_NAME() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPost(), "/organization/22", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_update.xml", 400);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/2");
    }

    @Test
    public void Organization_Put_400_ORGANIZATION_WITH_SPECIAL_TAGS() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_ALIAS.xml", 400);
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_TENANT_NAME.xml", 400);
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_ID.xml", 400);
    }

    @Test
    public void Organization_Put_400_DELETE_OWN_ORGANIZATION() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant.xml", 201);
        this.loginToPROServer("jasperadmin%7C2", "jasperadmin");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/2", 400);
        this.loginToPROServer("superuser", "superuser");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/2");
    }

    @Test
    public void Organization_Put_403_PUTTING_AN_ALREADY_EXIST_ORGANIZATION() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant.xml", 201);
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant.xml", 403);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/2");
    }

    @Test
    public void Organization_Put_404_MISSING_PARAMETERS_IN_DESCRIPTOR() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_MISSING_PARAMETERS_1.xml", 400);
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_MISSING_PARAMETERS_2.xml", 400);
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/1st_level_tenant_MISSING_PARAMETERS_3.xml", 400);
    }

    @Test
    public void Organization_Put_403_DELETING_SIBLING_ORGANIZATION() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/org1.xml", 201);
        this.sendAndAssert_PRO(this.httpReqPro, "/organization", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/tenants/org2.xml", 201);
        this.loginToPROServer("jasperadmin", "jasperadmin", "org1");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/org2", 400);
        this.loginToServer();
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/org1", 200);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/org2", 200);
    }

    @Test
    public void Role_PUT_POST_200() throws Exception {
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce_EMPTY_NAME.xml", 400);
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce_ILLEGAL_CHARS.xml", 400);
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce.xml", 201);
        this.sendAndAssert_CE((HttpRequestBase)new HttpPost(), "/role/ROLE_JUNIT", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce_EMPTY_NAME.xml", 400);
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce.xml", 400);
        this.sendAndAssert_CE((HttpRequestBase)new HttpPost(), "/role/ROLE_JUNIT", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce_ILLEGAL_CHARS.xml", 400);
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro_ROOT_ROLE.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro_ILLEGAL_CHARS.xml", 400);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro_NONE_EXISTING_TENANT_NAME.xml", 400);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/role", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPost(), "/role/ROLE_JUNIT", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro_NO_TENANT.xml", 200);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT%7Corganization_1");
    }

    @Test
    public void resource_Folder_PUT_201() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
    }

    @Test
    public void Role_PUT_400() throws Exception {
        this.putSampleRole_CE();
        this.sendAndAssert_CE(this.httpReqCE, "/role/ROLE_JUNIT", 400);
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT");
        this.putSampleRole_PRO();
        this.sendAndAssert_PRO(this.httpReqPro, "/role/ROLE_JUNIT%7Corganization_1", 400);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT%7Corganization_1");
    }

    @Test
    public void Role_GET_SUPERUSER() throws Exception {
        this.loginToPROServer("superuser", "superuser");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpGet(), "/role/ROLE_USER");
    }

    @Test
    public void Role_PUT_POST_400() throws Exception {
        this.putSampleRole_PRO();
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPost(), "/role/ROLE_JUNIT", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro_UPDATED.xml");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/role/ROLE_JUNIT_UPDATED%7Corganization_1");
    }

    @Test
    public void resource_IMG_PUT_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/image_URI.JUNIT_NEW_FOLDER.JUNIT_IMAGE_FILE.xml";
        String fileBins = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperSoftLogo.jpg";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(fileBins));
        reqEntity.addPart("/JUNIT_NEW_FOLDER/JUNIT_IMAGE_FILE", (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.httpReqCE).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestCE(this.httpReqCE, "/resource/JUNIT_NEW_FOLDER");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_IMAGE_FILE");
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
        ((HttpEntityEnclosingRequestBase)this.httpReqPro).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_IMAGE_FILE");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
    }

    @Test
    public void Resource_ReportUnit_PUT_200() throws Exception {
        this.putSampleReport();
        this.deleteSampleReport();
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_LocalResource_IMG_of_ReportUnit_PUT_200() throws Exception {
        super.Resource_LocalResource_of_ReportUnit_PUT_200((HttpRequestBase)new HttpPut(), "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/image_URI.JUNIT_NEW_FOLDER.JUNIT_REPORT_UNIT_SALES_BY_MONTH_files.Logo2.xml", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperSoftLogo.jpg", "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo_2", "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files");
        this.sendAndAssert_CE((HttpRequestBase)new HttpGet(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo_2");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpGet(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo_2");
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_LocalResource_PROP_of_ReportUnit_PUT_200() throws Exception {
        super.Resource_LocalResource_of_ReportUnit_PUT_200((HttpRequestBase)new HttpPut(), "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/properities_URI.JUNIT_NEW_FOLDER.JUNIT_PROPERTIES.xml", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/sales_ro.properties", "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/JUNIT_PROPERTIES", "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH");
        this.sendAndAssert_CE((HttpRequestBase)new HttpGet(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/JUNIT_PROPERTIES");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpGet(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/JUNIT_PROPERTIES");
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/JUNIT_PROPERTIES");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/JUNIT_PROPERTIES");
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_DomainDataSource_PUT_201() throws Exception {
        this.putSampleFolder();
        String domainURI = "/JUNIT_NEW_FOLDER/Simple_Domain";
        String schemaURI = "/JUNIT_NEW_FOLDER/Simple_Domain_files/Simple_Domain_schema";
        String JNDIURI = "/analysis/datasources/SugarCRMDataSourceJNDI";
        String schemaBinFilePath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/Simple_Domain_schema.xml";
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/domainDataSource_Path.JUNIT_NEW_FOLDER.Simple_Domain.xml";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(schemaBinFilePath));
        reqEntity.addPart(schemaURI, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.httpReqPro).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_DomainDataSource_PUT_403() throws Exception {
        this.putSampleFolder();
        this.loginToPROServer("joeuser", "joeuser");
        String domainURI = "/JUNIT_NEW_FOLDER/Simple_Domain";
        String schemaURI = "/JUNIT_NEW_FOLDER/Simple_Domain_files/Simple_Domain_schema";
        String JNDIURI = "/analysis/datasources/SugarCRMDataSourceJNDI";
        String schemaBinFilePath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/Simple_Domain_schema.xml";
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/domainDataSource_Path.JUNIT_NEW_FOLDER.Simple_Domain.xml";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(schemaBinFilePath));
        reqEntity.addPart(schemaURI, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.httpReqPro).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(403));
        this.loginToServer();
        this.deleteSampleFolder();
    }

    @Test
    public void PUT_200_Resource_DomainDataComplexSource() throws Exception {
        this.putSampleFolder();
        String domainURI = "/JUNIT_NEW_FOLDER/supermartDomain";
        String schemaURI = "/JUNIT_NEW_FOLDER/supermartDomain_files/supermartDomain_domain_schema";
        String propertiesURI = "/JUNIT_NEW_FOLDER/supermartDomain_files/supermart_domain.properties";
        String propertiesEnURI = "/JUNIT_NEW_FOLDER/supermartDomain_files/supermart_domain_en_US.properties";
        String securityFileURI = "/JUNIT_NEW_FOLDER/supermartDomain_files/supermartDomain_domain_security";
        String JNDIURI = "/analysis/datasources/SugarCRMDataSourceJNDI";
        String schemaBinFilePath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/supermartDomain_domain_schema.xml";
        String propertiesBin = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/supermart_domain.properties";
        String propertiesEnBin = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/supermart_domain_en_US.properties";
        String securityFileBin = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/supermartDomain_domain_security.xml";
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domain/supermartDomain_DataSource.xml";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(schemaBinFilePath));
        reqEntity.addPart(schemaURI, (ContentBody)bin);
        bin = new FileBody(new File(propertiesBin));
        reqEntity.addPart(propertiesURI, (ContentBody)bin);
        bin = new FileBody(new File(propertiesEnBin));
        reqEntity.addPart(propertiesEnURI, (ContentBody)bin);
        bin = new FileBody(new File(securityFileBin));
        reqEntity.addPart(securityFileURI, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.httpReqPro).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_Query_PUT_200() throws Exception {
        this.putSampleFolder();
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/query/CustomerCityQuery.xml";
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/resource/JUNIT_NEW_FOLDER", fileRd, 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/resource/JUNIT_NEW_FOLDER", fileRd, 201);
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/CustomerCityQuery");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/CustomerCityQuery");
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_DomainTopic_PUT_200() throws Exception {
        this.putSampleFolder();
        String cssURI = "/JUNIT_NEW_FOLDER/Simple_Domain_Topic_files/css_test";
        String cssBin = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domainTopic/css_test";
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domainTopic/Simple_Domain_Topic.xml";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(cssBin));
        reqEntity.addPart(cssURI, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.httpReqPro).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_DomainTopic_POST_BY_USER_403() throws Exception {
        this.putSampleFolder();
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_pro_uri.reports.xml", 200);
        this.loginToPROServer("joeuser", "joeuser");
        String cssURI = "/JUNIT_NEW_FOLDER/Simple_Domain_Topic_files/css_test";
        String cssBin = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domainTopic/css_test";
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/domainTopic/Simple_Domain_Topic.xml";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(cssBin));
        reqEntity.addPart(cssURI, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.httpReqPro).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(403));
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_Dashboard_PUT_200() throws Exception {
        this.putSampleFolder();
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/dashboard/dashboard.xml", 201);
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_ReportOptions_PUT_201() throws Exception {
        this.putSampleResource_PRO("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/reportOptions/reportOptions.xml", "/resource/reports/samples/");
        this.deleteResource_PRO("/resource/reports/samples/Poland");
    }

    @Test
    public void Report_PUT_201() throws Exception {
        this.putSampleResource_PRO("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/reportOptions/reportOptions.xml", "/resource/reports/samples/");
        this.deleteResource_PRO("/resource/reports/samples/Poland");
    }

    @Test
    public void testVerify_new_user_of_new_tenant_has_roles() throws Exception {
        this.loginToPROServer("superuser", "superuser");
        Tenant tenant = this.sampleOrganizationDescriptor();
        tenant.setParentId(null);
        this.createRESTOrganization(tenant, 201);
        this.loginToPROServer("jasperadmin", "jasperadmin", tenant.getId());
        WSRole[] wsRoles = this.getRESTRoles("");
        Assert.assertEquals((long)5L, (long)wsRoles.length);
        this.loginToPROServer("superuser", "superuser");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/organization/" + tenant.getId());
    }

    @Test
    public void testVerify_cant_delete_himself() throws Exception {
        this.loginToServer();
        WSUser wsUser = this.sampleUserDescriptor();
        wsUser.setTenantId("organization_1");
        WSRole[] roles = new WSRole[]{this.getRESTRoles(RESTTestUtilsAndConsts.ROLE_ADMINISTRATOR)[0], this.getRESTRoles(RESTTestUtilsAndConsts.ROLE_USER)[0]};
        wsUser.setRoles(roles);
        this.createRESTUser(wsUser, 201);
        this.verifyUser(wsUser, true);
        this.loginToPROServer(wsUser.getUsername(), wsUser.getPassword(), wsUser.getTenantId());
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/" + wsUser.getUsername(), 403);
        this.loginToServer();
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/" + wsUser.getUsername());
    }

    @Test
    public void testGet_Put_delete_permissions_for_role() throws Exception {
        this.loginToServer();
        JAXBList<ObjectPermission> permissionsList = this.getRESTPermissions("/reports", 200);
        WSRole wsRole = null;
        if (permissionsList.size() > 0) {
            permissionsList.get(0).setPermissionMask(1);
        } else {
            wsRole = this.sampleRoleDescriptor();
            this.createRESTRole(wsRole, 201);
            permissionsList.add(this.getSampleObjectPermission("repo:/reports", this.convertWSRole(wsRole), 1));
        }
        this.putRESTPermissions(permissionsList, 200);
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("roles", "ROLE_USER"));
        qparams.add((NameValuePair)new BasicNameValuePair("users", null));
        this.deleteRESTPermission("/reports", qparams, 200);
        if (wsRole != null) {
            this.deleteRESTRole(wsRole.getRoleName());
        }
    }

    public JAXBList<ObjectPermission> getRESTPermissions(String resource_url, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpGet();
        this.httpRes = this.sendRequestPRO(this.httpReq, "/permission" + resource_url);
        PUTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        if (expectedStatsCode != 200) {
            PUTTest.getResponseBody(this.httpRes.getEntity());
            return null;
        }
        InputStream getPermissionsResp = this.httpRes.getEntity().getContent();
        JAXBList foundPermissions = (JAXBList)RESTUtils.unmarshal(getPermissionsResp, JAXBList.class, ObjectPermissionImpl.class, UserImpl.class, RoleImpl.class);
        return foundPermissions;
    }

    public WSRole sampleRoleDescriptor() {
        WSRole wsRole = new WSRole();
        wsRole.setRoleName("REST_JUNIT_ROLE");
        wsRole.setExternallyDefined(Boolean.valueOf(true));
        wsRole.setTenantId("organization_1");
        return wsRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRESTPermission(String resource_url, List<NameValuePair> params, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpDelete();
        this.httpRes = this.sendRequestPRO(this.httpReq, "/permission" + resource_url, params);
        try {
            PUTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        }
        finally {
            PUTTest.getResponseBody(this.httpRes.getEntity());
        }
    }
}

