/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.rest.test.RESTTest;
import com.jaspersoft.jasperserver.rest.test.RESTTestUtilsAndConsts;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class POSTTest
extends RESTTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.httpReqCE = new HttpPost();
        this.httpReqPro = new HttpPost();
    }

    @Test
    public void Job_Post_200() throws Exception {
        this.putSampleJob_CE();
        int ceJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_CE());
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update/reportJob_URI.reports.samples.allaccounts.xml"));
        ((HttpEntityEnclosingRequestBase)this.httpReqCE).setEntity((HttpEntity)reqEntity);
        this.sendAndAssert_CE(this.httpReqCE, "/job/" + ceJobIndex);
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/job/" + ceJobIndex);
        this.putSampleJob_PRO();
        int proJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_PRO());
        reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update/reportJob_URI.reports.samples.allaccounts.xml"));
        ((HttpEntityEnclosingRequestBase)this.httpReqPro).setEntity((HttpEntity)reqEntity);
        this.sendAndAssert_PRO(this.httpReqPro, "/job/" + proJobIndex);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/job/" + proJobIndex);
    }

    @Test
    public void Organization_Post_200() throws Exception {
    }

    @Test
    public void Permission_Post_200() throws Exception {
        this.putSampleFolder();
        this.sendAndAssert_CE(this.httpReqCE, "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_ce_uri.reports.xml", 200);
        this.sendAndAssert_PRO(this.httpReqPro, "/permission/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/permission/permission_pro_uri.reports.xml", 200);
        this.deleteSampleFolder();
    }

    @Test
    public void User_Post_200() throws Exception {
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_CE.xml", 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/user", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/JUNIT_USER_PRO.xml", 201);
        this.sendAndAssert_CE(this.httpReqCE, "/user/JUNIT_USER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update/JUNIT_USER_CE.xml");
        this.sendAndAssert_PRO(this.httpReqPro, "/user/JUNIT_USER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update/JUNIT_USER_PRO.xml");
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/user/JUNIT_USER%7Corganization_1");
    }

    @Test
    public void Role_Post_200() throws Exception {
    }

    @Test
    public void resource_Folder_POST_200() throws Exception {
    }

    @Test
    public void resource_Folder_MOVETO_POST_200() throws Exception {
        ArrayList<Object> qparams = new ArrayList<NameValuePair>();
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
        qparams.add(new BasicNameValuePair("moveTo", "/JUNIT_NEW_FOLDER"));
        this.httpRes = this.sendRequestCE(this.httpReqCE, "/resource/reports", qparams);
        Assert.assertTrue((String)"moving reports to JUNIT NEW FOLDER", (boolean)this.isValidResposnse());
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/resource/reports", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.reports.xml", 201);
        qparams = new ArrayList();
        qparams.add((NameValuePair)new BasicNameValuePair("moveTo", "/reports"));
        this.httpRes = this.sendRequestCE(this.httpReqCE, "/resource/JUNIT_NEW_FOLDER/reports/samples", qparams);
        Assert.assertTrue((String)"moving back to reports", (boolean)this.isValidResposnse());
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
        qparams = new ArrayList();
        qparams.add((NameValuePair)new BasicNameValuePair("moveTo", "/JUNIT_NEW_FOLDER"));
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/public", qparams);
        Assert.assertTrue((String)"moving reports to JUNIT NEW FOLDER", (boolean)this.isValidResposnse());
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/resource/public", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.public.xml", 201);
        qparams = new ArrayList();
        qparams.add((NameValuePair)new BasicNameValuePair("moveTo", "/public"));
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER/public/adhoc", qparams);
        Assert.assertTrue((String)"moving back to reports", (boolean)this.isValidResposnse());
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER/public/audit", qparams);
        Assert.assertTrue((String)"moving back to reports", (boolean)this.isValidResposnse());
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
    }

    @Test
    public void resource_Folder_COPYTO_POST_200() throws Exception {
        ArrayList<Object> qparams = new ArrayList<NameValuePair>();
        qparams.add(new BasicNameValuePair("copyTo", "/JUNIT_NEW_FOLDER"));
        this.httpRes = this.sendRequestCE(this.httpReqCE, "/resource/reports", qparams);
        Assert.assertTrue((String)"copying reports to JUNIT NEW FOLDER", (boolean)this.isValidResposnse());
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
        qparams = new ArrayList();
        qparams.add((NameValuePair)new BasicNameValuePair("copyTo", "/JUNIT_NEW_FOLDER"));
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/public", qparams);
        Assert.assertTrue((String)"copy reports to JUNIT NEW FOLDER", (boolean)this.isValidResposnse());
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
    }

    @Test
    public void resource_IMG_POST_200() throws Exception {
        this.putSampleFolderAndFile();
        this.putSampleFileInSampleFolder((HttpRequestBase)new HttpPost(), "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/image_URI.JUNIT_NEW_FOLDER.JUNIT_IMAGE_FILE.xml", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/differentPic.jpg", "/JUNIT_IMAGE_FILE");
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_LocalResource_IN_ReportUnit_POST_200() throws Exception {
        this.putSampleReport();
        String fileRDPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/image_URI.JUNIT_NEW_FOLDER.JUNIT_REPORT_UNIT_SALES_BY_MONTH_files.Logo.xml";
        String fileBinPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/differentPic.jpg";
        this.tempHttpReq = new HttpPost();
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRDPath))));
        FileBody bin = new FileBody(new File(fileBinPath));
        reqEntity.addPart("/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo", (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestCE(this.tempHttpReq, "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo");
        Assert.assertTrue((String)"basic response check did not pass", (this.isValidResposnse(this.httpRes, 201) || this.httpRes.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
        this.httpRes = this.sendRequestPRO(this.tempHttpReq, "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo");
        Assert.assertTrue((String)"basic response check did not pass", (this.isValidResposnse(201) || this.httpRes.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("fileData", "true"));
        this.httpRes = this.sendRequestCE((HttpRequestBase)new HttpGet(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo", qparams);
        Assert.assertTrue((String)"wrong file size: ", (this.isValidResposnse() && this.httpRes.getEntity().getContentLength() == -1L ? 1 : 0) != 0);
        this.httpRes = this.sendRequestPRO((HttpRequestBase)new HttpGet(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo", qparams);
        Assert.assertTrue((String)"wrong file size: ", (this.isValidResposnse() && this.httpRes.getEntity().getContentLength() == -1L ? 1 : 0) != 0);
        this.deleteSampleFolder();
    }

    @Test
    public void Resources_InputControl_POST_200() throws Exception {
        this.putSampleInputControlInSampleFolder();
        this.putSampleInputControlInSampleFolder((HttpRequestBase)new HttpPost(), "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update/inputControl_URI.JUNIT_NEW_FOLDER.JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE.xml", "/JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE", 200);
        this.deleteSampleInputControl();
        this.deleteSampleFolder();
    }

    @Test
    public void Resource_Query_POST_200() throws Exception {
        this.putSampleFolder();
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/query/CustomerCityQuery.xml";
        this.sendAndAssert_CE((HttpRequestBase)new HttpPut(), "/resource/JUNIT_NEW_FOLDER", fileRd, 201);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPut(), "/resource/JUNIT_NEW_FOLDER", fileRd, 201);
        fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/query/CustomerCityQuery_update.xml";
        this.sendAndAssert_CE((HttpRequestBase)new HttpPost(), "/resource/JUNIT_NEW_FOLDER/CustomerCityQuery", fileRd, 200);
        this.sendAndAssert_PRO((HttpRequestBase)new HttpPost(), "/resource/JUNIT_NEW_FOLDER/CustomerCityQuery", fileRd, 200);
        this.deleteSampleFolder();
    }
}

