/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.rest.test.RESTTest;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DELETETest
extends RESTTest {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String SAMPLE_LINKED_RESOURCE_SERVER_PATH = "/resource/datasources/JServerJNDIDS";

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.httpReqCE = new HttpDelete();
        this.httpReqPro = new HttpDelete();
    }

    @Test
    public void Delete200Job() throws Exception {
    }

    @Test
    public void User_Delete_404() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/user/none_existing_user_21", 404);
    }

    @Test
    public void Delete200Role() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/role/ROLE_SUPERUSER", 404);
    }

    @Test
    public void Role_Delete_404_DELETE_A_NON_EXISTING_ROLE() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/role/ROLE_SBLABLA", 404);
    }

    @Test
    public void Role_Delete_403_DELETE_SUPERUSER() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/role/ROLE_SUPERUSER", 404);
    }

    @Test
    public void Delete200Permission() throws Exception {
        ArrayList<NameValuePair> ceQparams = new ArrayList<NameValuePair>();
        ceQparams.add((NameValuePair)new BasicNameValuePair("joeuser", "30"));
        this.httpRes = this.sendRequestCE(this.httpReqCE, "/permission/reports", ceQparams);
        ArrayList<NameValuePair> proQparams = new ArrayList<NameValuePair>();
        proQparams.add((NameValuePair)new BasicNameValuePair("CaliforniaUser/organization_1", "30"));
        this.httpRes = this.sendRequestPRO(this.httpReqCE, "/permission/reports", proQparams);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    @Test
    public void Delete200ProfileAttributes() throws Exception {
    }

    @Test
    public void Delete200Tenant() throws Exception {
        this.httpRes = this.sendRequestPRO((HttpRequestBase)new HttpDelete(), "/organization/JUNIT_BLABLA");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(404));
    }

    @Test
    public void Delete200Domain() throws Exception {
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/Domains/domainJunit");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    @Test
    public void Delete403() throws Exception {
        this.httpRes = this.sendRequestCE(this.httpReqCE, SAMPLE_LINKED_RESOURCE_SERVER_PATH);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(500));
    }

    @Test
    public void Delete_403_A_REFERENCED_RESOURCE() throws Exception {
        this.httpRes = this.sendRequestCE((HttpRequestBase)new HttpDelete(), "/resource/analysis/datasources/SugarCRMDataSourceJNDI");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(403));
    }

    @Test
    public void Delete404() throws Exception {
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(500));
    }
}

