/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.core.util.validators.InputValidator;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.authority.WSUserSearchCriteria;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserAndRoleManagementService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="restUserService")
public class RESTUser
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTUser.class);
    @Resource(name="concreteUserAndRoleManagementService")
    private UserAndRoleManagementService userAndRoleManagementService;
    @Resource(name="emailInputValidator")
    private InputValidator emailValidator;

    public UserAndRoleManagementService getUserAndRoleManagementService() {
        return this.userAndRoleManagementService;
    }

    public void setUserAndRoleManagementService(UserAndRoleManagementService userAndRoleManagementService) {
        this.userAndRoleManagementService = userAndRoleManagementService;
    }

    public InputValidator getEmailValidator() {
        return this.emailValidator;
    }

    public void setEmailValidator(InputValidator emailValidator) {
        this.emailValidator = emailValidator;
    }

    @Override
    @Transactional
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        super.execute(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String searchCriteria = this.getUserSearchInformation(req.getPathInfo());
        WSUser[] users = null;
        WSUserSearchCriteria wsUserSearchCriteria = this.restUtils.getWSUserSearchCriteria(searchCriteria);
        try {
            users = this.userAndRoleManagementService.findUsers(wsUserSearchCriteria);
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(404, "could not locate users in uri: " + wsUserSearchCriteria.getName() + axisFault.getLocalizedMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + users.length + " users were found"));
        }
        String marshal = this.generateSummeryReport(users);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marshaling OK");
        }
        this.restUtils.setStatusAndBody(200, resp, marshal);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            String userName = this.restUtils.extractResourceName(req.getPathInfo());
            WSUser user = this.restUtils.populateServiceObject(this.restUtils.unmarshal(WSUser.class, (InputStream)req.getInputStream()));
            if (log.isDebugEnabled()) {
                log.debug((Object)"un Marshaling OK");
            }
            if (this.validateUserForPutOrUpdate(user)) {
                if (this.isAlreadyAUser(user)) {
                    throw new ServiceException(403, "user " + user.getUsername() + "already exists");
                }
            } else {
                throw new ServiceException(400, "check request parameters");
            }
            this.userAndRoleManagementService.putUser(user);
            this.restUtils.setStatusAndBody(201, resp, "");
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(400, axisFault.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ServiceException(400, e.getLocalizedMessage());
        }
        catch (JAXBException e) {
            throw new ServiceException(400, e.getLocalizedMessage());
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            WSUserSearchCriteria c = this.restUtils.getWSUserSearchCriteria(this.getUserSearchInformation(req.getPathInfo()));
            WSUser userToDelete = new WSUser();
            userToDelete.setUsername(c.getName());
            userToDelete.setTenantId(c.getTenantId());
            if (this.isLoggedInUser(this.restUtils.getCurrentlyLoggedUser(), userToDelete)) {
                throw new ServiceException(403, "user: " + userToDelete.getUsername() + " can not to delete himself");
            }
            if (this.validateUserForGetOrDelete(userToDelete)) {
                if (!this.isAlreadyAUser(userToDelete)) {
                    throw new ServiceException(404, "user: " + userToDelete.getUsername() + " was not found");
                }
            } else {
                throw new ServiceException(400, "check request parameters");
            }
            this.userAndRoleManagementService.deleteUser(userToDelete);
            if (log.isDebugEnabled()) {
                log.debug((Object)(userToDelete.getUsername() + " was deleted"));
            }
            this.restUtils.setStatusAndBody(200, resp, "");
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(400, axisFault.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ServiceException(400, e.getLocalizedMessage());
        }
    }

    protected boolean isLoggedInUser(UserDetails currentlyLoggedUser, WSUser userToDelete) {
        return currentlyLoggedUser.getUsername().equals(userToDelete.getUsername());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            String userName = this.restUtils.extractResourceName(req.getPathInfo());
            WSUser user = this.restUtils.unmarshal(WSUser.class, (InputStream)req.getInputStream());
            if (!this.isUserNameValid(userName, user).booleanValue()) {
                throw new ServiceException(400, "check your request parameters");
            }
            this.updateUser(user);
            this.restUtils.setStatusAndBody(200, resp, "");
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(axisFault.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ServiceException(e.getLocalizedMessage());
        }
        catch (JAXBException e) {
            throw new ServiceException(400, "could not marshal the user descriptor");
        }
    }

    protected Boolean isUserNameValid(String userName, WSUser user) {
        return userName != null && user != null && userName.equals(user.getUsername());
    }

    private void updateUser(WSUser user) throws ServiceException {
        block6: {
            try {
                WSUser[] users;
                WSUserSearchCriteria criteria = new WSUserSearchCriteria();
                criteria.setName(user.getUsername());
                criteria.setTenantId(user.getTenantId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("criteria was created: user: " + criteria.getName() + " tenant: " + criteria.getTenantId()));
                }
                if ((users = this.userAndRoleManagementService.findUsers(criteria)).length != 0) {
                    WSUser existing = users[0];
                    this.doUpdateUser(existing, user);
                    this.userAndRoleManagementService.putUser(existing);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("user: " + user.getUsername() + " was updated"));
                    }
                    break block6;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("could not find user: " + user.getUsername() + " to update"));
                }
                throw new ServiceException(404, "User " + user.getUsername() + " not found");
            }
            catch (AxisFault axisFault) {
                throw new ServiceException(axisFault.getLocalizedMessage());
            }
        }
    }

    private String generateSummeryReport(WSUser[] users) throws ServiceException {
        try {
            StringWriter sw = new StringWriter();
            sw.append("<users>");
            for (int i = 0; i < users.length; ++i) {
                users[i].setPassword(null);
                this.restUtils.getMarshaller(WSUser.class, WSRole.class).marshal((Object)users[i], (Writer)sw);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("finished marshaling user: " + users[i].getTenantId()));
            }
            sw.append("</users>");
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    private String getUserSearchInformation(String path) {
        String criteria = path.substring(path.indexOf("/user/") + "/user/".length(), path.length());
        if (criteria.endsWith("/")) {
            criteria = criteria.substring(0, criteria.length() - 2);
        }
        return criteria;
    }

    protected WSUser fillUserDetails(WSUser user) {
        return user;
    }

    private boolean isAlreadyAUser(WSUser user) throws AxisFault {
        WSUserSearchCriteria criteria = new WSUserSearchCriteria();
        criteria.setName(user.getUsername());
        criteria.setTenantId(user.getTenantId());
        return this.userAndRoleManagementService.findUsers(criteria).length > 0;
    }

    protected boolean validateUserForPutOrUpdate(WSUser user) {
        boolean ret = ((user = this.fillUserDetails(user)).getEmailAddress() == null || "".equals(user.getEmailAddress()) || this.emailValidator.isValid((Object)user.getEmailAddress())) && this.validateUserForGetOrDelete(user) && (user.getExternallyDefined() != false || user.getPassword() != null && !user.getPassword().equals(""));
        return ret;
    }

    protected boolean validateUserForGetOrDelete(WSUser user) {
        return (user = this.fillUserDetails(user)).getUsername() != null && !user.getUsername().equals("");
    }

    private void doUpdateUser(WSUser oldUser, WSUser newUser) {
        if (newUser.getEmailAddress() != null) {
            oldUser.setEmailAddress(newUser.getEmailAddress());
        }
        if (newUser.getFullName() != null) {
            oldUser.setFullName(newUser.getFullName());
        }
        if (newUser.getEnabled() != null) {
            oldUser.setEnabled(newUser.getEnabled());
        }
        if (newUser.getExternallyDefined() != null) {
            oldUser.setExternallyDefined(newUser.getExternallyDefined());
        }
        if (newUser.getRoles() != null) {
            oldUser.setRoles(newUser.getRoles());
        }
        if (newUser.getPassword() != null) {
            if (!newUser.getPassword().equals(oldUser.getPassword())) {
                oldUser.setPreviousPasswordChangeTime(new Date());
            }
            oldUser.setPassword(newUser.getPassword());
        }
    }
}

