/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSRoleSearchCriteria;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserAndRoleManagementService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="restRoleService")
public class RESTRole
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTRole.class);
    private static final String SERVICE_NAME = "role";
    @Resource(name="concreteUserAndRoleManagementService")
    private UserAndRoleManagementService userAndRoleManagementService;
    @Resource
    private ConfigurationBean configurationBean;

    public ConfigurationBean getConfigurationBean() {
        return this.configurationBean;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
    }

    public UserAndRoleManagementService getUserAndRoleManagementService() {
        return this.userAndRoleManagementService;
    }

    public void setUserAndRoleManagementService(UserAndRoleManagementService userAndRoleManagementService) {
        this.userAndRoleManagementService = userAndRoleManagementService;
    }

    @Override
    @Transactional
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        super.execute(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        WSRoleSearchCriteria criteria = this.restUtils.populateServiceObject(req.getPathInfo(), req.getParameterMap(), WSRoleSearchCriteria.class);
        WSRole[] roles = null;
        try {
            roles = this.userAndRoleManagementService.findRoles(criteria);
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(404, "could not locate roles in uri: " + criteria.getRoleName() + axisFault.getLocalizedMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(roles.length + " roles were found"));
        }
        String marshal = this.generateSummeryReport(roles);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marshaling OK");
        }
        this.restUtils.setStatusAndBody(200, resp, marshal);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            WSRole role = this.restUtils.unmarshal(WSRole.class, (InputStream)req.getInputStream());
            role = this.restUtils.populateServiceObject(role);
            if (this.userAndRoleManagementService.findRoles(this.wsRoleToWSRoleSearchCriteria(role)).length != 0) {
                throw new IllegalArgumentException("can not create new role: " + role.getRoleName() + ". it already exists");
            }
            this.userAndRoleManagementService.putRole(role);
            this.restUtils.setStatusAndBody(201, resp, "");
        }
        catch (Exception e) {
            throw new ServiceException(400, e.getLocalizedMessage());
        }
    }

    private WSRoleSearchCriteria wsRoleToWSRoleSearchCriteria(WSRole role) {
        WSRoleSearchCriteria criteria = new WSRoleSearchCriteria();
        criteria.setRoleName(role.getRoleName());
        criteria.setTenantId(role.getTenantId());
        return criteria;
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        block4: {
            WSRole role = this.restUtils.populateServiceObject(req.getPathInfo(), req.getParameterMap(), WSRole.class);
            WSRoleSearchCriteria criteria = this.restUtils.populateServiceObject(req.getPathInfo(), req.getParameterMap(), WSRoleSearchCriteria.class);
            WSRole[] roles = null;
            try {
                roles = this.userAndRoleManagementService.findRoles(criteria);
                if (roles != null && roles.length != 0) {
                    this.userAndRoleManagementService.deleteRole(role);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(role + " role were deleted"));
                    }
                    break block4;
                }
                throw new ServiceException(404, "role: " + role + " was not found");
            }
            catch (AxisFault axisFault) {
                throw new ServiceException(400, axisFault.getLocalizedMessage());
            }
        }
        this.restUtils.setStatusAndBody(200, resp, "");
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            String searchCriteria = this.restUtils.extractResourceName(SERVICE_NAME, req.getPathInfo());
            WSRole role = this.restUtils.unmarshal(WSRole.class, (InputStream)req.getInputStream());
            role = this.restUtils.populateServiceObject(role);
            this.updateRole(role, this.restUtils.getWSRoleSearchCriteria(searchCriteria));
            this.restUtils.setStatusAndBody(200, resp, "");
        }
        catch (IOException e) {
            throw new ServiceException(e.getLocalizedMessage());
        }
        catch (JAXBException e) {
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    private void updateRole(WSRole role, WSRoleSearchCriteria wsRoleSearchCriteria) {
        try {
            WSRole[] roles = this.userAndRoleManagementService.findRoles(wsRoleSearchCriteria);
            if (roles.length != 1) {
                throw new IllegalStateException("found " + roles.length + " roles to be update");
            }
            String newName = role.getRoleName();
            if (newName == null || "".equals(newName)) {
                throw new ServiceException(400, "New name is null.");
            }
            String nameWithoutNotSupportedSymbols = newName.replaceAll(this.configurationBean.getRoleNameNotSupportedSymbols(), "");
            if (nameWithoutNotSupportedSymbols.length() != newName.length()) {
                throw new ServiceException(400, "Role name contains not supported symbols");
            }
            this.userAndRoleManagementService.deleteRole(roles[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("role: " + roles[0].getRoleName() + " was deleted"));
            }
            this.userAndRoleManagementService.putRole(role);
            if (log.isDebugEnabled()) {
                log.debug((Object)("role: " + role.getRoleName() + " was added"));
            }
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(axisFault.getLocalizedMessage());
        }
    }

    private String generateSummeryReport(WSRole[] roles) throws ServiceException {
        try {
            StringWriter sw = new StringWriter();
            sw.append("<roles>");
            for (int i = 0; i < roles.length; ++i) {
                this.restUtils.getMarshaller(WSUser.class, WSRole.class).marshal((Object)roles[i], (Writer)sw);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("finished marshaling role: " + roles[i].getTenantId()));
            }
            sw.append("</roles>");
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new ServiceException(e.getLocalizedMessage());
        }
    }
}

