/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.ws.axis2.scheduling.ReportSchedulerService;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component(value="restJobSchedService")
public class RESTJob
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTJob.class);
    private static final int DISREGARD_VERSION = -1;
    @Resource(name="concreteReportSchedulerService")
    private ReportSchedulerService reportSchedulerService;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            long jobId = this.getJobId(this.restUtils.extractRepositoryUri(req.getPathInfo()));
            Job job = this.reportSchedulerService.getJob(jobId);
            StringWriter sw = new StringWriter();
            this.restUtils.getMarshaller(Job.class).marshal((Object)job, (Writer)sw);
            this.restUtils.setStatusAndBody(200, resp, sw.toString());
        }
        catch (JAXBException e) {
            throw new ServiceException(500, e.getMessage());
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(404, axisFault.getMessage());
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        long jobId = this.getJobId(this.restUtils.extractRepositoryUri(req.getPathInfo()));
        try {
            this.reportSchedulerService.deleteJob(jobId);
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(404, axisFault.getMessage());
        }
        Object xml = null;
        this.restUtils.setStatusAndBody(200, resp, "");
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            StringWriter sw = new StringWriter();
            Job job = this.restUtils.unmarshal(Job.class, (InputStream)req.getInputStream());
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof UserDetails) {
                UserDetails userDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                job.setUsername(userDetails.getUsername());
            }
            try {
                job = this.reportSchedulerService.scheduleJob(job);
            }
            catch (AxisFault axisFault) {
                throw new ServiceException(400, "could not schedule job to report: " + job.getReportUnitURI() + ". check job parameters\n" + axisFault.getMessage());
            }
            this.restUtils.getMarshaller(Job.class).marshal((Object)job, (Writer)sw);
            this.restUtils.setStatusAndBody(201, resp, sw.toString());
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(404, axisFault.getMessage());
        }
        catch (IOException e) {
            throw new ServiceException(400, e.getMessage());
        }
        catch (JAXBException e) {
            throw new ServiceException(400, "please check the request job descriptor");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            long jobId = this.getJobId(this.restUtils.extractRepositoryUri(req.getPathInfo()));
            Job job = this.restUtils.unmarshal(Job.class, (InputStream)req.getInputStream());
            if (job.getId() != jobId) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("job descriptor id " + job.getId() + " and request id " + jobId + "do not match. assigning the request id to as the job id"));
                }
                job.setId(jobId);
            }
            if (job.getVersion() == -1 && this.reportSchedulerService.getJob(jobId) != null) {
                Job oldJob = this.reportSchedulerService.getJob(jobId);
                job.setVersion(oldJob.getVersion());
            }
            this.reportSchedulerService.updateJob(job);
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(404, axisFault.getMessage());
        }
        catch (IOException e) {
            throw new ServiceException(500, e.getMessage());
        }
        catch (JAXBException e) {
            throw new ServiceException(400, "please check the request job descriptor");
        }
    }

    private long getJobId(String uri) throws ServiceException {
        if (uri == null) {
            throw new ServiceException(400, "malformed input parameter");
        }
        String jobId = uri.replace("/", "");
        return Long.parseLong(jobId);
    }

    public ReportSchedulerService getReportSchedulerService() {
        return this.reportSchedulerService;
    }

    public void setReportSchedulerService(ReportSchedulerService reportSchedulerService) {
        this.reportSchedulerService = reportSchedulerService;
    }
}

