/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.processors;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ExternalUserService;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalAuthProperties;
import com.jaspersoft.jasperserver.api.security.externalAuth.processors.AbstractExternalUserProcessor;
import com.jaspersoft.jasperserver.api.security.externalAuth.processors.ProcessorData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;

public class ExternalUserSetupProcessor
extends AbstractExternalUserProcessor {
    private static final Logger logger = LogManager.getLogger(ExternalUserSetupProcessor.class);
    private static final String ROLE_SUFFIX = "|*";
    private List defaultInternalRoles;
    private ExternalAuthProperties externalAuthProperties = new ExternalAuthProperties();
    private Map<String, String> organizationRoleMap = Collections.emptyMap();
    private String permittedExternalRoleNameRegex = "[A-Za-z0-9_]+";
    private List<String> adminUsernames;
    private List<String> defaultAdminRoles;
    private String conflictingExternalInternalRoleNameSuffix = "EXT";

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    protected User getUser() {
        ProcessorData processorData = ProcessorData.getInstance();
        UserDetails userDetails = (UserDetails)processorData.getData(ProcessorData.Key.EXTERNAL_AUTH_DETAILS);
        return this.getUserAuthorityService().getUser((ExecutionContext)new ExecutionContextImpl(), userDetails.getUsername());
    }

    public void process() {
        ProcessorData processorData = ProcessorData.getInstance();
        UserDetails userDetails = (UserDetails)processorData.getData(ProcessorData.Key.EXTERNAL_AUTH_DETAILS);
        try {
            String logoutUrl;
            String userName = userDetails.getUsername();
            logger.debug((Object)("Setting up external user: " + userName));
            User user = this.getUser();
            String string = logoutUrl = this.externalAuthProperties != null ? this.externalAuthProperties.getLogoutUrl() : null;
            if (user == null) {
                user = this.createNewExternalUser(userName);
            } else {
                if (!user.isEnabled()) {
                    throw new JSException("External user " + user.getUsername() + " was disabled on jasperserver. Please contact an admin user to re-enable. " + (logoutUrl != null && logoutUrl.length() > 0 ? "Click <a href=\"" + logoutUrl + "\">logout</a> to exit from external system." : ""));
                }
                if (!user.isExternallyDefined()) {
                    throw new JSException("Internally defined user " + user.getUsername() + " already exists. Please contact an admin user to resolve the issue. " + (logoutUrl != null && logoutUrl.length() > 0 ? "Click <a href=\"" + logoutUrl + "\">logout</a> to exit from external system." : ""));
                }
            }
            GrantedAuthority[] grantedAuthorities = (GrantedAuthority[])processorData.getData(ProcessorData.Key.EXTERNAL_AUTHORITIES);
            String tenantId = (String)processorData.getData(ProcessorData.Key.EXTERNAL_JRS_USER_TENANT_ID);
            Set<Role> externalRoles = this.convertGrantedAuthoritiesToRoles(grantedAuthorities, tenantId);
            user.setTenantId(tenantId);
            Set roles = this.persistRoles(externalRoles);
            this.alignInternalAndExternalUser(roles, user);
            ((ExternalUserService)this.getUserAuthorityService()).makeUserLoggedIn(user);
        }
        catch (RuntimeException e) {
            String userName = userDetails != null ? userDetails.getUsername() : "";
            logger.error((Object)("Error processing external user " + userName + ": " + e.getMessage()));
            throw e;
        }
    }

    protected User createNewExternalUser(String userName) {
        User user = this.getUserAuthorityService().newUser((ExecutionContext)new ExecutionContextImpl());
        user.setUsername(userName);
        user.setFullName(userName);
        user.setExternallyDefined(true);
        user.setEnabled(true);
        logger.warn((Object)("Created new external user: " + user.getUsername()));
        return user;
    }

    protected Set persistRoles(Set<Role> roles) {
        HashSet<Role> persistedRoles = new HashSet<Role>();
        for (Role r : roles) {
            persistedRoles.add(this.getOrCreateRole(r));
        }
        return persistedRoles;
    }

    protected void alignInternalAndExternalUser(Set externalRoles, User user) {
        Collection defaultInternalRolesToAdd;
        Collection rolesNeedingRemoval;
        Collection newExternalRoles;
        Predicate externallyDefinedRoles = new Predicate(){

            public boolean evaluate(Object input) {
                if (!(input instanceof Role)) {
                    return false;
                }
                return ((Role)input).isExternallyDefined();
            }
        };
        Set currentRoles = user.getRoles();
        boolean persistUserNeeded = currentRoles.size() == 0;
        Collection currentExternalRoles = CollectionUtils.select((Collection)user.getRoles(), (Predicate)externallyDefinedRoles);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Login of external User: " + user.getUsername()));
            logger.debug((Object)("Roles from authentication:\n" + this.roleCollectionToString(externalRoles)));
            logger.debug((Object)("Current roles from metadata:\n" + this.roleCollectionToString(user.getRoles())));
            logger.debug((Object)("Current external roles for user from metadata: " + user.getUsername() + "\n" + this.roleCollectionToString(currentExternalRoles)));
        }
        if ((newExternalRoles = CollectionUtils.subtract((Collection)externalRoles, (Collection)currentExternalRoles)).size() > 0) {
            currentRoles.addAll(newExternalRoles);
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Added following external roles to: " + user.getUsername() + "\n" + this.roleCollectionToString(newExternalRoles)));
            }
            persistUserNeeded = true;
        }
        if ((rolesNeedingRemoval = CollectionUtils.subtract((Collection)currentExternalRoles, (Collection)externalRoles)).size() > 0) {
            currentRoles.removeAll(rolesNeedingRemoval);
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Removed following external roles from: " + user.getUsername() + "\n" + this.roleCollectionToString(rolesNeedingRemoval)));
            }
            persistUserNeeded = true;
        }
        if ((defaultInternalRolesToAdd = CollectionUtils.subtract((Collection)this.getNewDefaultInternalRoles(user.getUsername()), (Collection)currentRoles)).size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Default internal roles: " + this.roleCollectionToString(this.getNewDefaultInternalRoles(user.getUsername()))));
            }
            currentRoles.addAll(defaultInternalRolesToAdd);
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Added following new default internal roles to: " + user.getUsername() + "\n" + this.roleCollectionToString(defaultInternalRolesToAdd)));
            }
            persistUserNeeded = true;
        }
        if (persistUserNeeded) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Updated user: " + user.getUsername() + ". Roles are now:\n" + this.roleCollectionToString(currentRoles)));
            }
            user.setRoles(currentRoles);
            this.getUserAuthorityService().putUser((ExecutionContext)new ExecutionContextImpl(), user);
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Updated user: " + user.getUsername() + ". Roles are now:\n" + this.roleCollectionToString(currentRoles)));
            }
        }
    }

    protected Set<Role> convertGrantedAuthoritiesToRoles(GrantedAuthority[] authorities, String tenantId) {
        HashSet<Role> set = new HashSet<Role>();
        if (authorities == null || authorities.length == 0) {
            return set;
        }
        UserAuthorityService userAuthorityService = this.getUserAuthorityService();
        for (GrantedAuthority auth : authorities) {
            String authorityName = auth.getAuthority();
            if (authorityName == null) continue;
            if (!authorityName.matches(this.permittedExternalRoleNameRegex)) {
                ProcessorData processorData = ProcessorData.getInstance();
                UserDetails userDetails = (UserDetails)processorData.getData(ProcessorData.Key.EXTERNAL_AUTH_DETAILS);
                logger.warn((Object)("External role " + authorityName + " has forbidden characters " + "according to permittedExternalRoleNameRegex: " + this.permittedExternalRoleNameRegex + ".\nSkipping this role for the user " + (userDetails != null && userDetails.getUsername() != null ? userDetails.getUsername() : "")));
                continue;
            }
            authorityName = authorityName.toUpperCase().trim();
            Role role = userAuthorityService.newRole((ExecutionContext)new ExecutionContextImpl());
            String internalRoleName = this.organizationRoleMap.get(authorityName);
            if (internalRoleName != null) {
                if (internalRoleName.endsWith(ROLE_SUFFIX)) {
                    internalRoleName = internalRoleName.substring(0, internalRoleName.length() - ROLE_SUFFIX.length());
                    role.setTenantId(tenantId);
                }
                role.setRoleName(internalRoleName);
                role.setExternallyDefined(false);
            } else {
                role.setRoleName(authorityName);
                role.setExternallyDefined(true);
                role.setTenantId(tenantId);
            }
            set.add(role);
        }
        return set;
    }

    private String roleCollectionToString(Collection coll) {
        Iterator it = coll.iterator();
        StringBuffer rolesPrint = new StringBuffer();
        while (it.hasNext()) {
            String s = ((Role)it.next()).getRoleName();
            rolesPrint.append(s).append("\n");
        }
        return rolesPrint.toString();
    }

    private Set getNewDefaultInternalRoles(String username) {
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        HashSet<Role> set = new HashSet<Role>();
        List<String> internalRoles = Collections.emptyList();
        if (this.adminUsernames != null && this.adminUsernames.contains(username) && this.defaultAdminRoles != null && this.defaultAdminRoles.size() > 0) {
            internalRoles = this.defaultAdminRoles;
        } else if (this.defaultInternalRoles != null && this.defaultInternalRoles.size() > 0) {
            internalRoles = this.defaultInternalRoles;
        } else {
            return set;
        }
        for (String roleName : internalRoles) {
            Role role = this.getUserAuthorityService().getRole((ExecutionContext)executionContext, roleName);
            if (role == null) {
                role = this.getUserAuthorityService().newRole((ExecutionContext)executionContext);
                role.setRoleName(roleName);
                role.setExternallyDefined(false);
                this.getUserAuthorityService().putRole((ExecutionContext)executionContext, role);
            }
            set.add(role);
        }
        return set;
    }

    private Role getOrCreateRole(Role role) {
        Role existingRole = null;
        UserAuthorityService userAuthorityService = this.getUserAuthorityService();
        if (userAuthorityService instanceof PersistentObjectResolver) {
            existingRole = (Role)((PersistentObjectResolver)userAuthorityService).getPersistentObject((Object)role);
        }
        if (existingRole != null && role.isExternallyDefined() && !existingRole.isExternallyDefined()) {
            role.setRoleName(role.getRoleName() + "_" + this.conflictingExternalInternalRoleNameSuffix);
            existingRole = null;
        }
        if (existingRole == null) {
            userAuthorityService.putRole((ExecutionContext)new ExecutionContextImpl(), role);
        }
        return role;
    }

    public List getDefaultInternalRoles() {
        return this.defaultInternalRoles;
    }

    public void setDefaultInternalRoles(List defaultInternalRoles) {
        this.defaultInternalRoles = defaultInternalRoles;
    }

    public void setExternalAuthProperties(ExternalAuthProperties externalAuthProperties) {
        this.externalAuthProperties = externalAuthProperties;
    }

    public ExternalAuthProperties getExternalAuthProperties() {
        return this.externalAuthProperties;
    }

    public String getPermittedExternalRoleNameRegex() {
        return this.permittedExternalRoleNameRegex;
    }

    public void setPermittedExternalRoleNameRegex(String permittedExternalRoleNameRegex) {
        this.permittedExternalRoleNameRegex = permittedExternalRoleNameRegex;
    }

    public void setOrganizationRoleMap(Map<String, String> organizationRoleMapParam) {
        if (!this.organizationRoleMap.isEmpty()) {
            logger.warn((Object)"Duplicate organizationRoleMap initialization.");
            return;
        }
        this.organizationRoleMap = new HashMap<String, String>();
        for (Map.Entry<String, String> rolePair : organizationRoleMapParam.entrySet()) {
            String rolePairKey = rolePair.getKey();
            String rolePairValue = rolePair.getValue();
            if (rolePairValue == null) continue;
            String roleNameToValidate = rolePairValue.trim();
            String string = roleNameToValidate = roleNameToValidate.endsWith(ROLE_SUFFIX) ? roleNameToValidate.substring(0, roleNameToValidate.length() - ROLE_SUFFIX.length()) : roleNameToValidate;
            if (!roleNameToValidate.matches(this.permittedExternalRoleNameRegex)) {
                logger.warn((Object)("organizationRoleMap's internal role " + rolePairValue + " has forbidden characters " + "according to permittedExternalRoleNameRegex: " + this.permittedExternalRoleNameRegex + ".\nSkipping this role in organizationRoleMap."));
                continue;
            }
            this.organizationRoleMap.put(rolePairKey.toUpperCase().trim(), rolePairValue.toUpperCase().trim());
        }
    }

    public void setAdminUsernames(List<String> adminUsernames) {
        this.adminUsernames = adminUsernames;
    }

    public List<String> getAdminUsernames() {
        return this.adminUsernames;
    }

    public void setDefaultAdminRoles(List<String> defaultAdminRoles) {
        this.defaultAdminRoles = defaultAdminRoles;
    }

    public List<String> getDefaultAdminRoles() {
        return this.defaultAdminRoles;
    }

    public void setConflictingExternalInternalRoleNameSuffix(String conflictingExternalInternalRoleNameSuffix) {
        this.conflictingExternalInternalRoleNameSuffix = conflictingExternalInternalRoleNameSuffix;
    }

    public String getConflictingExternalInternalRoleNameSuffix() {
        return this.conflictingExternalInternalRoleNameSuffix;
    }
}

