/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.processors;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryLabelIDHelper;
import com.jaspersoft.jasperserver.api.metadata.security.JasperServerAclEntry;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.security.externalAuth.processors.AbstractExternalUserProcessor;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.security.context.SecurityContextHolder;

public class ExternalUserFolderProcessor
extends AbstractExternalUserProcessor {
    private static final Logger log = LogManager.getLogger(ExternalUserFolderProcessor.class);
    private String userFoldersParentDirectory = "";

    public void process() {
        if (this.getRepositoryService().getFolder((ExecutionContext)new ExecutionContextImpl(), this.getUserFolderPathUri()) == null) {
            this.createUserFolder();
        }
    }

    private void createUserFolder() {
        User currentUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ExecutionContextImpl context = new ExecutionContextImpl();
        ArrayList<String> contextAttributes = new ArrayList<String>();
        contextAttributes.add("PRIVILEGED_OPERATION");
        context.setAttributes(contextAttributes);
        String folderName = currentUser.getUsername();
        FolderImpl folder = new FolderImpl();
        String generatedId = RepositoryLabelIDHelper.generateIdBasedOnLabel((RepositoryService)this.getRepositoryService(), (String)this.userFoldersParentDirectory, (String)folderName);
        folder.setParentFolder(this.userFoldersParentDirectory);
        folder.setName(generatedId);
        folder.setLabel(folderName);
        folder.setDescription("Default user folder");
        this.getRepositoryService().saveFolder((ExecutionContext)context, (Folder)folder);
        log.debug((Object)("folder " + folder.getName() + " was created for."));
        ObjectPermission userFolderPermission = this.getObjectPermissionService().newObjectPermission((ExecutionContext)context);
        userFolderPermission.setURI(folder.getURI());
        userFolderPermission.setPermissionRecipient((Object)currentUser);
        userFolderPermission.setPermissionMask(JasperServerAclEntry.READ_WRITE_CREATE_DELETE);
        this.getObjectPermissionService().putObjectPermission((ExecutionContext)context, userFolderPermission);
    }

    private String getUserFolderPathUri() {
        return this.getUserFoldersParentDirectory() + "/" + ((User)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
    }

    public String getUserFoldersParentDirectory() {
        return this.userFoldersParentDirectory;
    }

    public void setUserFoldersParentDirectory(String userFoldersParentDirectory) {
        this.userFoldersParentDirectory = userFoldersParentDirectory;
    }
}

