/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.db;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalUserDetailsService;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.util.StringUtils;

public class ExternalJDBCUserDetailsService
extends JdbcDaoImpl
implements ExternalUserDetailsService {
    public static final Logger logger = LogManager.getLogger(ExternalJDBCUserDetailsService.class);
    private String detailsQuery;
    private UserDetailsQueryMapping userDetailsQueryMapping;
    private Integer numberDetailsQueryParams;

    public String getDetailsQuery() {
        return this.detailsQuery;
    }

    public void setDetailsQuery(String detailsQuery) {
        this.detailsQuery = detailsQuery != null ? detailsQuery.trim().toLowerCase() : detailsQuery;
    }

    protected void initDao() throws ApplicationContextException {
        super.initDao();
        if (this.detailsQuery != null) {
            logger.debug((Object)("User details query configured in xml: " + this.detailsQuery));
            this.numberDetailsQueryParams = StringUtils.countOccurrencesOf((String)this.detailsQuery, (String)"?");
            this.userDetailsQueryMapping = new UserDetailsQueryMapping(this.getDataSource());
        }
    }

    public List<GrantedAuthority> loadAuthoritiesByUsername(String username) throws DataAccessException {
        logger.debug((Object)"Loading external roles via JDBC.");
        return this.loadUserAuthorities(username);
    }

    public List<Map<String, Object>> loadDetails(String ... params) throws DataAccessException {
        if (this.userDetailsQueryMapping == null) {
            logger.debug((Object)"User details query is NOT configured in app context xml.");
            return Collections.emptyList();
        }
        if (params.length != this.numberDetailsQueryParams) {
            JSException jsException = new JSException("Either " + ((Object)((Object)this)).getClass() + " was mis-configured in the application context xml or " + "the code implementation has not been adjusted for the query");
            logger.error((Object)jsException);
            throw jsException;
        }
        logger.debug((Object)"Loading external user details via JDBC.");
        List userDetails = this.userDetailsQueryMapping.execute(params);
        int udSize = userDetails.size();
        logger.debug((Object)("Loaded " + udSize + " details."));
        if (udSize == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(userDetails);
    }

    private class UserDetailsQueryMapping
    extends MappingSqlQuery<Map<String, Object>> {
        protected UserDetailsQueryMapping(DataSource ds) {
            super(ds, ExternalJDBCUserDetailsService.this.detailsQuery);
            if (ExternalJDBCUserDetailsService.this.numberDetailsQueryParams == null) {
                ExternalJDBCUserDetailsService.this.numberDetailsQueryParams = StringUtils.countOccurrencesOf((String)ExternalJDBCUserDetailsService.this.detailsQuery, (String)"?");
            }
            for (int k = 0; k < ExternalJDBCUserDetailsService.this.numberDetailsQueryParams; ++k) {
                this.declareParameter(new SqlParameter(12));
            }
            this.compile();
        }

        protected Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
            HashMap<String, Object> returnDetailsMap = new HashMap<String, Object>();
            ResultSetMetaData metaData = rs.getMetaData();
            int numbColumns = metaData.getColumnCount();
            for (int c = 1; c <= numbColumns; ++c) {
                String retColumnName = metaData.getColumnLabel(c);
                retColumnName = retColumnName == null ? metaData.getColumnName(c) : retColumnName;
                returnDetailsMap.put(retColumnName, rs.getObject(c));
            }
            return Collections.unmodifiableMap(returnDetailsMap);
        }
    }
}

