/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.custom;

import com.jaspersoft.jasperserver.api.security.externalAuth.BaseAuthenticationProcessingFilter;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalUserDetails;
import com.jaspersoft.jasperserver.api.security.externalAuth.custom.CustomAuthenticationToken;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;

public class CustomAuthenticationProcessingFilter
extends BaseAuthenticationProcessingFilter {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public final Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        if (this.obtainUsername(request) != null || this.obtainPassword(request) != null) {
            return super.attemptAuthentication(request);
        }
        String ip = request.getRemoteAddr();
        ip = ip.replace(".", "_");
        GrantedAuthorityImpl grantedAuthority = new GrantedAuthorityImpl("ROLE_CUSTOM_AUTH_IP");
        LinkedList<GrantedAuthorityImpl> authorities = new LinkedList<GrantedAuthorityImpl>();
        authorities.add(grantedAuthority);
        ExternalUserDetails ud = new ExternalUserDetails(ip, "", authorities.toArray(new GrantedAuthority[0]));
        CustomAuthenticationToken authToken = new CustomAuthenticationToken(ud, "");
        return this.getAuthenticationManager().authenticate((Authentication)authToken);
    }

    private boolean isEvenIp(String ip) {
        String[] vals = ip.split("\\.");
        int sum = 0;
        for (int i = 0; i < vals.length; ++i) {
            sum += Integer.parseInt(vals[i]);
        }
        return sum % 2 == 0;
    }
}

