/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.security.externalAuth.EmptyExternalUserDetailsService;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalDataSynchronizer;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalUserDetailsService;
import com.jaspersoft.jasperserver.api.security.externalAuth.processors.ExternalUserProcessor;
import com.jaspersoft.jasperserver.api.security.externalAuth.processors.ProcessorData;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class ExternalDataSynchronizerImpl
implements ExternalDataSynchronizer,
InitializingBean {
    private static final Logger logger = LogManager.getLogger(ExternalDataSynchronizerImpl.class);
    private ExternalUserDetailsService externalUserDetailsService = new EmptyExternalUserDetailsService();
    private List<ExternalUserProcessor> externalUserProcessors;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.externalUserProcessors, (String)"externalUserProcessors must not be null");
        Assert.notEmpty(this.externalUserProcessors, (String)"externalUserProcessors must not be empty: at least external user setup processor must be present to enter th user into JRS DB.");
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void synchronize() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        logger.debug((Object)("Authentication token: " + (auth == null ? "none" : auth)));
        if (auth != null && auth.getPrincipal() != null && auth.isAuthenticated() && !(auth instanceof AnonymousAuthenticationToken)) {
            ProcessorData.getInstance().clearData();
            this.loadExternalUserDetailsToProcessorData(auth);
            for (ExternalUserProcessor processor : this.externalUserProcessors) {
                processor.process();
            }
            Authentication newAuth = SecurityContextHolder.getContext().getAuthentication();
            if (newAuth != null && newAuth.getPrincipal() instanceof MetadataUserDetails) {
                MetadataUserDetails newPrincipal = (MetadataUserDetails)newAuth.getPrincipal();
                newPrincipal.setOriginalAuthentication(auth);
            }
        }
    }

    protected void loadExternalUserDetailsToProcessorData(Authentication auth) {
        Object principal = auth.getPrincipal();
        if (principal == null) {
            throw new JSException("Principal is null.");
        }
        String username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        List userDetails = this.externalUserDetailsService.loadDetails(new String[]{username});
        ProcessorData processorData = ProcessorData.getInstance();
        if (userDetails != null && !userDetails.isEmpty()) {
            processorData.addData(ProcessorData.Key.EXTERNAL_LOADED_DETAILS, userDetails.get(0));
        }
        processorData.addData(ProcessorData.Key.EXTERNAL_AUTH_DETAILS, auth.getPrincipal());
        processorData.addData(ProcessorData.Key.EXTERNAL_AUTHORITIES, (Object)auth.getAuthorities());
    }

    protected ExternalUserDetailsService getExternalUserDetailsService() {
        return this.externalUserDetailsService;
    }

    public void setExternalUserDetailsService(ExternalUserDetailsService externalUserDetailsService) {
        Assert.notNull((Object)externalUserDetailsService, (String)"Cannot set user details service to null.");
        this.externalUserDetailsService = externalUserDetailsService;
    }

    public void setExternalUserProcessors(List<ExternalUserProcessor> externalUserProcessors) {
        Assert.notNull(externalUserProcessors, (String)"Cannot set empty processor list.");
        this.externalUserProcessors = externalUserProcessors;
    }

    protected List<ExternalUserProcessor> getExternalUserProcessors() {
        return this.externalUserProcessors;
    }
}

