/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UserAuthorityServiceTestTestNG
extends BaseServiceSetupTestNG {
    protected static Log m_logger = LogFactory.getLog(UserAuthorityServiceTestTestNG.class);

    public UserAuthorityServiceTestTestNG() {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => constructor() called");
    }

    @BeforeClass
    protected void onSetUp() throws Exception {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onSetUp() called");
    }

    @AfterClass
    public void onTearDown() {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() called");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() deleting ROLE 'anotherRole'");
        this.getUserAuthorityService().deleteRole(null, "anotherRole");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() deleting ROLE 'ROLE_ETL_ADMIN'");
        this.getUserAuthorityService().deleteRole(null, "ROLE_ETL_ADMIN");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() deleting ROLE 'ROLE_ETL'");
        this.getUserAuthorityService().deleteRole(null, "ROLE_ETL");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() deleting ROLE 'newRole'");
        this.getUserAuthorityService().deleteRole(null, "newRole");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() deleting USER 'etladmin'");
        this.getUserAuthorityService().deleteUser(null, "etladmin");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() deleting USER 'etluser'");
        this.getUserAuthorityService().deleteUser(null, "etluser");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => onTearDown() deleting USER 'newUser'");
        this.getUserAuthorityService().deleteUser(null, "newUser");
    }

    @Test
    public void doNewUserTest() {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doNewUserTest() called");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doNewUserTest() creating USER 'newUser'");
        User newUser = this.createUser("newUser", "newPassword", "newUser");
        AssertJUnit.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doNewUserTest() creating and adding ROLE 'newRole'");
        this.createRole("newRole");
        this.addRole(newUser, "newRole");
        AssertJUnit.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"doNewUserTest"})
    public void doOrdinaryETLUserTest() {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doOrdinaryETLUserTest() called");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doOrdinaryETLUserTest() creating USER 'etluser'");
        User newUser = this.createUser("etluser", "etluser", "etluser");
        AssertJUnit.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_USER");
        AssertJUnit.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doOrdinaryETLUserTest() creating and adding ROLE 'ROLE_ETL'");
        this.createRole("ROLE_ETL");
        this.addRole(newUser, "ROLE_ETL");
        AssertJUnit.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 2 ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"doOrdinaryETLUserTest"})
    public void doAdminETLUserTest() {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doAdminETLUserTest() called");
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doAdminETLUserTest() creating USER 'etladmin'");
        User newUser = this.createUser("etladmin", "etladmin", "etladmin");
        AssertJUnit.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_USER");
        AssertJUnit.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_ADMINISTRATOR");
        AssertJUnit.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 2 ? 1 : 0) != 0);
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doAdminETLUserTest() creating and adding ROLE 'ROLE_ETL_ADMIN'");
        this.createRole("ROLE_ETL_ADMIN");
        this.addRole(newUser, "ROLE_ETL_ADMIN");
        AssertJUnit.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 3 ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"doAdminETLUserTest"})
    public void doUpdateUserTest() {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doUpdateUserTest() called");
        User newUser = this.getUser("newUser");
        AssertJUnit.assertNotNull((Object)newUser);
        AssertJUnit.assertTrue((boolean)newUser.isEnabled());
        this.getUserAuthorityService().disableUser(null, newUser.getUsername());
        newUser = this.getUser("newUser");
        AssertJUnit.assertTrue((String)"error: user still disabled", (!newUser.isEnabled() ? 1 : 0) != 0);
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doUpdateUserTest() creating and adding ROLE 'anotherRole'");
        this.createRole("anotherRole");
        this.addRole(newUser, "anotherRole");
        Role anotherRole = this.getUserAuthorityService().getRole(null, "anotherRole");
        AssertJUnit.assertTrue((String)"error: 'anotherRole' does not exist", (anotherRole != null ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"error: newUser does not have anotherRole", (boolean)newUser.getRoles().contains(anotherRole));
        this.getUserAuthorityService().putUser(null, newUser);
        newUser.removeRole(anotherRole);
        AssertJUnit.assertTrue((String)"error: newUser still contains anotherRole", (!newUser.getRoles().contains(anotherRole) ? 1 : 0) != 0);
        this.getUserAuthorityService().putUser(null, newUser);
        newUser = this.getUserAuthorityService().getUser(null, "newUser");
        AssertJUnit.assertTrue((String)"error: after retrieval - newUser REALLY still contains anotherRole", (!newUser.getRoles().contains(anotherRole) ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"doUpdateUserTest"})
    public void doGetUsersAndRolesTest() {
        m_logger.info((Object)"UserAuthorityServiceTestTestNG => doGetUsersAndRolesTest() called");
        List results = this.getUserAuthorityService().getUsers(null, null);
        AssertJUnit.assertTrue((String)("getUsers right size: expected at least 3, got " + results.size()), (results.size() >= 3 ? 1 : 0) != 0);
        results = this.getUserAuthorityService().getRoles(null, null);
        AssertJUnit.assertTrue((String)("getRoles right size: expected at least 4, got " + results.size()), (results.size() >= 4 ? 1 : 0) != 0);
    }
}

