/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.FTPInfo;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.FTPInfoModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobCalendarTriggerModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobMailNotificationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobRepositoryDestinationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSimpleTriggerModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSourceModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ReportSchedulingTestTestNG
extends BaseServiceSetupTestNG {
    protected static Log m_logger = LogFactory.getLog(ReportSchedulingTestTestNG.class);
    private ReportJobsPersistenceService m_reportJobsPersistenceService;
    private ReportSchedulingService m_reportSchedulingService;
    private ExecutionContext m_executionContext;
    private LoggingService m_loggingService;
    long eventId = -1L;

    public LoggingService getLoggingService() {
        return this.m_loggingService;
    }

    @Resource(name="loggingService")
    public void setLoggingService(LoggingService loggingService) {
        m_logger.info((Object)"setLoggingService() called");
        this.m_loggingService = loggingService;
    }

    public ReportJobsPersistenceService getReportJobsPersistenceService() {
        return this.m_reportJobsPersistenceService;
    }

    @Resource(name="reportJobsPersistenceService")
    public void setReportJobsPersistenceService(ReportJobsPersistenceService reportJobsPersistenceService) {
        m_logger.info((Object)"setReportJobsPersistenceService() called");
        this.m_reportJobsPersistenceService = reportJobsPersistenceService;
    }

    @Override
    public ReportSchedulingService getReportSchedulingService() {
        return this.m_reportSchedulingService;
    }

    @Override
    @Resource(name="reportSchedulingService")
    public void setReportSchedulingService(ReportSchedulingService s) {
        m_logger.info((Object)"setReportSchedulingService() called");
        this.m_reportSchedulingService = s;
    }

    public ReportSchedulingTestTestNG() {
        m_logger.info((Object)"ReportSchedulingTestTestNG => constructor() called");
    }

    @BeforeClass
    protected void onSetUp() throws Exception {
        m_logger.info((Object)"ReportSchedulingTestTestNG => onSetUp() called");
        this.m_executionContext = new ExecutionContextImpl();
        this.setAuthenticatedUser("jasperadmin");
    }

    @AfterClass
    protected void onTearDown() {
        m_logger.info((Object)"ReportSchedulingTestTestNG => onTearDown() called");
        if (this.eventId >= 0L) {
            this.m_loggingService.delete(null, new long[]{this.eventId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doPersistenceTest() {
        m_logger.info((Object)"ReportSchedulingTestTestNG => doPersistenceTest() called");
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI("/test/reportURI");
        Map params = new HashMap<String, Object>();
        params.put("param1", new Integer(5));
        params.put("param2", "value2");
        source.setParametersMap(params);
        Date startDate = new Date();
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(startDate);
        trigger.setOccurrenceCount(20);
        trigger.setRecurrenceInterval(10);
        trigger.setRecurrenceIntervalUnit((byte)3);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/test/scheduled");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(true);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setDefaultReportOutputFolderURI("/default/report_output/folder");
        repositoryDestination.setUsingDefaultReportOutputFolderURI(true);
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_01 = new ReportJob();
        job_01.setLabel("foo");
        job_01.setDescription("bar");
        job_01.setSource(source);
        job_01.setTrigger((ReportJobTrigger)trigger);
        job_01.setBaseOutputFilename("foo");
        job_01.addOutputFormat((byte)1);
        job_01.addOutputFormat((byte)4);
        job_01.setContentRepositoryDestination(repositoryDestination);
        job_01.setMailNotification(mailNotification);
        job_01 = this.m_reportJobsPersistenceService.saveJob(this.m_executionContext, job_01);
        m_logger.info((Object)("saved job_01 " + job_01.getId() + " has version=" + job_01.getVersion()));
        AssertJUnit.assertNotNull((Object)job_01);
        long jobId_01 = job_01.getId();
        String userName = job_01.getUsername();
        source = new ReportJobSource();
        source.setReportUnitURI("/test/A_ReportURI");
        params = new HashMap();
        params.put("param1", new Integer(5));
        params.put("param2", "value2");
        source.setParametersMap(params);
        startDate = new Date();
        ReportJobCalendarTrigger trigger2 = new ReportJobCalendarTrigger();
        trigger2.setMinutes("0");
        trigger2.setHours("0");
        trigger2.setDaysTypeCode(Byte.valueOf((byte)1));
        TreeSet<Byte> months = new TreeSet<Byte>();
        months.add(new Byte(1));
        months.add(new Byte(2));
        months.add(new Byte(3));
        trigger2.setMonthDays("");
        trigger2.setMonths(months);
        trigger2.setTimezone("America/Los_Angeles");
        trigger2.setStartType((byte)1);
        repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/test/scheduled");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(false);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setSaveToRepository(false);
        repositoryDestination.setOutputLocalFolder("c:/tmp");
        FTPInfo ftpInfo = new FTPInfo();
        ftpInfo.setUserName("JohnSmith");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("PORT", "27");
        ftpInfo.setPropertiesMap(map);
        repositoryDestination.setOutputFTPInfo(ftpInfo);
        mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.addTo("peter@pan.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        mailNotification.setSkipNotificationWhenJobFails(true);
        ReportJobAlert alert = new ReportJobAlert();
        alert.setRecipient(ReportJobAlert.Recipient.ADMIN);
        alert.setMessageText("CUSTOMIZE MESSAGE");
        alert.setJobState(ReportJobAlert.JobState.FAIL_ONLY);
        ArrayList<String> to_Addresses = new ArrayList<String>();
        to_Addresses.add("peterpan@jaspersoft.com");
        to_Addresses.add("peter.pan@gmail.com");
        alert.setToAddresses(to_Addresses);
        ReportJob job_02 = new ReportJob();
        job_02.setLabel("A_ReportJob_2");
        job_02.setDescription("bar");
        job_02.setSource(source);
        job_02.setTrigger((ReportJobTrigger)trigger2);
        job_02.setBaseOutputFilename("aReportJob_2_OUTPUT");
        job_02.addOutputFormat((byte)1);
        job_02.addOutputFormat((byte)4);
        job_02.setContentRepositoryDestination(repositoryDestination);
        job_02.setAlert(alert);
        boolean exceptionCaught = false;
        try {
            job_02.setMailNotification(mailNotification);
        }
        catch (Exception ex) {
            exceptionCaught = true;
        }
        AssertJUnit.assertTrue((boolean)exceptionCaught);
        mailNotification.setResultSendTypeCode(Byte.valueOf((byte)2));
        job_02.setMailNotification(mailNotification);
        job_02 = this.m_reportJobsPersistenceService.saveJob(this.m_executionContext, job_02);
        AssertJUnit.assertEquals((boolean)false, (boolean)job_02.getContentRepositoryDestination().isSaveToRepository());
        AssertJUnit.assertNotNull((Object)job_02);
        long jobId_02 = job_02.getId();
        AssertJUnit.assertTrue((System.currentTimeMillis() - job_01.getCreationDate().getTime() < 60000L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((System.currentTimeMillis() - job_02.getCreationDate().getTime() < 60000L ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)"/default/report_output/folder", (String)job_02.getContentRepositoryDestination().getDefaultReportOutputFolderURI());
        AssertJUnit.assertEquals((String)"/default/report_output/folder", (String)job_01.getContentRepositoryDestination().getDefaultReportOutputFolderURI());
        AssertJUnit.assertEquals((boolean)true, (boolean)job_01.getContentRepositoryDestination().isUsingDefaultReportOutputFolderURI());
        AssertJUnit.assertEquals((boolean)false, (boolean)job_02.getContentRepositoryDestination().isUsingDefaultReportOutputFolderURI());
        this.testAlert(job_02.getAlert());
        AssertJUnit.assertNull((Object)job_01.getContentRepositoryDestination().getOutputLocalFolder());
        AssertJUnit.assertTrue((job_01.getContentRepositoryDestination().getOutputFTPInfo() == null || job_01.getContentRepositoryDestination().getOutputFTPInfo().getFolderPath() == null ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)"c:/tmp", (String)job_02.getContentRepositoryDestination().getOutputLocalFolder());
        AssertJUnit.assertEquals((String)"JohnSmith", (String)job_02.getContentRepositoryDestination().getOutputFTPInfo().getUserName());
        Map ftpProperties = job_02.getContentRepositoryDestination().getOutputFTPInfo().getPropertiesMap();
        AssertJUnit.assertEquals((String)"27", (String)((String)ftpProperties.get("PORT")));
        AssertJUnit.assertNull((Object)job_02.getContentRepositoryDestination().getOutputFTPInfo().getPassword());
        AssertJUnit.assertTrue((!job_01.getMailNotification().isSkipNotificationWhenJobFails() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)job_02.getMailNotification().isSkipNotificationWhenJobFails());
        boolean deleted = true;
        try {
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            m_logger.info((Object)("retrieved job_01 " + job_01.getId() + " has version=" + job_01.getVersion()));
            AssertJUnit.assertNotNull((Object)job_01);
            AssertJUnit.assertEquals((String)"foo", (String)job_01.getLabel());
            Set outputFormats = job_01.getOutputFormatsSet();
            AssertJUnit.assertNotNull((Object)outputFormats);
            AssertJUnit.assertEquals((int)2, (int)outputFormats.size());
            AssertJUnit.assertTrue((boolean)outputFormats.contains(new Byte(1)));
            AssertJUnit.assertTrue((boolean)outputFormats.contains(new Byte(4)));
            source = job_01.getSource();
            AssertJUnit.assertNotNull((Object)source);
            AssertJUnit.assertEquals((String)"/test/reportURI", (String)source.getReportUnitURI());
            params = source.getParametersMap();
            AssertJUnit.assertNotNull(params);
            AssertJUnit.assertEquals((int)2, (int)params.size());
            AssertJUnit.assertTrue((boolean)params.containsKey("param1"));
            AssertJUnit.assertEquals((Object)new Integer(5), params.get("param1"));
            AssertJUnit.assertTrue((boolean)params.containsKey("param2"));
            AssertJUnit.assertEquals((Object)"value2", params.get("param2"));
            AssertJUnit.assertNotNull((Object)job_01.getTrigger());
            AssertJUnit.assertTrue((boolean)(job_01.getTrigger() instanceof ReportJobSimpleTrigger));
            trigger = (ReportJobSimpleTrigger)job_01.getTrigger();
            AssertJUnit.assertEquals((int)20, (int)trigger.getOccurrenceCount());
            AssertJUnit.assertNotNull((Object)trigger.getRecurrenceIntervalUnit());
            AssertJUnit.assertEquals((byte)3, (byte)trigger.getRecurrenceIntervalUnit());
            repositoryDestination = job_01.getContentRepositoryDestination();
            AssertJUnit.assertNotNull((Object)repositoryDestination);
            AssertJUnit.assertEquals((String)"/test/scheduled", (String)repositoryDestination.getFolderURI());
            AssertJUnit.assertEquals((String)"report output", (String)repositoryDestination.getOutputDescription());
            AssertJUnit.assertTrue((boolean)repositoryDestination.isSequentialFilenames());
            AssertJUnit.assertEquals((String)"yyyyMMdd", (String)repositoryDestination.getTimestampPattern());
            AssertJUnit.assertFalse((boolean)repositoryDestination.isOverwriteFiles());
            mailNotification = job_01.getMailNotification();
            AssertJUnit.assertNotNull((Object)mailNotification);
            AssertJUnit.assertEquals((String)"Scheduled report", (String)mailNotification.getSubject());
            List toAddresses = mailNotification.getToAddresses();
            AssertJUnit.assertNotNull((Object)toAddresses);
            AssertJUnit.assertEquals((int)1, (int)toAddresses.size());
            AssertJUnit.assertEquals((Object)"john@smith.com", toAddresses.get(0));
            long origJobId = job_01.getId();
            int origJobVersion = job_01.getVersion();
            long origTriggerId = trigger.getId();
            int origTriggerVersion = trigger.getVersion();
            long origMailId = mailNotification.getId();
            int origMailVersion = mailNotification.getVersion();
            job_01.setDescription("updated");
            mailNotification.setSubject("updated subject");
            mailNotification.addTo("joan@smith.com");
            mailNotification.addCc("mary@smith.com");
            this.m_reportJobsPersistenceService.updateJob(this.m_executionContext, job_01);
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            AssertJUnit.assertNotNull((Object)job_01);
            AssertJUnit.assertEquals((String)"foo", (String)job_01.getLabel());
            AssertJUnit.assertEquals((String)"updated", (String)job_01.getDescription());
            AssertJUnit.assertEquals((long)origJobId, (long)job_01.getId());
            AssertJUnit.assertEquals((int)(origJobVersion + 1), (int)job_01.getVersion());
            AssertJUnit.assertNotNull((Object)job_01.getTrigger());
            AssertJUnit.assertTrue((boolean)(job_01.getTrigger() instanceof ReportJobSimpleTrigger));
            trigger = (ReportJobSimpleTrigger)job_01.getTrigger();
            AssertJUnit.assertEquals((long)origTriggerId, (long)trigger.getId());
            AssertJUnit.assertEquals((int)origTriggerVersion, (int)trigger.getVersion());
            mailNotification = job_01.getMailNotification();
            AssertJUnit.assertNotNull((Object)mailNotification);
            AssertJUnit.assertEquals((long)origMailId, (long)mailNotification.getId());
            AssertJUnit.assertEquals((int)(origMailVersion + 1), (int)mailNotification.getVersion());
            AssertJUnit.assertEquals((String)"updated subject", (String)mailNotification.getSubject());
            toAddresses = mailNotification.getToAddresses();
            AssertJUnit.assertEquals((int)2, (int)toAddresses.size());
            AssertJUnit.assertEquals((Object)"john@smith.com", toAddresses.get(0));
            AssertJUnit.assertEquals((Object)"joan@smith.com", toAddresses.get(1));
            List ccAddresses = mailNotification.getCcAddresses();
            AssertJUnit.assertNotNull((Object)ccAddresses);
            AssertJUnit.assertEquals((int)1, (int)ccAddresses.size());
            AssertJUnit.assertEquals((Object)"mary@smith.com", ccAddresses.get(0));
            List jobs = this.m_reportJobsPersistenceService.listJobs(this.m_executionContext, "/test/reportURI");
            AssertJUnit.assertNotNull((Object)jobs);
            AssertJUnit.assertTrue((1 <= jobs.size() ? 1 : 0) != 0);
            boolean found = false;
            for (Object element : jobs) {
                AssertJUnit.assertTrue((boolean)(element instanceof ReportJobSummary));
                ReportJobSummary summary = (ReportJobSummary)element;
                if (summary.getId() != jobId_01) continue;
                found = true;
                AssertJUnit.assertEquals((String)"foo", (String)summary.getLabel());
                break;
            }
            AssertJUnit.assertTrue((boolean)found);
            this.testListJobs(jobId_01, jobId_02, userName);
            this.testSorting(jobId_01, jobId_02);
            this.testSortingDES(jobId_01, jobId_02);
            this.testSortingNONEDES(jobId_01, jobId_02);
            this.testPagination(jobId_01, jobId_02);
            this.testUpdateJobsByIDFAIL(jobId_01, jobId_02);
            this.testUpdateJobsByIDFAILInvalidID(jobId_01, jobId_02);
            this.testUpdateJobsByIDFAILInvalidPath(jobId_01, jobId_02);
            this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            deleted = true;
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            AssertJUnit.assertNull((Object)job_01);
            job_02 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            AssertJUnit.assertNull((Object)job_02);
        }
        finally {
            if (!deleted) {
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            }
        }
    }

    private void testAlert(ReportJobAlert alert) {
        AssertJUnit.assertEquals((Object)ReportJobAlert.Recipient.ADMIN, (Object)alert.getRecipient());
        AssertJUnit.assertEquals((String)"CUSTOMIZE MESSAGE", (String)alert.getMessageText());
        AssertJUnit.assertEquals((Object)ReportJobAlert.JobState.FAIL_ONLY, (Object)alert.getJobState());
        ArrayList<String> toAddresses = new ArrayList<String>();
        toAddresses.add("peterpan@jaspersoft.com");
        toAddresses.add("peter.pan@gmail.com");
        AssertJUnit.assertEquals((int)2, (int)alert.getToAddresses().size());
        for (String address : toAddresses) {
            AssertJUnit.assertEquals((boolean)true, (boolean)alert.getToAddresses().contains(address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doBasicFindByNextFireTimePersistenceTest() {
        m_logger.info((Object)"\n\nReportSchedulingTestTestNG => doBasicFindByNextFireTimePersistenceTest() called");
        Date now = new Date();
        long nowMillis = now.getTime();
        long windowIntervalMillis = 360000L;
        long queryWindowStart = nowMillis - 10L;
        long queryWindowEnd = nowMillis + windowIntervalMillis;
        Date report01StartDate = new Date(queryWindowStart + 240000L);
        Date report02StartDate = new Date(queryWindowStart + 600000L);
        Date startDate = new Date(queryWindowStart);
        Date endDate = new Date(queryWindowEnd);
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        HashMap params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(report01StartDate);
        trigger.setOccurrenceCount(5);
        trigger.setRecurrenceInterval(1);
        trigger.setRecurrenceIntervalUnit((byte)1);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(true);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setDefaultReportOutputFolderURI("/default/report_output/folder");
        repositoryDestination.setUsingDefaultReportOutputFolderURI(true);
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_01 = new ReportJob();
        job_01.setLabel("foo");
        job_01.setDescription("bar");
        job_01.setSource(source);
        job_01.setTrigger((ReportJobTrigger)trigger);
        job_01.setBaseOutputFilename("foo_" + new Date().getTime());
        job_01.addOutputFormat((byte)1);
        job_01.addOutputFormat((byte)4);
        job_01.setContentRepositoryDestination(repositoryDestination);
        job_01.setMailNotification(mailNotification);
        job_01 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_01);
        m_logger.info((Object)("scheduled Job 01 id='" + job_01.getId() + "' label='" + job_01.getLabel() + " for " + report01StartDate));
        AssertJUnit.assertNotNull((Object)job_01);
        long jobId_01 = job_01.getId();
        String userName = job_01.getUsername();
        source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger2 = new ReportJobSimpleTrigger();
        trigger2.setStartDate(report02StartDate);
        trigger2.setOccurrenceCount(5);
        trigger2.setRecurrenceInterval(1);
        trigger2.setRecurrenceIntervalUnit((byte)1);
        repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(false);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setSaveToRepository(false);
        mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.addTo("peter@pan.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_02 = new ReportJob();
        job_02.setLabel("A_ReportJob_2");
        job_02.setDescription("bar");
        job_02.setSource(source);
        job_02.setTrigger((ReportJobTrigger)trigger2);
        job_02.setBaseOutputFilename("aReportJob_2_OUTPUT_" + new Date().getTime());
        job_02.addOutputFormat((byte)1);
        job_02.addOutputFormat((byte)4);
        job_02.setContentRepositoryDestination(repositoryDestination);
        boolean exceptionCaught = false;
        try {
            job_02.setMailNotification(mailNotification);
        }
        catch (Exception ex) {
            exceptionCaught = true;
        }
        AssertJUnit.assertTrue((boolean)exceptionCaught);
        mailNotification.setResultSendTypeCode(Byte.valueOf((byte)2));
        job_02.setMailNotification(mailNotification);
        job_02 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_02);
        m_logger.info((Object)("scheduled Job 02 id='" + job_02.getId() + "' label='" + job_02.getLabel() + " for " + report02StartDate));
        AssertJUnit.assertEquals((boolean)false, (boolean)job_02.getContentRepositoryDestination().isSaveToRepository());
        AssertJUnit.assertNotNull((Object)job_02);
        long jobId_02 = job_02.getId();
        boolean deleted = false;
        try {
            List summaryList = this.m_reportSchedulingService.getJobsByNextFireTime(this.m_executionContext, null, startDate, endDate, null);
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (ReportJobSummary js : summaryList) {
                ReportJobRuntimeInformation ri = js.getRuntimeInformation();
                Date nextFireTime = ri == null ? null : ri.getNextFireTime();
                String time = nextFireTime == null ? "NULL" : nextFireTime.toString();
                sb.append(count++ + " job " + js.getId() + " " + nextFireTime + " = " + time + "\n");
            }
            m_logger.info((Object)sb.toString());
            m_logger.info((Object)("expecting query to return 1 report, got " + summaryList.size()));
            int expectedNumberOfReports = 1;
            AssertJUnit.assertEquals((String)("Error ! expected to get back 1 Report in window but instead we got " + summaryList.size()), (int)expectedNumberOfReports, (int)summaryList.size());
            ReportJobSummary rjs = (ReportJobSummary)summaryList.get(0);
            long id1 = rjs.getId();
            m_logger.info((Object)("Expected to get back jobId='" + jobId_01 + "', got '" + id1 + "'"));
            AssertJUnit.assertEquals((String)("Error ! expected to get back job01 id = '" + jobId_01 + "', but instead we got '" + id1 + ", note: job02 id = '" + jobId_02), (long)id1, (long)jobId_01);
            summaryList = this.m_reportSchedulingService.getJobsByNextFireTime(this.m_executionContext, null, null, null, null);
            sb.setLength(0);
            count = 0;
            for (ReportJobSummary js : summaryList) {
                ReportJobRuntimeInformation ri = js.getRuntimeInformation();
                Date nextFireTime = ri == null ? null : ri.getNextFireTime();
                String time = nextFireTime == null ? "NULL" : nextFireTime.toString();
                sb.append(count++ + " job " + js.getId() + " " + nextFireTime + " = " + time + "\n");
            }
            m_logger.info((Object)sb.toString());
            m_logger.info((Object)("expecting query to return 2 report, got " + summaryList.size()));
            expectedNumberOfReports = 2;
            AssertJUnit.assertEquals((String)("Error ! expected to get back 2 Reports but instead we got " + summaryList.size()), (int)expectedNumberOfReports, (int)summaryList.size());
            try {
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
                deleted = true;
            }
            catch (Throwable th) {
                m_logger.info((Object)("Error !  Throwable while attempting to delete job '" + th.getMessage() + "'"));
            }
            this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            AssertJUnit.assertNull((Object)job_01);
            job_02 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            AssertJUnit.assertNull((Object)job_02);
        }
        finally {
            if (!deleted) {
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                }
                catch (Throwable th) {}
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
                }
                catch (Throwable th) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doPauseResumeIndividualTest() {
        m_logger.info((Object)"\n\nReportSchedulingTestTestNG => doPauseResumeIndividualTest() called");
        Date now = new Date();
        long nowMillis = now.getTime();
        long windowIntervalMillis = 900000L;
        long queryWindowStart = nowMillis - 10L;
        long queryWindowEnd = nowMillis + windowIntervalMillis;
        Date report01StartDate = new Date(queryWindowStart + 600000L);
        Date report02StartDate = new Date(queryWindowStart + 600000L);
        Date startDate = new Date(queryWindowStart);
        Date endDate = new Date(queryWindowEnd);
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        HashMap params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(report01StartDate);
        trigger.setOccurrenceCount(5);
        trigger.setRecurrenceInterval(1);
        trigger.setRecurrenceIntervalUnit((byte)1);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(true);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setDefaultReportOutputFolderURI("/default/report_output/folder");
        repositoryDestination.setUsingDefaultReportOutputFolderURI(true);
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_01 = new ReportJob();
        job_01.setLabel("foo");
        job_01.setDescription("bar");
        job_01.setSource(source);
        job_01.setTrigger((ReportJobTrigger)trigger);
        job_01.setBaseOutputFilename("foo_" + new Date().getTime());
        job_01.addOutputFormat((byte)1);
        job_01.addOutputFormat((byte)4);
        job_01.setContentRepositoryDestination(repositoryDestination);
        job_01.setMailNotification(mailNotification);
        job_01 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_01);
        m_logger.info((Object)("scheduled Job 01 id='" + job_01.getId() + "' label='" + job_01.getLabel() + " for " + report01StartDate));
        AssertJUnit.assertNotNull((Object)job_01);
        long jobId_01 = job_01.getId();
        String userName = job_01.getUsername();
        source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger2 = new ReportJobSimpleTrigger();
        trigger2.setStartDate(report02StartDate);
        trigger2.setOccurrenceCount(5);
        trigger2.setRecurrenceInterval(1);
        trigger2.setRecurrenceIntervalUnit((byte)1);
        repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(false);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setSaveToRepository(false);
        mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.addTo("peter@pan.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_02 = new ReportJob();
        job_02.setLabel("A_ReportJob_2");
        job_02.setDescription("bar");
        job_02.setSource(source);
        job_02.setTrigger((ReportJobTrigger)trigger2);
        job_02.setBaseOutputFilename("aReportJob_2_OUTPUT_" + new Date().getTime());
        job_02.addOutputFormat((byte)1);
        job_02.addOutputFormat((byte)4);
        job_02.setContentRepositoryDestination(repositoryDestination);
        boolean exceptionCaught = false;
        try {
            job_02.setMailNotification(mailNotification);
        }
        catch (Exception ex) {
            exceptionCaught = true;
        }
        AssertJUnit.assertTrue((boolean)exceptionCaught);
        mailNotification.setResultSendTypeCode(Byte.valueOf((byte)2));
        job_02.setMailNotification(mailNotification);
        job_02 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_02);
        m_logger.info((Object)("scheduled Job 02 id='" + job_02.getId() + "' label='" + job_02.getLabel() + " for " + report02StartDate));
        AssertJUnit.assertEquals((boolean)false, (boolean)job_02.getContentRepositoryDestination().isSaveToRepository());
        AssertJUnit.assertNotNull((Object)job_02);
        long jobId_02 = job_02.getId();
        boolean deleted = false;
        Byte paused = 3;
        Byte normal = 1;
        ArrayList<Byte> pausedL = new ArrayList<Byte>();
        pausedL.add(paused);
        ArrayList<Byte> normalL = new ArrayList<Byte>();
        normalL.add(normal);
        try {
            m_logger.info((Object)("do pause of " + jobId_01));
            ArrayList<ReportJob> pauseList = new ArrayList<ReportJob>();
            pauseList.add(job_01);
            this.m_reportSchedulingService.pause(pauseList, false);
            List summaryList = this.m_reportSchedulingService.getJobsByNextFireTime(this.m_executionContext, null, startDate, endDate, pausedL);
            int expectedSize = 1;
            AssertJUnit.assertEquals((String)("Error ! expected to get back " + expectedSize + " paused jobs, instead we got " + summaryList.size()), (int)expectedSize, (int)summaryList.size());
            boolean found1 = false;
            boolean found2 = false;
            for (ReportJobSummary rjs : summaryList) {
                m_logger.info((Object)(rjs.getId() + "  status = " + rjs.getRuntimeInformation().getStateCode() + ", note 'PAUSED == 3"));
                if (rjs.getId() == jobId_01) {
                    found1 = true;
                }
                if (rjs.getId() != jobId_02) continue;
                found2 = true;
            }
            AssertJUnit.assertTrue((String)("Error, we expected to have paused " + job_01 + " but we didn't !"), (boolean)found1);
            AssertJUnit.assertFalse((String)("Error, we expected to have NOT paused " + job_02 + " but we did !"), (boolean)found2);
            try {
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
                deleted = true;
            }
            catch (Throwable th) {
                m_logger.info((Object)("Error !  Throwable while attempting to delete job '" + th.getMessage() + "'"));
            }
            this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            AssertJUnit.assertNull((Object)job_01);
            job_02 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            AssertJUnit.assertNull((Object)job_02);
        }
        finally {
            if (!deleted) {
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                }
                catch (Throwable th) {}
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
                }
                catch (Throwable th) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doPauseResumeAllTest() {
        m_logger.info((Object)"\n\nReportSchedulingTestTestNG => doBasicFindByNextFireTimePersistenceTest() called");
        Date now = new Date();
        long nowMillis = now.getTime();
        long windowIntervalMillis = 900000L;
        long queryWindowStart = nowMillis - 10L;
        long queryWindowEnd = nowMillis + windowIntervalMillis;
        Date report01StartDate = new Date(queryWindowStart + 600000L);
        Date report02StartDate = new Date(queryWindowStart + 600000L);
        Date startDate = new Date(queryWindowStart);
        Date endDate = new Date(queryWindowEnd);
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        HashMap params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(report01StartDate);
        trigger.setOccurrenceCount(5);
        trigger.setRecurrenceInterval(1);
        trigger.setRecurrenceIntervalUnit((byte)1);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(true);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setDefaultReportOutputFolderURI("/default/report_output/folder");
        repositoryDestination.setUsingDefaultReportOutputFolderURI(true);
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_01 = new ReportJob();
        job_01.setLabel("foo");
        job_01.setDescription("bar");
        job_01.setSource(source);
        job_01.setTrigger((ReportJobTrigger)trigger);
        job_01.setBaseOutputFilename("foo_" + new Date().getTime());
        job_01.addOutputFormat((byte)1);
        job_01.addOutputFormat((byte)4);
        job_01.setContentRepositoryDestination(repositoryDestination);
        job_01.setMailNotification(mailNotification);
        job_01 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_01);
        m_logger.info((Object)("scheduled Job 01 id='" + job_01.getId() + "' label='" + job_01.getLabel() + " for " + report01StartDate));
        AssertJUnit.assertNotNull((Object)job_01);
        long jobId_01 = job_01.getId();
        String userName = job_01.getUsername();
        source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger2 = new ReportJobSimpleTrigger();
        trigger2.setStartDate(report02StartDate);
        trigger2.setOccurrenceCount(5);
        trigger2.setRecurrenceInterval(1);
        trigger2.setRecurrenceIntervalUnit((byte)1);
        repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(false);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setSaveToRepository(false);
        mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.addTo("peter@pan.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_02 = new ReportJob();
        job_02.setLabel("A_ReportJob_2");
        job_02.setDescription("bar");
        job_02.setSource(source);
        job_02.setTrigger((ReportJobTrigger)trigger2);
        job_02.setBaseOutputFilename("aReportJob_2_OUTPUT_" + new Date().getTime());
        job_02.addOutputFormat((byte)1);
        job_02.addOutputFormat((byte)4);
        job_02.setContentRepositoryDestination(repositoryDestination);
        boolean exceptionCaught = false;
        try {
            job_02.setMailNotification(mailNotification);
        }
        catch (Exception ex) {
            exceptionCaught = true;
        }
        AssertJUnit.assertTrue((boolean)exceptionCaught);
        mailNotification.setResultSendTypeCode(Byte.valueOf((byte)2));
        job_02.setMailNotification(mailNotification);
        job_02 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_02);
        m_logger.info((Object)("scheduled Job 02 id='" + job_02.getId() + "' label='" + job_02.getLabel() + " for " + report02StartDate));
        AssertJUnit.assertEquals((boolean)false, (boolean)job_02.getContentRepositoryDestination().isSaveToRepository());
        AssertJUnit.assertNotNull((Object)job_02);
        long jobId_02 = job_02.getId();
        boolean deleted = false;
        Byte paused = 3;
        Byte normal = 1;
        ArrayList<Byte> pausedL = new ArrayList<Byte>();
        pausedL.add(paused);
        ArrayList<Byte> normalL = new ArrayList<Byte>();
        normalL.add(normal);
        try {
            m_logger.info((Object)"now pause all");
            this.m_reportSchedulingService.pause(null, true);
            List summaryList = this.m_reportSchedulingService.getJobsByNextFireTime(this.m_executionContext, null, startDate, endDate, pausedL);
            int expectedSize = 2;
            AssertJUnit.assertEquals((String)("Error ! expected to get back " + expectedSize + " paused jobs, instead we got " + summaryList.size()), (int)expectedSize, (int)summaryList.size());
            boolean found1 = false;
            boolean found2 = false;
            for (ReportJobSummary rjs : summaryList) {
                m_logger.info((Object)(rjs.getId() + "  status = " + rjs.getRuntimeInformation().getStateCode() + ", note 'PAUSED == 3"));
                if (rjs.getId() == jobId_01) {
                    found1 = true;
                }
                if (rjs.getId() != jobId_02) continue;
                found2 = true;
            }
            AssertJUnit.assertTrue((String)("Error, we expected to have paused " + job_01 + " but we didn't !"), (boolean)found1);
            AssertJUnit.assertTrue((String)("Error, we expected to have paused " + job_02 + " but we didn't !"), (boolean)found2);
            m_logger.info((Object)"now do resume all");
            this.m_reportSchedulingService.resume(null, true);
            summaryList = this.m_reportSchedulingService.getJobsByNextFireTime(this.m_executionContext, null, startDate, endDate, normalL);
            expectedSize = 2;
            AssertJUnit.assertEquals((String)("Error ! expected to get back " + expectedSize + " paused jobs, instead we got " + summaryList.size()), (int)expectedSize, (int)summaryList.size());
            found1 = false;
            found2 = false;
            for (ReportJobSummary rjs : summaryList) {
                m_logger.info((Object)(rjs.getId() + "  status = " + rjs.getRuntimeInformation().getStateCode() + ", note 'NORMAL == 1"));
                if (rjs.getId() == jobId_01) {
                    found1 = true;
                }
                if (rjs.getId() != jobId_02) continue;
                found2 = true;
            }
            AssertJUnit.assertTrue((String)("Error, we expected to have resumed " + job_01 + " but we didn't !"), (boolean)found1);
            AssertJUnit.assertTrue((String)("Error, we expected to have resumed " + job_02 + " but we didn't !"), (boolean)found2);
            try {
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
                deleted = true;
            }
            catch (Throwable th) {
                m_logger.info((Object)("Error !  Throwable while attempting to delete job '" + th.getMessage() + "'"));
            }
            this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            AssertJUnit.assertNull((Object)job_01);
            job_02 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
            AssertJUnit.assertNull((Object)job_02);
        }
        finally {
            if (!deleted) {
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                }
                catch (Throwable th) {}
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_02));
                }
                catch (Throwable th) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doScheduleJobsOnceNowTest() {
        m_logger.info((Object)"\n\nReportSchedulingTestTestNG => doScheduleJobsOnceNowTest() called");
        Date now = new Date();
        long nowMillis = now.getTime();
        long windowIntervalMillis = 360000L;
        long queryWindowStart = nowMillis - 10L;
        long queryWindowEnd = nowMillis + windowIntervalMillis;
        Date report01StartDate = new Date(queryWindowStart + 1200000L);
        Date startDate = new Date(queryWindowStart);
        Date endDate = new Date(queryWindowEnd);
        m_logger.info((Object)("at test start, trigger query window startDate=" + startDate + ", endDate=" + endDate));
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        HashMap params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(report01StartDate);
        trigger.setOccurrenceCount(5);
        trigger.setRecurrenceInterval(1);
        trigger.setRecurrenceIntervalUnit((byte)1);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(true);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setDefaultReportOutputFolderURI("/default/report_output/folder");
        repositoryDestination.setUsingDefaultReportOutputFolderURI(true);
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_01 = new ReportJob();
        job_01.setLabel("hoo");
        job_01.setDescription("bar");
        job_01.setSource(source);
        job_01.setTrigger((ReportJobTrigger)trigger);
        job_01.setBaseOutputFilename("hoo_" + new Date().getTime());
        job_01.addOutputFormat((byte)1);
        job_01.addOutputFormat((byte)4);
        job_01.setContentRepositoryDestination(repositoryDestination);
        job_01.setMailNotification(mailNotification);
        job_01 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_01);
        m_logger.info((Object)("scheduled Job 01 id='" + job_01.getId() + "' label='" + job_01.getLabel() + " for " + report01StartDate));
        AssertJUnit.assertTrue((job_01 != null ? 1 : 0) != 0);
        long jobId_01 = job_01.getId();
        ReportJob readJob_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
        AssertJUnit.assertTrue((String)("Fatal error !  we were unable to retrieve job '" + jobId_01 + "' that we just scheduled !"), (readJob_01 != null ? 1 : 0) != 0);
        ArrayList<ReportJob> l = new ArrayList<ReportJob>();
        l.add(readJob_01);
        List scheduledOnceList = this.m_reportSchedulingService.scheduleJobsOnceNow(this.m_executionContext, l);
        if (scheduledOnceList == null || scheduledOnceList.size() <= 0) {
            AssertJUnit.assertEquals((Object)"Error our scheduleOnceList should contain 1 report, instead it is null or empty", (Object)false);
        }
        AssertJUnit.assertEquals((String)("Error our scheduleOnceList should contain 1 report, instead it contains " + scheduledOnceList.size()), (int)scheduledOnceList.size(), (int)1);
        ReportJob scheduledOnceJob = (ReportJob)scheduledOnceList.get(0);
        long scheduledOnceJobId = scheduledOnceJob.getId();
        m_logger.info((Object)("get jobs with nextFIreTime between start=" + startDate + " and end=" + endDate));
        m_logger.info((Object)("verify that our scheduleOnce Job " + scheduledOnceJobId + " has a nextFireTime before " + endDate));
        boolean deleted = false;
        try {
            List summaryList = this.m_reportSchedulingService.getJobsByNextFireTime(this.m_executionContext, null, startDate, endDate, null);
            StringBuilder sb = new StringBuilder();
            int count = 0;
            ReportJobSummary theSummary = null;
            ReportJobRuntimeInformation theInfo = null;
            for (ReportJobSummary js : summaryList) {
                ReportJobRuntimeInformation ri = js.getRuntimeInformation();
                if (js.getId() == scheduledOnceJobId) {
                    theInfo = ri;
                    theSummary = js;
                }
                Date nextFireTime = ri == null ? null : ri.getNextFireTime();
                String time = nextFireTime == null ? "NULL" : nextFireTime.toString();
                sb.append(count++ + " job " + js.getId() + " " + nextFireTime + " = " + time + "\n");
            }
            m_logger.info((Object)sb.toString());
            int expectedNumberOfReports = 1;
            m_logger.info((Object)("expecting query to return " + expectedNumberOfReports + " reports, got " + summaryList.size()));
            AssertJUnit.assertEquals((String)("Error ! expected to get back " + expectedNumberOfReports + " Reports in window but instead we got " + summaryList.size()), (int)expectedNumberOfReports, (int)summaryList.size());
            Date nextFireTime = theInfo.getNextFireTime();
            AssertJUnit.assertTrue((String)("Error !  Expected non-NULL Trigger.nextFireTime for runOnceNowJob " + scheduledOnceJobId), (nextFireTime != null ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)("Error !  Expected our runOnceNow Job to have a nextTriggerFireTime before " + endDate + ", but instead it is set for " + nextFireTime), (boolean)nextFireTime.before(endDate));
            try {
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(theSummary.getId()));
                deleted = true;
            }
            catch (Throwable th) {
                m_logger.info((Object)("Error !  Throwable while attempting to delete job '" + th.getMessage() + "'"));
            }
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            AssertJUnit.assertNull((Object)job_01);
            ReportJob job_02 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(theSummary.getId()));
            AssertJUnit.assertNull((Object)job_02);
        }
        finally {
            if (!deleted) {
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                }
                catch (Throwable th) {}
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(scheduledOnceJobId));
                }
                catch (Throwable th) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doBasicFindByNextFireTimeTriggerStatesPersistenceSanityTest() {
        m_logger.info((Object)"\n\nReportSchedulingTestTestNG => doBasicFindByNextFireTimeTriggerStatesPersistenceSanityTest() called");
        Date now = new Date();
        long nowMillis = now.getTime();
        long windowIntervalMillis = 360000L;
        long queryWindowStart = nowMillis - 10L;
        long queryWindowEnd = nowMillis + windowIntervalMillis;
        Date report01StartDate = new Date(queryWindowStart + 240000L);
        Date report02StartDate = new Date(queryWindowStart + 600000L);
        Date startDate = new Date(queryWindowStart);
        Date endDate = new Date(queryWindowEnd);
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI("/reports/samples/AllAccounts");
        HashMap params = new HashMap();
        source.setParametersMap(params);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(report01StartDate);
        trigger.setOccurrenceCount(5);
        trigger.setRecurrenceInterval(1);
        trigger.setRecurrenceIntervalUnit((byte)1);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/reports/samples");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(true);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        repositoryDestination.setDefaultReportOutputFolderURI("/default/report_output/folder");
        repositoryDestination.setUsingDefaultReportOutputFolderURI(true);
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job_01 = new ReportJob();
        job_01.setLabel("foo");
        job_01.setDescription("bar");
        job_01.setSource(source);
        job_01.setTrigger((ReportJobTrigger)trigger);
        job_01.setBaseOutputFilename("foo_" + new Date().getTime());
        job_01.addOutputFormat((byte)1);
        job_01.addOutputFormat((byte)4);
        job_01.setContentRepositoryDestination(repositoryDestination);
        job_01.setMailNotification(mailNotification);
        job_01 = this.m_reportSchedulingService.scheduleJob(this.m_executionContext, job_01);
        m_logger.info((Object)("scheduled Job 01 id='" + job_01.getId() + "' label='" + job_01.getLabel() + " for " + report01StartDate));
        AssertJUnit.assertNotNull((Object)job_01);
        long jobId_01 = job_01.getId();
        boolean deleted = false;
        Byte triggerStateNormal = 1;
        m_logger.info((Object)"search for Triggers in ReportJobRuntimeInformation.STATE_NORMAL=1");
        ArrayList<Byte> triggerStateArray = new ArrayList<Byte>();
        triggerStateArray.add(triggerStateNormal);
        try {
            List summaryList = this.m_reportSchedulingService.getJobsByNextFireTime(this.m_executionContext, null, startDate, endDate, triggerStateArray);
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (ReportJobSummary js : summaryList) {
                ReportJobRuntimeInformation ri = js.getRuntimeInformation();
                Date nextFireTime = ri == null ? null : ri.getNextFireTime();
                String time = nextFireTime == null ? "NULL" : nextFireTime.toString();
                sb.append(count++ + " job " + js.getId() + " " + nextFireTime + " = " + time + "\n");
            }
            m_logger.info((Object)sb.toString());
            m_logger.info((Object)("expecting query to return 1 report, got " + summaryList.size()));
            int expectedNumberOfReports = 1;
            AssertJUnit.assertEquals((String)("Error ! expected to get back 1 Report in window but instead we got " + summaryList.size()), (int)expectedNumberOfReports, (int)summaryList.size());
            ReportJobSummary rjs = (ReportJobSummary)summaryList.get(0);
            long id1 = rjs.getId();
            m_logger.info((Object)("Expected to get back jobId='" + jobId_01 + "', got '" + id1 + "'"));
            AssertJUnit.assertEquals((String)("Error ! expected to get back job01 id = '" + jobId_01 + "', but instead we got back " + id1), (long)id1, (long)jobId_01);
            try {
                this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                deleted = true;
            }
            catch (Throwable th) {
                m_logger.info((Object)("Error !  Throwable while attempting to delete job '" + th.getMessage() + "'"));
            }
            job_01 = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
            AssertJUnit.assertNull((Object)job_01);
        }
        finally {
            if (!deleted) {
                try {
                    this.m_reportJobsPersistenceService.deleteJob(this.m_executionContext, new ReportJobIdHolder(jobId_01));
                }
                catch (Throwable th) {}
            }
        }
    }

    private void testUpdateJobsByIDFAIL(long jobId_01, long jobId_02) {
        List<Object> jobIdHolders = new ArrayList<ReportJobIdHolder>();
        jobIdHolders.add(new ReportJobIdHolder(jobId_01));
        jobIdHolders.add(new ReportJobIdHolder(jobId_02));
        ReportJobModel jobModel = new ReportJobModel();
        ReportJobMailNotificationModel mailNotificationModel = new ReportJobMailNotificationModel();
        mailNotificationModel.setSubject("new subject");
        jobModel.setMailNotificationModel(mailNotificationModel);
        ReportJobSimpleTriggerModel trigger = new ReportJobSimpleTriggerModel();
        trigger.setStartDate(new Date());
        trigger.setOccurrenceCount(30);
        trigger.setRecurrenceInterval(15);
        trigger.setRecurrenceIntervalUnit((byte)2);
        jobModel.setTriggerModel((ReportJobTrigger)trigger);
        boolean throwException = false;
        try {
            jobIdHolders = this.m_reportJobsPersistenceService.updateJobsByID(this.m_executionContext, jobIdHolders, jobModel, false);
        }
        catch (Exception ex) {
            throwException = true;
        }
        AssertJUnit.assertTrue((boolean)throwException);
    }

    private void testUpdateJobsByIDFAILInvalidID(long jobId_01, long jobId_02) {
        List<Object> jobIdHolders = new ArrayList<ReportJobIdHolder>();
        jobIdHolders.add(new ReportJobIdHolder(jobId_01));
        jobIdHolders.add(new ReportJobIdHolder(jobId_02));
        jobIdHolders.add(new ReportJobIdHolder(111111111111L));
        ReportJobModel jobModel = new ReportJobModel();
        ReportJobMailNotificationModel mailNotificationModel = new ReportJobMailNotificationModel();
        mailNotificationModel.setSubject("new subject");
        jobModel.setMailNotificationModel(mailNotificationModel);
        boolean throwException = false;
        try {
            jobIdHolders = this.m_reportJobsPersistenceService.updateJobsByID(this.m_executionContext, jobIdHolders, jobModel, false);
        }
        catch (Exception ex) {
            throwException = true;
        }
        AssertJUnit.assertTrue((boolean)throwException);
    }

    private void testUpdateJobsByIDFAILInvalidPath(long jobId_01, long jobId_02) {
        List<Object> jobIdHolders = new ArrayList<ReportJobIdHolder>();
        jobIdHolders.add(new ReportJobIdHolder(jobId_01));
        jobIdHolders.add(new ReportJobIdHolder(jobId_02));
        ReportJobModel jobModel = new ReportJobModel();
        ReportJobRepositoryDestinationModel destinationModel = new ReportJobRepositoryDestinationModel();
        destinationModel.setFolderURI("SamplePath");
        destinationModel.setSaveToRepository(true);
        destinationModel.setUsingDefaultReportOutputFolderURI(false);
        jobModel.setContentRepositoryDestinationModel(destinationModel);
        jobModel.setBaseOutputFilename("ABC");
        boolean throwException = false;
        try {
            jobIdHolders = this.m_reportJobsPersistenceService.updateJobsByID(this.m_executionContext, jobIdHolders, jobModel, false);
        }
        catch (Exception ex) {
            throwException = true;
        }
        AssertJUnit.assertTrue((boolean)throwException);
    }

    private void testUpdateJobsByID(long jobId_01, long jobId_02) {
        List jobIdHolders = new ArrayList<ReportJobIdHolder>();
        jobIdHolders.add(new ReportJobIdHolder(jobId_01));
        jobIdHolders.add(new ReportJobIdHolder(jobId_02));
        ReportJobModel jobModel = new ReportJobModel();
        ReportJobMailNotificationModel mailNotificationModel = new ReportJobMailNotificationModel();
        mailNotificationModel.setSubject("new subject");
        jobModel.setMailNotificationModel(mailNotificationModel);
        jobIdHolders = this.m_reportJobsPersistenceService.updateJobsByID(this.m_executionContext, jobIdHolders, jobModel, false);
        AssertJUnit.assertEquals((int)2, (int)jobIdHolders.size());
        for (ReportJobIdHolder idHolder : jobIdHolders) {
            ReportJob reportJob = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, idHolder);
            AssertJUnit.assertEquals((String)"new subject", (String)reportJob.getMailNotification().getSubject());
        }
    }

    private void testUpdateJobsByReference(ReportJob job_01, ReportJob job_02) {
        List jobHolders = new ArrayList<ReportJob>();
        jobHolders.add(job_01);
        jobHolders.add(job_02);
        ReportJobModel jobModel = new ReportJobModel();
        ReportJobRepositoryDestinationModel destinationModel = new ReportJobRepositoryDestinationModel();
        destinationModel.setFolderURI("/test/report_scheduled");
        jobModel.setContentRepositoryDestinationModel(destinationModel);
        ReportJobMailNotificationModel mailNotificationModel = new ReportJobMailNotificationModel();
        mailNotificationModel.setSubject("new subject");
        jobModel.setMailNotificationModel(mailNotificationModel);
        ReportJobSimpleTriggerModel trigger = new ReportJobSimpleTriggerModel();
        trigger.setStartDate(new Date());
        trigger.setOccurrenceCount(50);
        trigger.setRecurrenceInterval(35);
        trigger.setRecurrenceIntervalUnit((byte)1);
        jobModel.setTrigger((ReportJobTrigger)trigger);
        jobHolders = this.m_reportJobsPersistenceService.updateJobs(this.m_executionContext, jobHolders, jobModel, true);
        AssertJUnit.assertEquals((int)2, (int)jobHolders.size());
        for (ReportJob reportJob : jobHolders) {
            reportJob = this.m_reportJobsPersistenceService.loadJob(this.m_executionContext, new ReportJobIdHolder(reportJob.getId()));
            AssertJUnit.assertEquals((String)"/test/report_scheduled", (String)reportJob.getContentRepositoryDestination().getFolderURI());
            AssertJUnit.assertEquals((String)"new subject", (String)reportJob.getMailNotification().getSubject());
            AssertJUnit.assertTrue((boolean)(reportJob.getTrigger() instanceof ReportJobSimpleTrigger));
            AssertJUnit.assertEquals((byte)1, (byte)((ReportJobSimpleTrigger)reportJob.getTrigger()).getRecurrenceIntervalUnit());
        }
    }

    private void testSorting(long jobId_01, long jobId_02) {
        List jobs = this.m_reportJobsPersistenceService.listJobs(this.m_executionContext, null, 0, -1, ReportJobModel.ReportJobSortType.SORTBY_REPORTNAME, true);
        AssertJUnit.assertEquals((long)jobId_02, (long)((ReportJobSummary)jobs.get(0)).getId());
        AssertJUnit.assertEquals((long)jobId_01, (long)((ReportJobSummary)jobs.get(1)).getId());
    }

    private void testSortingDES(long jobId_01, long jobId_02) {
        List jobs = this.m_reportJobsPersistenceService.listJobs(this.m_executionContext, null, 0, -1, ReportJobModel.ReportJobSortType.SORTBY_REPORTNAME, false);
        AssertJUnit.assertEquals((long)jobId_01, (long)((ReportJobSummary)jobs.get(0)).getId());
        AssertJUnit.assertEquals((long)jobId_02, (long)((ReportJobSummary)jobs.get(1)).getId());
    }

    private void testSortingNONEDES(long jobId_01, long jobId_02) {
        List jobs = this.m_reportJobsPersistenceService.listJobs(this.m_executionContext, null, 0, -1, ReportJobModel.ReportJobSortType.NONE, true);
        List jobs2 = this.m_reportJobsPersistenceService.listJobs(this.m_executionContext, null, 0, -1, ReportJobModel.ReportJobSortType.NONE, false);
        AssertJUnit.assertEquals((long)((ReportJobSummary)jobs.get(0)).getId(), (long)((ReportJobSummary)jobs2.get(1)).getId());
        AssertJUnit.assertEquals((long)((ReportJobSummary)jobs.get(1)).getId(), (long)((ReportJobSummary)jobs2.get(0)).getId());
    }

    private void testPagination(long jobId_01, long jobId_02) {
        List jobs = this.m_reportJobsPersistenceService.listJobs(this.m_executionContext, null, 1, 1, ReportJobModel.ReportJobSortType.SORTBY_JOBNAME, true);
        AssertJUnit.assertEquals((long)jobId_01, (long)((ReportJobSummary)jobs.get(0)).getId());
    }

    private void testListJobs(long jobId_01, long jobId_02, String userName) {
        ReportJobModel criteria = new ReportJobModel();
        ReportJobMailNotificationModel mailNotificationModel = new ReportJobMailNotificationModel();
        mailNotificationModel.setSubject("updated subject");
        criteria.setMailNotificationModel(mailNotificationModel);
        ArrayList<Long> expectedJob01 = new ArrayList<Long>();
        expectedJob01.add(jobId_01);
        this.compareResult(criteria, expectedJob01);
        criteria = new ReportJobModel();
        criteria.setLabel("foo");
        this.compareResult(criteria, expectedJob01);
        criteria = new ReportJobModel();
        HashSet<Byte> outputFormats = new HashSet<Byte>();
        outputFormats.add((byte)1);
        criteria.setOutputFormatsSet(outputFormats);
        ArrayList<Long> expectedJobBOTH = new ArrayList<Long>();
        expectedJobBOTH.add(jobId_01);
        expectedJobBOTH.add(jobId_02);
        this.compareResult(criteria, expectedJobBOTH);
        criteria = new ReportJobModel();
        criteria.setUsername(userName);
        this.compareResult(criteria, expectedJobBOTH);
        criteria = new ReportJobModel();
        ReportJobCalendarTriggerModel reportJobCalendarTriggerModel = new ReportJobCalendarTriggerModel();
        TreeSet<Byte> months = new TreeSet<Byte>();
        months.add(new Byte(1));
        months.add(new Byte(2));
        months.add(new Byte(3));
        reportJobCalendarTriggerModel.setMonths(months);
        criteria.setTriggerModel((ReportJobTrigger)reportJobCalendarTriggerModel);
        ArrayList<Long> expectedJob02 = new ArrayList<Long>();
        expectedJob02.add(jobId_02);
        this.compareResult(criteria, expectedJob02);
        criteria = new ReportJobModel();
        ReportJobSourceModel reportJobSourceModel = new ReportJobSourceModel();
        reportJobSourceModel.setReportUnitURI("/test/reportURI");
        criteria.setSourceModel(reportJobSourceModel);
        this.compareResult(criteria, expectedJob01);
        criteria = new ReportJobModel();
        ReportJobRepositoryDestinationModel reportJobRepositoryDestinationModel = new ReportJobRepositoryDestinationModel();
        reportJobRepositoryDestinationModel.setSequentialFilenames(false);
        criteria.setContentRepositoryDestinationModel(reportJobRepositoryDestinationModel);
        this.compareResult(criteria, expectedJob02);
        criteria = new ReportJobModel();
        reportJobRepositoryDestinationModel = new ReportJobRepositoryDestinationModel();
        FTPInfoModel ftpInfoModel = new FTPInfoModel();
        ftpInfoModel.setUserName("JohnSmith");
        reportJobRepositoryDestinationModel.setOutputFTPInfoModel(ftpInfoModel);
        criteria.setContentRepositoryDestinationModel(reportJobRepositoryDestinationModel);
        this.compareResult(criteria, expectedJob02);
        criteria.setMailNotificationModel(mailNotificationModel);
        this.compareResult(criteria, new ArrayList<Long>());
        criteria = new ReportJobModel();
        mailNotificationModel = new ReportJobMailNotificationModel();
        ArrayList<String> toAddress = new ArrayList<String>();
        toAddress.add("peter@pan.com");
        mailNotificationModel.setToAddresses(toAddress);
        criteria.setMailNotificationModel(mailNotificationModel);
        this.compareResult(criteria, expectedJob02);
    }

    private void compareResult(ReportJobModel criteria, List<Long> expectedJobIDs) {
        List jobs = this.m_reportJobsPersistenceService.listJobs(this.m_executionContext, criteria, 0, -1, null, true);
        if (jobs == null || jobs.size() == 0) {
            AssertJUnit.assertTrue((expectedJobIDs == null || expectedJobIDs.size() == 0 ? 1 : 0) != 0);
            return;
        }
        AssertJUnit.assertNotNull((Object)jobs);
        AssertJUnit.assertEquals((int)expectedJobIDs.size(), (int)jobs.size());
        boolean found = false;
        for (Object element : jobs) {
            AssertJUnit.assertTrue((boolean)(element instanceof ReportJobSummary));
            ReportJobSummary summary = (ReportJobSummary)element;
            if (!expectedJobIDs.contains(summary.getId())) continue;
            found = true;
            break;
        }
        AssertJUnit.assertTrue((boolean)found);
    }

    @Test(dependsOnMethods={"doPersistenceTest"})
    public void doLoggingTest() {
        m_logger.info((Object)"ReportSchedulingTestTestNG => doLoggingTest() called");
        LogEvent event = this.m_loggingService.instantiateLogEvent();
        event.setComponent("reportScheduler");
        event.setType((byte)1);
        event.setMessageCode("log.error.report.job.failed");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("Quartz Job: testJob");
        printWriter.println("Quartz Trigger: testTrigger");
        printWriter.println("Exceptions:");
        try {
            int[] i = new int[2];
            int j = i[5];
        }
        catch (Exception e) {
            e.printStackTrace(printWriter);
        }
        printWriter.flush();
        event.setText(writer.toString());
        event.setState((byte)1);
        this.m_loggingService.log(event);
        this.eventId = event.getId();
    }
}

