/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.domain.Result;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.TrialReportUnitRequest;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EngineServiceTestsTestNG
extends BaseServiceSetupTestNG {
    private ExecutionContext m_context;
    protected static Log m_logger = LogFactory.getLog(EngineServiceTestsTestNG.class);

    public EngineServiceTestsTestNG() {
        m_logger.info((Object)"EngineServiceTestsTestNG => constructor() called");
    }

    @BeforeClass
    public void onSetUp() throws Exception {
        m_logger.info((Object)"EngineServiceTestsTestNG => onSetUp() called");
        this.m_context = new ExecutionContextImpl();
        this.createBeanDS();
        this.createTableModelDS();
        this.createCustomDSReportTemplate();
        this.createCustomDSReport();
        this.createTableModelDSReport();
    }

    @AfterClass
    public void onTearDown() throws Exception {
        m_logger.info((Object)"EngineServiceTestsTestNG => onTearDown() called");
        this.deleteTableModelDSReport();
        this.deleteCustomDSReport();
        this.deleteCustomDSReportTemplate();
        this.deleteTableModelDS();
        this.deleteBeanDS();
    }

    @Test
    public void doExecuteTest() throws Exception {
        m_logger.info((Object)"EngineServiceTestsTestNG => doExecuteTest() called");
        FileResource reportRes = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "EmployeesJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/Employees.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Employees_JDBC");
        unit.setLabel("Employees_JDBC");
        unit.setParentFolder("/reports/samples");
        unit.setDataSourceReference("/datasources/JServerJdbcDS");
        unit.setMainReport(reportRes);
        this.getRepositoryService().saveResource(null, (Resource)unit);
        ReportUnitResult result = (ReportUnitResult)this.getEngineService().execute(this.m_context, (Request)new ReportUnitRequest("/reports/samples/Employees_JDBC", new HashMap()));
        AssertJUnit.assertNotNull((Object)result);
        JasperPrint jasperPrint = result.getJasperPrint();
        AssertJUnit.assertNotNull((Object)jasperPrint);
        List pages = jasperPrint.getPages();
        AssertJUnit.assertNotNull((Object)pages);
        AssertJUnit.assertTrue((pages.size() > 0 ? 1 : 0) != 0);
        this.getRepositoryService().deleteResource(null, "/reports/samples/Employees_JDBC");
    }

    @Test
    public void doGetResourcesTest() throws Exception {
        m_logger.info((Object)"EngineServiceTestsTestNG => doGetResourcesTest() called");
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryService().getResource(this.m_context, "/reports/samples/AllAccounts");
        AssertJUnit.assertNotNull((Object)reportUnit);
        ResourceReference reportRef = reportUnit.getMainReport();
        AssertJUnit.assertNotNull((Object)reportRef);
        AssertJUnit.assertTrue((boolean)reportRef.isLocal());
        Resource report = reportRef.getLocalResource();
        AssertJUnit.assertNotNull((Object)report);
        AssertJUnit.assertTrue((boolean)(report instanceof FileResource));
        Resource[] resources = this.getEngineService().getResources(new ResourceReference(report));
        AssertJUnit.assertNotNull((Object)resources);
        AssertJUnit.assertTrue((resources.length == 2 ? 1 : 0) != 0);
    }

    @Test
    public void doValidateTest() {
        m_logger.info((Object)"EngineServiceTestsTestNG => doValidateTest() called");
        ReportUnit unit = this.createUnit();
        ValidationResult result = this.getEngineService().validate(null, unit);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"ERROR", (String)result.getValidationState());
        List results = result.getResults();
        AssertJUnit.assertNotNull((Object)results);
        AssertJUnit.assertTrue((results.size() >= 1 ? 1 : 0) != 0);
        ValidationDetail detail = (ValidationDetail)results.get(0);
        AssertJUnit.assertNotNull((Object)detail);
        AssertJUnit.assertEquals((String)"SalesByMonthTrialReport", (String)detail.getName());
        this.addJar(unit);
        result = this.getEngineService().validate(null, unit);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"VALID", (String)result.getValidationState());
    }

    @Test
    public void doTrialExecuteTest() {
        m_logger.info((Object)"EngineServiceTestsTestNG => doTrialExecuteTest() called");
        ReportUnit unit = this.createUnit();
        this.addJar(unit);
        TrialReportUnitRequest request = new TrialReportUnitRequest(unit, null);
        Result result = this.getEngineService().execute(null, (Request)request);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertTrue((boolean)(result instanceof ReportUnitResult));
        ReportUnitResult ruRes = (ReportUnitResult)result;
        JasperPrint print = ruRes.getJasperPrint();
        AssertJUnit.assertNotNull((Object)print);
        List pages = print.getPages();
        AssertJUnit.assertNotNull((Object)pages);
        AssertJUnit.assertTrue((pages.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void doGetMainJasperReportTest() {
        m_logger.info((Object)"EngineServiceTestsTestNG => doGetMainJasperReportTest() called");
        JasperReport jasperReport = this.getEngineService().getMainJasperReport(null, "/reports/samples/AllAccounts");
        AssertJUnit.assertNotNull((Object)jasperReport);
        AssertJUnit.assertEquals((String)"AllAccounts", (String)jasperReport.getName());
    }

    @Test
    public void doExecuteWithCustomDataSourceTest() throws Exception {
        m_logger.info((Object)"EngineServiceTestsTestNG => doExecuteWithCustomDataSourceTest() called");
        ReportUnitResult result = (ReportUnitResult)this.getEngineService().execute(this.m_context, (Request)new ReportUnitRequest("/reports/samples/DataSourceReport", new HashMap()));
        AssertJUnit.assertNotNull((Object)result);
        JasperPrint jasperPrint = result.getJasperPrint();
        AssertJUnit.assertNotNull((Object)jasperPrint);
        List pages = jasperPrint.getPages();
        AssertJUnit.assertNotNull((Object)pages);
        AssertJUnit.assertTrue((pages.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void doExecuteWithTableModelDataSourceTest() throws Exception {
        m_logger.info((Object)"EngineServiceTestsTestNG => doExecuteWithTableModelDataSourceTest() called");
        ReportUnitResult result = (ReportUnitResult)this.getEngineService().execute(this.m_context, (Request)new ReportUnitRequest("/reports/samples/DataSourceTableModel", new HashMap()));
        AssertJUnit.assertNotNull((Object)result);
        JasperPrint jasperPrint = result.getJasperPrint();
        AssertJUnit.assertNotNull((Object)jasperPrint);
        List pages = jasperPrint.getPages();
        AssertJUnit.assertNotNull((Object)pages);
        AssertJUnit.assertTrue((pages.size() > 0 ? 1 : 0) != 0);
    }

    private ReportUnit createUnit() {
        ReportUnit unit = (ReportUnit)this.getRepositoryService().newResource(null, ReportUnit.class);
        this.setCommon((Resource)unit, "SalesByMonthTrial");
        unit.setParentFolder("/reports");
        FileResource mainReport = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        mainReport.setFileType("jrxml");
        this.setCommon((Resource)mainReport, "SalesByMonthTrialReport");
        mainReport.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonth.jrxml"));
        unit.setMainReport(mainReport);
        unit.setDataSourceReference("/datasources/JServerJdbcDS");
        FileResource img = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        img.setFileType("img");
        img.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        this.setCommon((Resource)img, "Logo");
        unit.addResource(img);
        FileResource subrep = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        subrep.setFileType("jrxml");
        subrep.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonthDetail.jrxml"));
        this.setCommon((Resource)subrep, "SalesByMonthDetail");
        unit.addResource(subrep);
        FileResource resBdl = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/sales.properties"));
        this.setCommon((Resource)resBdl, "sales.properties");
        unit.addResource(resBdl);
        return unit;
    }

    private void addJar(ReportUnit unit) {
        FileResource jar = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        jar.setFileType("jar");
        jar.readData(((Object)((Object)this)).getClass().getResourceAsStream("/jars/scriptlet.jar"));
        this.setCommon((Resource)jar, "Scriptlet");
        unit.addResource(jar);
    }

    private void setCommon(Resource res, String id) {
        res.setName(id);
        res.setLabel(id + "_label");
        res.setDescription(id + " description");
    }

    private void createBeanDS() {
        m_logger.info((Object)"EngineServiceTestsTestNG => createBeanDS() is creating /datasources/CustomDSFromBean");
        BeanReportDataSource datasource = (BeanReportDataSource)this.getUnsecureRepositoryService().newResource(null, BeanReportDataSource.class);
        datasource.setName("CustomDSFromBean");
        datasource.setLabel("Custom data source from a bean");
        datasource.setDescription("A custom data source through a bean");
        datasource.setParentFolder("/datasources");
        datasource.setBeanName("customTestDataSourceService");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void deleteBeanDS() {
        m_logger.info((Object)"EngineServiceTestsTestNG => deleteBeanDS() is deleting /datasources/CustomDSFromBean");
        this.deleteResource("/datasources/CustomDSFromBean");
    }

    private void createTableModelDS() {
        m_logger.info((Object)"EngineServiceTestsTestNG => createTableModelDS() is creating /datasources/CustomTableModelDS");
        BeanReportDataSource datasource = (BeanReportDataSource)this.getUnsecureRepositoryService().newResource(null, BeanReportDataSource.class);
        datasource.setName("CustomTableModelDS");
        datasource.setLabel("Custom data source from a table model");
        datasource.setDescription("A custom data source through a table model");
        datasource.setParentFolder("/datasources");
        datasource.setBeanName("customTestDataSourceServiceFactory");
        datasource.setBeanMethod("tableModelDataSource");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void deleteTableModelDS() {
        m_logger.info((Object)"EngineServiceTestsTestNG => deleteTableModelDS() is deleting /datasources/CustomTableModelDS");
        this.deleteResource("/datasources/CustomTableModelDS");
    }

    private void createCustomDSReportTemplate() {
        m_logger.info((Object)"EngineServiceTestsTestNG => createCustomDSReportTemplate() is creating /reports/samples/DataSourceReportTemplate");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("DataSourceReportTemplate");
        reportRes.setLabel("Report showing Custom Data Source");
        reportRes.setDescription("Report showing use of Custom Data Source via a bean");
        reportRes.setParentFolder("/reports/samples");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/DataSourceReport.jrxml");
        reportRes.readData(jrxml);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)reportRes);
    }

    private void deleteCustomDSReportTemplate() {
        m_logger.info((Object)"EngineServiceTestsTestNG => deleteCustomDSReportTemplate() is deleting /reports/samples/DataSourceReportTemplate");
        this.deleteResource("/reports/samples/DataSourceReportTemplate");
    }

    private void createCustomDSReport() {
        m_logger.info((Object)"EngineServiceTestsTestNG => createCustomDSReport() is creating /reports/samples/DataSourceReport");
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("DataSourceReport");
        unit.setLabel("Report showing Custom Data Source");
        unit.setDescription("Report showing use of Custom Data Source via a bean");
        unit.setParentFolder("/reports/samples");
        unit.setMainReportReference("/reports/samples/DataSourceReportTemplate");
        unit.setDataSourceReference("/datasources/CustomDSFromBean");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void deleteCustomDSReport() {
        m_logger.info((Object)"EngineServiceTestsTestNG => deleteCustomDSReport() is deleting /reports/samples/DataSourceReport");
        this.deleteResource("/reports/samples/DataSourceReport");
    }

    private void createTableModelDSReport() {
        m_logger.info((Object)"EngineServiceTestsTestNG => createTableModelDSReport() is creating /reports/samples/DataSourceTableModel");
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("DataSourceTableModel");
        unit.setLabel("Table Model Data Source");
        unit.setDescription("Report showing use of Custom Data Source via table model");
        unit.setParentFolder("/reports/samples");
        unit.setMainReportReference("/reports/samples/DataSourceReportTemplate");
        unit.setDataSourceReference("/datasources/CustomTableModelDS");
        unit.setMainReportReference("/reports/samples/DataSourceReportTemplate");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void deleteTableModelDSReport() {
        m_logger.info((Object)"EngineServiceTestsTestNG => deleteTableModelDSReport() is deleting /reports/samples/DataSourceTableModel");
        this.deleteResource("/reports/samples/DataSourceTableModel");
    }

    private void deleteResource(String uri) {
        Resource result = this.getRepositoryService().getResource(null, uri);
        AssertJUnit.assertNotNull((Object)result);
        this.getRepositoryService().deleteResource(null, uri);
    }
}

