/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileBufferedDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ContentRepositoryTestTestNG
extends BaseServiceSetupTestNG {
    protected static Log m_logger = LogFactory.getLog(ContentRepositoryTestTestNG.class);

    public ContentRepositoryTestTestNG() {
        m_logger.info((Object)"ContentRepositoryTestTestNG => constructor() called");
    }

    @Test
    public void doCreateFilesTest() throws Exception {
        m_logger.info((Object)"ContentRepositoryTestTestNG => doCreateFilesTest() called");
        ContentResource fileResource = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        fileResource.setName("PdfTestFile");
        fileResource.setLabel("Pdf test file");
        fileResource.setParentFolder("/ContentFiles/pdf");
        InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("/FontsReport.pdf");
        fileResource.setDataContainer(this.createFileDataContainer(file));
        fileResource.setFileType("pdf");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)fileResource);
        m_logger.info((Object)"ContentRepositoryTestTestNG => doCreateFilesTest() created file /ContentFiles/pdf/PdfTestFile");
        ContentResource htmlFile = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        htmlFile.setName("HtmlTestFile");
        htmlFile.setLabel("HTML test file with images");
        htmlFile.setParentFolder("/ContentFiles/html");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html");
        htmlFile.setDataContainer(this.createFileDataContainer(file));
        htmlFile.setFileType("html");
        ArrayList<ContentResource> images = new ArrayList<ContentResource>();
        ContentResource image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("img_0_0_1");
        image.setLabel("img_0_0_1");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/img_0_0_1");
        image.readData(file);
        image.setFileType("html");
        images.add(image);
        image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("img_0_7_125");
        image.setLabel("img_0_7_125");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/img_0_7_125");
        image.readData(file);
        image.setFileType("html");
        images.add(image);
        image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("px");
        image.setLabel("px");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/px");
        image.readData(file);
        image.setFileType("html");
        images.add(image);
        htmlFile.setResources(images);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)htmlFile);
        m_logger.info((Object)"ContentRepositoryTestTestNG => doCreateFilesTest() created file /ContentFiles/html/HtmlTestFile");
        htmlFile = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        htmlFile.setName("Test");
        htmlFile.setLabel("HTML test file with one image");
        htmlFile.setParentFolder("/ContentFiles/html");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/Test.html");
        htmlFile.readData(file);
        htmlFile.setFileType("html");
        image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("image0");
        image.setLabel("image0");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/Test.html_files/image0");
        image.readData(file);
        image.setFileType("html");
        images = new ArrayList();
        images.add(image);
        htmlFile.setResources(images);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)htmlFile);
        m_logger.info((Object)"ContentRepositoryTestTestNG => doCreateFilesTest() created file /ContentFiles/html/Test");
    }

    @Test(dependsOnMethods={"doCreateFilesTest"})
    public void doDeleteFilesTest() throws Exception {
        m_logger.info((Object)"ContentRepositoryTestTestNG => doDeleteFilesTest() called");
        this.deleteResource("/ContentFiles/html/Test");
        m_logger.info((Object)"ContentRepositoryTestTestNG => doDeleteFilesTest() deleted file /ContentFiles/html/Test");
        this.deleteResource("/ContentFiles/html/HtmlTestFile");
        m_logger.info((Object)"ContentRepositoryTestTestNG => doDeleteFilesTest() deleted file /ContentFiles/html/HtmlTestFile");
        this.deleteResource("/ContentFiles/pdf/PdfTestFile");
        m_logger.info((Object)"ContentRepositoryTestTestNG => doDeleteFilesTest() deleted file /ContentFiles/pdf/PdfTestFile");
    }

    private void deleteResource(String uri) {
        Resource result = this.getUnsecureRepositoryService().getResource(null, uri);
        AssertJUnit.assertNotNull((Object)result);
        this.getUnsecureRepositoryService().deleteResource(null, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataContainer createFileDataContainer(InputStream file) throws Exception {
        FileBufferedDataContainer dataContainer = new FileBufferedDataContainer();
        OutputStream os = dataContainer.getOutputStream();
        byte[] buf = new byte[4000];
        try {
            int dataSize;
            while ((dataSize = file.read(buf)) != -1) {
                os.write(buf, 0, dataSize);
            }
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                    os.close();
                }
                catch (IOException ex) {}
            }
        }
        return dataContainer;
    }
}

