/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.repository.test;

import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.mode.SearchModeSettingsResolver;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.service.ResourceService;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResourceServiceTestNG
extends BaseServiceSetupTestNG {
    protected static Log log = LogFactory.getLog(ResourceServiceTestNG.class);
    private static final String ROOT_TEST_FOLDER_NAME = "root_search_test_folder";
    private static final String ROOT_TEST_FOLDER_URI = "/root_search_test_folder";
    private InitialStateResolver initialStateResolver;
    private SearchCriteriaFactory searchCriteriaFactory;
    private SearchModeSettingsResolver searchModeSettingsResolver;
    private RepositorySearchService repositorySearchService;
    private ResourceService resourceService;
    private SearchSorter defaultSorter;

    public ResourceServiceTestNG() {
        log.info((Object)"SearchServiceTestNG => constructor() called");
    }

    @Resource(name="searchInitialStateResolver")
    public void setSearchInitialStateResolver(InitialStateResolver initialStateResolver) {
        this.initialStateResolver = initialStateResolver;
    }

    @Resource(name="searchModeSettingsResolver")
    public void setSearchModeSettingsResolver(SearchModeSettingsResolver searchModeSettingsResolver) {
        this.searchModeSettingsResolver = searchModeSettingsResolver;
    }

    @Resource(name="searchCriteriaFactory")
    public void setSearchCriteriaFactory(SearchCriteriaFactory searchCriteriaFactory) {
        this.searchCriteriaFactory = searchCriteriaFactory;
    }

    @Resource(name="repositorySearchService")
    public void setRepositorySearchService(RepositorySearchService repositorySearchService) {
        this.repositorySearchService = repositorySearchService;
    }

    @Resource(name="resourceService")
    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @BeforeMethod
    public void log(Method m) {
        log.info((Object)this.msg("%s#%s called.", ((Object)((Object)this)).getClass().getName(), m.getName()));
    }

    @Test
    public void shouldCheckDependentReportsForDataSource() throws Exception {
        this.setAuthenticatedUser("jasperadmin");
        List results = this.resourceService.check(null, this.testResources("/datasources/JServerJNDIDS"));
        AssertJUnit.assertEquals((String)"Should find zero dependent reports.", (int)0, (int)results.size());
    }

    @Test
    public void shouldCheckDependentReportsForNonDataSource() throws Exception {
        List results = this.resourceService.check(null, this.testResources("/reports/samples/AllAccounts"));
        AssertJUnit.assertEquals((String)"Should find zero dependent reports.", (int)0, (int)results.size());
    }

    @Test
    public void shouldCheckDependentReportsForMixedResources() throws Exception {
        List results = this.resourceService.check(null, this.testResources("/datasources/JServerJNDIDS", "/reports/samples/AllAccounts"));
        AssertJUnit.assertEquals((String)"Should find zero dependent reports.", (int)0, (int)results.size());
    }

    private List<com.jaspersoft.jasperserver.api.metadata.common.domain.Resource> testResources(String ... uris) {
        ArrayList<com.jaspersoft.jasperserver.api.metadata.common.domain.Resource> resources = new ArrayList<com.jaspersoft.jasperserver.api.metadata.common.domain.Resource>();
        for (String uri : uris) {
            ResourceDetails resource = new ResourceDetails();
            resource.setURIString(uri);
            resources.add((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource);
        }
        return resources;
    }
}

