/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.repository.test;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RepositoryServiceDependentResourcesTest
extends BaseServiceSetupTestNG {
    protected static final Log logger = LogFactory.getLog(RepositoryServiceDependentResourcesTest.class);
    private SearchCriteriaFactory searchCriteriaFactory;
    private static String[] uriList = new String[]{"/reports/samples/AllAccounts", "/reports/samples/Cascading_multi_select_report", "/reports/samples/EmployeeAccounts", "/reports/samples/Employees", "/reports/samples/Freight", "/reports/samples/SalesByMonth", "/reports/samples/StandardChartsAegeanReport", "/reports/samples/StandardChartsEyeCandyReport", "/reports/samples/StandardChartsReport"};
    private String expectedOrder;
    private String expectedOrderForTopFive;

    @BeforeMethod
    public void log(Method m) {
        logger.info((Object)this.msg("@@@ Running -> %s", m.getName()));
        this.expectedOrder = ArrayUtils.toString((Object)uriList);
        this.expectedOrderForTopFive = ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])uriList, (int)0, (int)5));
    }

    @Test
    public void shouldFindAllDependantReportsForDataSource() {
        AssertJUnit.assertNotNull((String)"RepositoryService service is not wired.", (Object)this.getRepositoryService());
        AssertJUnit.assertNotNull((String)"SearchCriteriaFactory service is not wired.", (Object)this.searchCriteriaFactory);
        String uri = "/datasources/JServerJNDIDS";
        List resources = this.getRepositoryService().getDependentResources(null, uri, this.searchCriteriaFactory, 0, 20);
        AssertJUnit.assertEquals((String)"Should find 9 dependant resources.", (int)9, (int)resources.size());
        AssertJUnit.assertEquals((String)"All resources should be lookup's.", (int)9, (int)CollectionUtils.countMatches((Collection)resources, (Predicate)PredicateUtils.instanceofPredicate(ResourceLookup.class)));
        Collection types = CollectionUtils.collect((Collection)resources, (Transformer)TransformerUtils.invokerTransformer((String)"getResourceType"));
        AssertJUnit.assertEquals((String)"All lookup's should have type ReportUnit.", (int)9, (int)CollectionUtils.countMatches((Collection)types, (Predicate)PredicateUtils.equalPredicate((Object)"com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit")));
        String sortOrder = ArrayUtils.toString((Object)CollectionUtils.collect((Collection)resources, (Transformer)TransformerUtils.invokerTransformer((String)"getURIString")).toArray());
        AssertJUnit.assertEquals((String)"Resources should be sorted in order.", (String)this.expectedOrder, (String)sortOrder);
    }

    @Test
    public void shouldFindFirstFiveDependantReportsForDataSource() {
        AssertJUnit.assertNotNull((String)"RepositoryService service is not wired.", (Object)this.getRepositoryService());
        AssertJUnit.assertNotNull((String)"SearchCriteriaFactory service is not wired.", (Object)this.searchCriteriaFactory);
        String uri = "/datasources/JServerJNDIDS";
        List resources = this.getRepositoryService().getDependentResources(null, uri, this.searchCriteriaFactory, 0, 5);
        AssertJUnit.assertEquals((String)"Should find 5 dependant resources.", (int)5, (int)resources.size());
        AssertJUnit.assertEquals((String)"All resources should be lookup's.", (int)5, (int)CollectionUtils.countMatches((Collection)resources, (Predicate)PredicateUtils.instanceofPredicate(ResourceLookup.class)));
        String sortOrder = ArrayUtils.toString((Object)CollectionUtils.collect((Collection)resources, (Transformer)TransformerUtils.invokerTransformer((String)"getURIString")).toArray());
        AssertJUnit.assertEquals((String)"Resources should be sorted in order.", (String)this.expectedOrderForTopFive, (String)sortOrder);
    }

    @Resource(name="searchCriteriaFactory")
    public void setSearchCriteriaFactory(SearchCriteriaFactory searchCriteriaFactory) {
        this.searchCriteriaFactory = searchCriteriaFactory;
    }
}

