/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.api.search.TransformerFactory;
import com.jaspersoft.jasperserver.search.common.CustomFilter;
import com.jaspersoft.jasperserver.search.common.CustomSorter;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.mode.SearchModeSettingsResolver;
import com.jaspersoft.jasperserver.search.service.ChildrenLoaderService;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.service.ResourceService;
import com.jaspersoft.jasperserver.search.service.impl.RepositorySearchCriteriaImpl;
import com.jaspersoft.jasperserver.search.sorter.ByLabelSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class RepositorySearchServiceImpl
implements RepositorySearchService,
Diagnostic {
    protected RepositoryService repositoryService;
    private ResourceService resourceService;
    protected TransformerFactory transformerFactory;
    private Map<String, ChildrenLoaderService> childrenLoaders;
    protected SearchCriteriaFactory defaultSearchCriteriaFactory;
    private SearchModeSettingsResolver searchModeSettingsResolver;
    protected Map<String, List<String>> filterOptionToResourceTypes;

    public void setSearchModeSettingsResolver(SearchModeSettingsResolver searchModeSettingsResolver) {
        this.searchModeSettingsResolver = searchModeSettingsResolver;
    }

    public void setDefaultSearchCriteriaFactory(SearchCriteriaFactory defaultSearchCriteriaFactory) {
        this.defaultSearchCriteriaFactory = defaultSearchCriteriaFactory;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public void setFilterOptionToResourceTypes(Map<String, List<String>> filterOptionToResourceTypes) {
        this.filterOptionToResourceTypes = filterOptionToResourceTypes;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResults(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter, int current, int max) {
        List resources = this.repositoryService.getResources(context, searchCriteriaFactory, filters, sorter, this.transformerFactory, current, max);
        return this.getResourceDetailsList(resources);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResults(ExecutionContext context, RepositorySearchCriteria criteria) {
        context = this.putCriteriaToContext(context, criteria);
        RepositorySearchConfiguration configuration = this.getConfiguration(criteria.getSearchMode() != null ? criteria.getSearchMode() : SearchMode.SEARCH);
        List<SearchFilter> allFiltersList = this.createAllFiltersList(configuration);
        if (criteria.getCustomFilters() != null && !criteria.getCustomFilters().isEmpty()) {
            allFiltersList.addAll(criteria.getCustomFilters());
        }
        SearchCriteriaFactory factory = this.defaultSearchCriteriaFactory;
        List<String> resourceTypes = criteria.getResourceTypes();
        if (resourceTypes != null && resourceTypes.size() == 1) {
            String singleResourceType = resourceTypes.get(0);
            factory = this.defaultSearchCriteriaFactory.newFactory(singleResourceType);
            if (Folder.class.getName().equals(singleResourceType)) {
                resourceTypes.clear();
            }
        }
        return this.getResults(context, factory, allFiltersList, this.getSorter(configuration, criteria.getSortBy()), criteria.getStartIndex(), criteria.getMaxCount());
    }

    @Override
    public int getResultsCount(ExecutionContext context, RepositorySearchCriteria criteria) {
        context = this.putCriteriaToContext(context, criteria);
        RepositorySearchConfiguration configuration = this.getConfiguration(criteria.getSearchMode() != null ? criteria.getSearchMode() : SearchMode.SEARCH);
        List<SearchFilter> allFiltersList = this.createAllFiltersList(configuration);
        if (criteria.getCustomFilters() != null && !criteria.getCustomFilters().isEmpty()) {
            allFiltersList.addAll(criteria.getCustomFilters());
        }
        SearchCriteriaFactory factory = this.defaultSearchCriteriaFactory;
        List<String> resourceTypes = criteria.getResourceTypes();
        if (resourceTypes != null && resourceTypes.size() == 1) {
            String singleResourceType = resourceTypes.get(0);
            factory = this.defaultSearchCriteriaFactory.newFactory(singleResourceType);
            if (Folder.class.getName().equals(singleResourceType)) {
                resourceTypes.clear();
            }
        }
        return this.getResultsCount(context, factory, allFiltersList, this.getSorter(configuration, criteria.getSortBy()));
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        final RepositorySearchCriteria repositorySearchCriteria = new RepositorySearchCriteriaImpl.Builder().setFolderUri("/").setSearchText(null).setStartIndex(0).setMaxCount(0).setSearchMode(SearchMode.SEARCH).setSortBy("name").getCriteria();
        final RepositorySearchConfiguration configuration = this.getConfiguration(repositorySearchCriteria.getSearchMode());
        final SearchCriteriaFactory factory = this.defaultSearchCriteriaFactory.newFactory(Resource.class.getCanonicalName());
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("TotalReportsCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-reports"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, (SearchSorter)new ByLabelSorter(), RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).addDiagnosticAttribute("TotalReportOutputsCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-reportOutput"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, (SearchSorter)new ByLabelSorter(), RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).addDiagnosticAttribute("TotalFoldersCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                return RepositorySearchServiceImpl.this.repositoryService.getAllFolders(null).size();
            }
        }).addDiagnosticAttribute("TotalOlapViewsCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-view"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, (SearchSorter)new ByLabelSorter(), RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).addDiagnosticAttribute("TotalDataSourcesCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-dataSources"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, (SearchSorter)new ByLabelSorter(), RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).build();
    }

    protected ExecutionContext putCriteriaToContext(ExecutionContext context, RepositorySearchCriteria criteria) {
        ExecutionContext nullSafeContext;
        ExecutionContext executionContext = nullSafeContext = context != null ? context : ExecutionContextImpl.getRuntimeExecutionContext();
        if (nullSafeContext.getAttributes() == null) {
            nullSafeContext.setAttributes(new ArrayList());
        }
        nullSafeContext.getAttributes().add(criteria);
        return nullSafeContext;
    }

    public SearchSorter getSorter(RepositorySearchConfiguration configuration, String sortBy) {
        SearchSorter result = null;
        SearchSorter defaultSorter = null;
        for (CustomSorter sorter : configuration.getCustomSorters()) {
            if (sorter.getId().equals(sortBy)) {
                result = sorter.getSearchSorter();
                break;
            }
            if (!sorter.isDefault()) continue;
            defaultSorter = sorter.getSearchSorter();
        }
        return result != null ? result : defaultSorter;
    }

    protected RepositorySearchConfiguration getConfiguration(SearchMode searchMode) {
        return this.searchModeSettingsResolver.getSettings(searchMode).getRepositorySearchConfiguration();
    }

    protected List<SearchFilter> createAllFiltersList(RepositorySearchConfiguration configuration) {
        ArrayList<SearchFilter> filterList = new ArrayList<SearchFilter>();
        filterList.addAll(configuration.getSystemFilters());
        filterList.addAll(this.getRestrictionsFilters(configuration));
        return filterList;
    }

    protected List<SearchFilter> getRestrictionsFilters(RepositorySearchConfiguration configuration) {
        HashSet<String> customFilerIds = new HashSet<String>(configuration.getCustomFiltersMap().keySet());
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        if (customFilerIds != null && !customFilerIds.isEmpty()) {
            for (CustomFilter filter : configuration.getCustomFilters()) {
                if (!customFilerIds.contains(filter.getId())) continue;
                filters.add(filter.getFilter());
            }
        }
        return filters;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int getResultsCount(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter) {
        return this.repositoryService.getResourcesCount(context, searchCriteriaFactory, filters, sorter, this.transformerFactory);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResourceChildren(String type, String resourceUri) {
        ChildrenLoaderService childrenLoaderService = this.childrenLoaders.get(type);
        if (childrenLoaderService != null) {
            return this.getResourceDetailsList(childrenLoaderService.getChildren(resourceUri));
        }
        return Collections.emptyList();
    }

    private List<ResourceDetails> getResourceDetailsList(List<ResourceLookup> resources) {
        ArrayList<ResourceDetails> list = new ArrayList<ResourceDetails>();
        for (ResourceLookup resource : resources) {
            ResourceDetails resourceDetails = this.resourceService.getResourceDetails((Resource)resource);
            list.add(resourceDetails);
        }
        return list;
    }

    public void setChildrenLoaders(Map<String, ChildrenLoaderService> childrenLoaders) {
        this.childrenLoaders = childrenLoaders;
    }
}

