/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.domain;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JasperServerAPI;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.jaxb.OutputFormatXmlAdapter;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.jaxb.TimestampToDateXmlAdapter;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;

@JasperServerAPI
@XmlRootElement(name="job")
public class ReportJob
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int VERSION_NEW = -1;
    public static final byte OUTPUT_FORMAT_PDF = 1;
    public static final byte OUTPUT_FORMAT_HTML = 2;
    public static final byte OUTPUT_FORMAT_XLS = 3;
    public static final byte OUTPUT_FORMAT_RTF = 4;
    public static final byte OUTPUT_FORMAT_CSV = 5;
    public static final byte OUTPUT_FORMAT_ODT = 6;
    public static final byte OUTPUT_FORMAT_TXT = 7;
    public static final byte OUTPUT_FORMAT_DOCX = 8;
    public static final byte OUTPUT_FORMAT_ODS = 9;
    public static final byte OUTPUT_FORMAT_XLSX = 10;
    public static final byte OUTPUT_FORMAT_XLS_NOPAG = 11;
    public static final byte OUTPUT_FORMAT_XLSX_NOPAG = 12;
    public static final byte OUTPUT_FORMAT_DATA_SNAPSHOT = 100;
    private long id;
    private int version = -1;
    private String username;
    private String label;
    private String description;
    private Timestamp creationDate;
    private ReportJobTrigger trigger;
    private ReportJobSource source;
    private String baseOutputFilename;
    private Set<Byte> outputFormats;
    private String outputLocale;
    private ReportJobRepositoryDestination contentRepositoryDestination;
    private ReportJobMailNotification mailNotification;
    private ReportJobAlert alert;

    public ReportJob() {
        this.outputFormats = new HashSet<Byte>();
        this.creationDate = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public ReportJobSource getSource() {
        return this.source;
    }

    public void setSource(ReportJobSource source) {
        this.source = source;
    }

    @XmlElements(value={@XmlElement(name="simpleTrigger", type=ReportJobSimpleTrigger.class), @XmlElement(name="calendarTrigger", type=ReportJobCalendarTrigger.class)})
    public ReportJobTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(ReportJobTrigger trigger) {
        this.trigger = trigger;
    }

    public ReportJobMailNotification getMailNotification() {
        return this.mailNotification;
    }

    public void setMailNotification(ReportJobMailNotification mailNotification) {
        if (this.contentRepositoryDestination != null && !this.contentRepositoryDestination.isSaveToRepository() && mailNotification != null) {
            if (mailNotification.getResultSendTypeCode() == 1) {
                throw new JSException("Cannot send mail notifications contain links of the job output in repository when saving to repository function is disabled.");
            }
        }
        this.mailNotification = mailNotification;
    }

    @XmlElement(name="repositoryDestination")
    public ReportJobRepositoryDestination getContentRepositoryDestination() {
        return this.contentRepositoryDestination;
    }

    public void setContentRepositoryDestination(ReportJobRepositoryDestination contentRepositoryDestination) {
        if (contentRepositoryDestination != null && !contentRepositoryDestination.isSaveToRepository() && this.mailNotification != null) {
            if (this.mailNotification.getResultSendTypeCode() == 1) {
                throw new JSException("Cannot send mail notifications contain links of the job output in repository when saving to repository function is disabled.");
            }
        }
        this.contentRepositoryDestination = contentRepositoryDestination;
    }

    public ReportJobAlert getAlert() {
        return this.alert;
    }

    public void setAlert(ReportJobAlert alert) {
        this.alert = alert;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlJavaTypeAdapter(value=TimestampToDateXmlAdapter.class)
    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getBaseOutputFilename() {
        return this.baseOutputFilename;
    }

    public void setBaseOutputFilename(String baseOutputFilename) {
        this.baseOutputFilename = baseOutputFilename;
    }

    @XmlTransient
    public Set getOutputFormats() {
        return this.getOutputFormatsSet();
    }

    @XmlElement(name="outputFormats")
    @XmlJavaTypeAdapter(value=OutputFormatXmlAdapter.class)
    public Set<Byte> getOutputFormatsSet() {
        return this.outputFormats;
    }

    public void setOutputFormats(Set outputFormats) {
        this.setOutputFormatsSet(outputFormats);
    }

    public void setOutputFormatsSet(Set<Byte> outputFormats) {
        this.outputFormats = outputFormats;
    }

    public boolean addOutputFormat(byte outputFormat) {
        return this.outputFormats.add(outputFormat);
    }

    public boolean removeOutputFormat(byte outputFormat) {
        return this.outputFormats.remove(new Byte(outputFormat));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOutputLocale() {
        return this.outputLocale;
    }

    public void setOutputLocale(String outputLocale) {
        this.outputLocale = outputLocale;
    }

    public boolean equals(ReportJob rj) {
        return this.label.equals(rj.getLabel()) && this.username.equals(rj.getUsername()) && this.baseOutputFilename.equals(rj.getBaseOutputFilename()) && this.trigger.equals(rj.getTrigger());
    }

    public String getOutputTimeZone() {
        Map<String, Object> parameters;
        ReportJobSource jobSource = this.getSource();
        if (jobSource != null && (parameters = jobSource.getParameters()) != null) {
            TimeZone tz = (TimeZone)parameters.get("REPORT_TIME_ZONE");
            return tz != null ? tz.getID() : null;
        }
        return null;
    }

    public void setOutputTimeZone(String timeZoneID) {
        ReportJobSource jobSource = this.getSource();
        if (jobSource != null && !StringUtils.isEmpty((String)timeZoneID)) {
            Map<String, Object> parameters = jobSource.getParameters();
            if (parameters == null) {
                parameters = new HashMap<String, Object>();
                jobSource.setParameters(parameters);
            }
            parameters.put("REPORT_TIME_ZONE", TimeZone.getTimeZone(timeZoneID));
        }
    }

    public void setReportParameters(Map<String, Object> values) {
        ReportJobSource jobSource = this.getSource();
        if (jobSource != null) {
            Map<String, Object> parameters = jobSource.getParameters();
            if (parameters != null) {
                parameters.putAll(values);
            } else {
                jobSource.setParameters(values);
            }
        }
    }

    public ReportJob(ReportJob job) {
        this.setVersion(-1);
        this.setSource(new ReportJobSource(job.getSource()));
        ReportJobTrigger trigger = job.getTrigger();
        if (trigger != null) {
            if (trigger instanceof ReportJobCalendarTrigger) {
                this.setTrigger(new ReportJobCalendarTrigger((ReportJobCalendarTrigger)trigger));
            } else if (trigger instanceof ReportJobSimpleTrigger) {
                this.setTrigger(new ReportJobSimpleTrigger((ReportJobSimpleTrigger)trigger));
            } else {
                throw new JSException("ERROR !  Unhandled Trigger type '" + trigger.getClass().getName() + "'");
            }
        }
        if (job.getMailNotification() != null) {
            this.setMailNotification(new ReportJobMailNotification(job.getMailNotification()));
        } else {
            this.setMailNotification(null);
        }
        this.setContentRepositoryDestination(new ReportJobRepositoryDestination(job.getContentRepositoryDestination()));
        this.setDescription(job.getDescription());
        this.setCreationDate(job.getCreationDate());
        this.setLabel(job.getLabel());
        this.setBaseOutputFilename(job.getBaseOutputFilename());
        this.setOutputFormats(new HashSet(job.getOutputFormats()));
        this.setOutputFormatsSet(new HashSet<Byte>(job.getOutputFormatsSet()));
        this.setUsername(job.getUsername());
        this.setOutputLocale(job.getOutputLocale());
    }
}

