/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class VirtualDataSourceBean
extends ResourceBean {
    private String timezone;
    private Map<String, ResourceReferenceBean> dataSourceUriMap = new HashMap<String, ResourceReferenceBean>();

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
        VirtualReportDataSource ds = (VirtualReportDataSource)res;
        this.copyDataSourcesFrom(ds, referenceHandler);
        this.setTimezone(ds.getTimezone());
    }

    protected void copyDataSourcesFrom(VirtualReportDataSource ds, ResourceExportHandler exportHandler) {
        Map dsSources = ds.getDataSourceUriMap();
        if (dsSources == null || dsSources.isEmpty()) {
            this.dataSourceUriMap = null;
        } else {
            this.dataSourceUriMap = new LinkedHashMap<String, ResourceReferenceBean>();
            for (Map.Entry entry : dsSources.entrySet()) {
                String alias = (String)entry.getKey();
                ResourceReference ref = (ResourceReference)entry.getValue();
                ResourceReferenceBean refBean = exportHandler.handleReference(ref);
                this.dataSourceUriMap.put(alias, refBean);
            }
        }
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        VirtualReportDataSource ds = (VirtualReportDataSource)res;
        this.copyDataSourcesTo(ds, importHandler);
        ds.setTimezone(this.getTimezone());
    }

    protected void copyDataSourcesTo(VirtualReportDataSource ds, ResourceImportHandler importHandler) {
        LinkedHashMap<String, ResourceReference> dsSources = new LinkedHashMap<String, ResourceReference>();
        if (this.dataSourceUriMap != null && !this.dataSourceUriMap.isEmpty()) {
            for (Map.Entry<String, ResourceReferenceBean> entry : this.dataSourceUriMap.entrySet()) {
                String alias = entry.getKey();
                ResourceReferenceBean refBean = entry.getValue();
                ResourceReference ref = importHandler.handleReference(refBean);
                dsSources.put(alias, ref);
            }
        }
        ds.setDataSourceUriMap(dsSources);
    }

    public Map<String, ResourceReferenceBean> getDataSourceUriMap() {
        return this.dataSourceUriMap;
    }

    public void setDataSourceUriMap(Map<String, ResourceReferenceBean> dataSourceUriMap) {
        this.dataSourceUriMap = dataSourceUriMap;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }
}

