/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.io.ExportOutput;
import com.jaspersoft.jasperserver.export.io.ObjectSerializer;
import com.jaspersoft.jasperserver.export.modules.ExporterModule;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public abstract class BaseExporterModule
implements ExporterModule {
    private static final Log log = LogFactory.getLog(BaseExporterModule.class);
    protected static final CommandOut commandOut = CommandOut.getInstance();
    private String id;
    private String everythingArg;
    protected ExporterModuleContext exportContext;
    protected Parameters exportParams;
    protected String characterEncoding;
    protected ExportOutput output;
    protected ExecutionContext executionContext;
    protected boolean exportEverything;

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void init(ExporterModuleContext moduleContext) {
        this.exportContext = moduleContext;
        this.exportParams = moduleContext.getExportTask().getParameters();
        this.characterEncoding = moduleContext.getCharacterEncoding();
        this.output = moduleContext.getExportTask().getOutput();
        this.executionContext = moduleContext.getExportTask().getExecutionContext();
        this.exportEverything = this.isExportEverything();
    }

    protected boolean isExportEverything() {
        return this.exportParams.hasParameter(this.everythingArg);
    }

    @Override
    public boolean toProcess() {
        return this.exportEverything || this.isToProcess();
    }

    protected abstract boolean isToProcess();

    protected boolean hasParameter(String name) {
        return this.exportParams.hasParameter(name);
    }

    protected String getParameterValue(String name) {
        return this.exportParams.getParameterValue(name);
    }

    protected String[] getParameterValues(String name) {
        return this.exportParams.getParameterValues(name);
    }

    protected Element getIndexElement() {
        return this.exportContext.getModuleIndexElement();
    }

    protected final void serialize(Object object, String parentPath, String fileName, ObjectSerializer serializer) {
        OutputStream out = this.getFileOutput(parentPath, fileName);
        boolean closeOut = true;
        try {
            serializer.write(object, out, this.exportContext);
            closeOut = false;
            out.close();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected final OutputStream getFileOutput(String parentPath, String fileName) {
        try {
            return this.output.getFileOutputStream(parentPath, fileName);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected final void writeData(InputStream input, String parentPath, String fileName) {
        OutputStream out = this.getFileOutput(parentPath, fileName);
        boolean closeOut = true;
        try {
            DataContainerStreamUtil.pipeData((InputStream)input, (OutputStream)out);
            closeOut = false;
            out.close();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected final void mkdir(String path) {
        try {
            this.output.mkdir(path);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected final String mkdir(String parentPath, String path) {
        try {
            return this.output.mkdir(parentPath, path);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public String getEverythingArg() {
        return this.everythingArg;
    }

    public void setEverythingArg(String everythingArg) {
        this.everythingArg = everythingArg;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }
}

