/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.io.BaseExportOutput;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemOutput
extends BaseExportOutput {
    private static final Log log = LogFactory.getLog(FileSystemOutput.class);
    private static final CommandOut commandOut = CommandOut.getInstance();
    private final String rootDirName;
    private final PathProcessor pathProcessor;
    private File rootDir;

    public FileSystemOutput(String rootDir, PathProcessor pathProcessor, Properties outputProperties) {
        super(outputProperties);
        this.rootDirName = rootDir;
        this.pathProcessor = pathProcessor;
    }

    public String getRootDirName() {
        return this.rootDirName;
    }

    @Override
    public void open() {
        this.rootDir = new File(this.getRootDirName());
        commandOut.debug("Creating directory " + this.rootDir.getAbsolutePath() + "");
        this.rootDir.mkdirs();
    }

    @Override
    public void close() {
    }

    @Override
    public void mkdir(String path) {
        File dir = this.getFile(path);
        dir.mkdirs();
    }

    protected File getFile(String path) {
        String filePath = this.pathProcessor.processPath(path);
        File dir = new File(this.rootDir, filePath);
        return dir;
    }

    @Override
    public OutputStream getFileOutputStream(String path) {
        try {
            File file = this.getFile(path);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            return out;
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }
}

