/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.sso;

import com.jaspersoft.jasperserver.api.security.externalAuth.BaseAuthenticationProcessingFilter;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalAuthProperties;
import com.jaspersoft.jasperserver.api.security.externalAuth.sso.SsoAuthenticationToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;

public abstract class AbstractSsoAuthenticationProcessingFilter
extends BaseAuthenticationProcessingFilter {
    private static final Logger logger = LogManager.getLogger(AbstractSsoAuthenticationProcessingFilter.class);
    private ExternalAuthProperties externalAuthProperties;

    public final Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        try {
            logger.debug((Object)"Attempt authentication with SSO token ...");
            Object ticket = this.obtainTicket(request);
            logger.debug((Object)("SSO Token: " + ticket));
            String userName = this.obtainUsername(request);
            userName = userName != null ? URLDecoder.decode(userName, "UTF-8") : null;
            String password = this.obtainPassword(request);
            SsoAuthenticationToken authToken = new SsoAuthenticationToken(ticket, userName, password);
            this.setDetails(request, authToken);
            return this.getAuthenticationManager().authenticate((Authentication)authToken);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("could not decode user name " + this.obtainUsername(request)));
            throw new IllegalStateException(e);
        }
    }

    protected abstract Object obtainTicket(HttpServletRequest var1);

    public ExternalAuthProperties getExternalAuthProperties() {
        return this.externalAuthProperties;
    }

    public void setExternalAuthProperties(ExternalAuthProperties externalAuthProperties) {
        this.externalAuthProperties = externalAuthProperties;
    }
}

