/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.SecurityConfig;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.providers.rememberme.RememberMeAuthenticationToken;
import org.springframework.security.vote.AuthenticatedVoter;

public class AuthenticatedVoterTests
extends TestCase {
    public AuthenticatedVoterTests() {
    }

    public AuthenticatedVoterTests(String arg0) {
        super(arg0);
    }

    private Authentication createAnonymous() {
        return new AnonymousAuthenticationToken("ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")});
    }

    private Authentication createFullyAuthenticated() {
        return new UsernamePasswordAuthenticationToken((Object)"ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")});
    }

    private Authentication createRememberMe() {
        return new RememberMeAuthenticationToken("ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")});
    }

    public static void main(String[] args) {
        TestRunner.run(AuthenticatedVoterTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAnonymousWorks() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("IS_AUTHENTICATED_ANONYMOUSLY");
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createAnonymous(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createRememberMe(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createFullyAuthenticated(), null, def));
    }

    public void testFullyWorks() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("IS_AUTHENTICATED_FULLY");
        AuthenticatedVoterTests.assertEquals((int)-1, (int)voter.vote(this.createAnonymous(), null, def));
        AuthenticatedVoterTests.assertEquals((int)-1, (int)voter.vote(this.createRememberMe(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createFullyAuthenticated(), null, def));
    }

    public void testRememberMeWorks() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("IS_AUTHENTICATED_REMEMBERED");
        AuthenticatedVoterTests.assertEquals((int)-1, (int)voter.vote(this.createAnonymous(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createRememberMe(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createFullyAuthenticated(), null, def));
    }

    public void testSetterRejectsNull() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        try {
            voter.setAuthenticationTrustResolver(null);
            AuthenticatedVoterTests.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException expected) {
            AuthenticatedVoterTests.assertTrue((boolean)true);
        }
    }

    public void testSupports() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports(String.class));
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_ANONYMOUSLY")));
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_FULLY")));
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_REMEMBERED")));
        AuthenticatedVoterTests.assertFalse((boolean)voter.supports((ConfigAttribute)new SecurityConfig("FOO")));
    }
}

