/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.AuthorityUtils;

public class AuthorityUtilsTests {
    @Before
    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void userHasAuthorityReturnsFalseForUnauthenticatedUser() {
        Assert.assertFalse((boolean)AuthorityUtils.userHasAuthority((String)"SOME_AUTHORITY"));
    }

    @Test
    public void userHasAuthorityReturnsFalseWhenUserHasNoAuthorities() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password"));
        Assert.assertFalse((boolean)AuthorityUtils.userHasAuthority((String)"SOME_AUTHORITY"));
    }

    @Test
    public void userHasAuthorityReturnsTrueWhenUserHasCorrectAuthority() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password", AuthorityUtils.stringArrayToAuthorityArray((String[])new String[]{"A", "B"})));
        Assert.assertTrue((boolean)AuthorityUtils.userHasAuthority((String)"A"));
        Assert.assertTrue((boolean)AuthorityUtils.userHasAuthority((String)"B"));
        Assert.assertFalse((boolean)AuthorityUtils.userHasAuthority((String)"C"));
    }

    @Test
    public void commaSeparatedStringIsParsedCorrectly() {
        GrantedAuthority[] authorityArray = AuthorityUtils.commaSeparatedStringToAuthorityArray((String)" ROLE_A, B, C, ROLE_D, E ");
        Set authorities = AuthorityUtils.authorityArrayToSet((GrantedAuthority[])authorityArray);
        Assert.assertTrue((boolean)authorities.contains("B"));
        Assert.assertTrue((boolean)authorities.contains("C"));
        Assert.assertTrue((boolean)authorities.contains("E"));
        Assert.assertTrue((boolean)authorities.contains("ROLE_A"));
        Assert.assertTrue((boolean)authorities.contains("ROLE_D"));
    }
}

