/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.switchuser;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.AccountExpiredException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.CredentialsExpiredException;
import org.springframework.security.DisabledException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.switchuser.SwitchUserAuthorityChanger;
import org.springframework.security.ui.switchuser.SwitchUserGrantedAuthority;
import org.springframework.security.ui.switchuser.SwitchUserProcessingFilter;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.util.MockFilterChain;

public class SwitchUserProcessingFilterTests {
    @Before
    public void authenticateCurrentUser() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
    }

    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    private MockHttpServletRequest createMockSwitchRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setRequestURI("/j_spring_security_switch_user");
        return request;
    }

    private Authentication switchToUser(String name) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", name);
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        return filter.attemptSwitchUser((HttpServletRequest)request);
    }

    @Test
    public void requiresExitUserMatchesCorrectly() {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setExitUserUrl("/j_spring_security_my_exit_user");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/j_spring_security_my_exit_user");
        Assert.assertTrue((boolean)filter.requiresExitUser((HttpServletRequest)request));
    }

    @Test
    public void requiresSwitchMatchesCorrectly() {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_spring_security_my_switch_user");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/j_spring_security_my_switch_user");
        Assert.assertTrue((boolean)filter.requiresSwitchUser((HttpServletRequest)request));
    }

    @Test(expected=UsernameNotFoundException.class)
    public void attemptSwitchToUnknownUserFails() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "user-that-doesnt-exist");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.attemptSwitchUser((HttpServletRequest)request);
    }

    @Test(expected=DisabledException.class)
    public void attemptSwitchToUserThatIsDisabledFails() throws Exception {
        this.switchToUser("mcgarrett");
    }

    @Test(expected=AccountExpiredException.class)
    public void attemptSwitchToUserWithAccountExpiredFails() throws Exception {
        this.switchToUser("wofat");
    }

    @Test(expected=CredentialsExpiredException.class)
    public void attemptSwitchToUserWithExpiredCredentialsFails() throws Exception {
        this.switchToUser("steve");
    }

    @Test(expected=UsernameNotFoundException.class)
    public void switchUserWithNullUsernameThrowsException() throws Exception {
        this.switchToUser(null);
    }

    @Test
    public void attemptSwitchUserIsSuccessfulWithValidUser() throws Exception {
        Assert.assertNotNull((Object)this.switchToUser("jacklord"));
    }

    @Test
    public void switchToLockedAccountCausesRedirectToSwitchFailureUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/j_spring_security_switch_user");
        request.addParameter("j_username", "mcgarrett");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.doFilterHttp((HttpServletRequest)request, (HttpServletResponse)response, (FilterChain)new MockFilterChain(false));
        Assert.assertEquals((Object)"Switch user failed: User is disabled", (Object)response.getContentAsString());
        request.setContextPath("/mywebapp");
        request.setRequestURI("/mywebapp/j_spring_security_switch_user");
        filter.setSwitchFailureUrl("/switchfailed");
        response = new MockHttpServletResponse();
        filter.doFilterHttp((HttpServletRequest)request, (HttpServletResponse)response, (FilterChain)new MockFilterChain(true));
        Assert.assertEquals((Object)"/mywebapp/switchfailed", (Object)response.getRedirectedUrl());
        Assert.assertEquals((Object)"/switchfailed", (Object)FieldUtils.getFieldValue((Object)filter, (String)"switchFailureUrl"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void configMissingUserDetailsServiceFails() throws Exception {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setExitUserUrl("/j_spring_security_exit_user");
        filter.setTargetUrl("/main.jsp");
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadConfigMissingTargetUrl() throws Exception {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setExitUserUrl("/j_spring_security_exit_user");
        filter.afterPropertiesSet();
    }

    @Test
    public void defaultProcessesFilterUrlMatchesUrlWithPathParameter() {
        MockHttpServletRequest request = this.createMockSwitchRequest();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        request.setRequestURI("/webapp/j_spring_security_switch_user;jsessionid=8JHDUD723J8");
        Assert.assertTrue((boolean)filter.requiresSwitchUser((HttpServletRequest)request));
    }

    @Test
    public void exitUserJackLordToDanoSucceeds() throws Exception {
        GrantedAuthority[] auths = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")};
        UsernamePasswordAuthenticationToken source = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50", auths);
        GrantedAuthority[] adminAuths = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO"), new SwitchUserGrantedAuthority("PREVIOUS_ADMINISTRATOR", (Authentication)source)};
        UsernamePasswordAuthenticationToken admin = new UsernamePasswordAuthenticationToken((Object)"jacklord", (Object)"hawaii50", adminAuths);
        SecurityContextHolder.getContext().setAuthentication((Authentication)admin);
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setRequestURI("/j_spring_security_exit_user");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setExitUserUrl("/j_spring_security_exit_user");
        filter.setTargetUrl("/webapp/someOtherUrl");
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(false));
        Authentication targetAuth = SecurityContextHolder.getContext().getAuthentication();
        Assert.assertNotNull((Object)targetAuth);
        Assert.assertEquals((Object)"dano", (Object)targetAuth.getPrincipal());
    }

    @Test(expected=AuthenticationException.class)
    public void exitUserWithNoCurrentUserFails() throws Exception {
        SecurityContextHolder.clearContext();
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setRequestURI("/j_spring_security_exit_user");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setExitUserUrl("/j_spring_security_exit_user");
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(false));
    }

    @Test
    public void redirectToTargetUrlIsCorrect() throws Exception {
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setContextPath("/webapp");
        request.addParameter("j_username", "jacklord");
        request.setRequestURI("/webapp/j_spring_security_switch_user");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setTargetUrl("/someOtherUrl");
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain(false));
        Assert.assertEquals((Object)"/webapp/someOtherUrl", (Object)response.getRedirectedUrl());
    }

    @Test
    public void redirectOmitsContextPathIfUseRelativeContextSet() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setContextPath("/webapp");
        request.addParameter("j_username", "jacklord");
        request.setRequestURI("/webapp/j_spring_security_switch_user");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setTargetUrl("/someOtherUrl");
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setUseRelativeContext(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain(false));
        Assert.assertEquals((Object)"/someOtherUrl", (Object)response.getRedirectedUrl());
    }

    @Test
    public void testSwitchRequestFromDanoToJackLord() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/webapp/j_spring_security_switch_user");
        request.addParameter("j_username", "jacklord");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setTargetUrl("/webapp/someOtherUrl");
        MockFilterChain chain = new MockFilterChain(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Authentication targetAuth = SecurityContextHolder.getContext().getAuthentication();
        Assert.assertNotNull((Object)targetAuth);
        Assert.assertTrue((boolean)(targetAuth.getPrincipal() instanceof UserDetails));
        Assert.assertEquals((Object)"jacklord", (Object)((User)targetAuth.getPrincipal()).getUsername());
    }

    @Test
    public void modificationOfAuthoritiesWorks() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "jacklord");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setSwitchUserAuthorityChanger(new SwitchUserAuthorityChanger(){

            public List modifyGrantedAuthorities(UserDetails targetUser, Authentication currentAuthentication, List authoritiesToBeGranted) {
                ArrayList<GrantedAuthorityImpl> auths = new ArrayList<GrantedAuthorityImpl>();
                auths.add(new GrantedAuthorityImpl("ROLE_NEW"));
                return auths;
            }
        });
        Authentication result = filter.attemptSwitchUser((HttpServletRequest)request);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)result.getAuthorities().length);
        Assert.assertEquals((Object)"ROLE_NEW", (Object)result.getAuthorities()[0].getAuthority());
    }

    private class MockUserDetailsService
    implements UserDetailsService {
        private String password = "hawaii50";

        private MockUserDetailsService() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            if ("jacklord".equals(username) || "dano".equals(username)) {
                return new User(username, this.password, true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            if ("mcgarrett".equals(username)) {
                return new User(username, this.password, false, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            if ("wofat".equals(username)) {
                return new User(username, this.password, true, false, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            if ("steve".equals(username)) {
                return new User(username, this.password, true, true, false, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

