/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ITargetObject;
import org.springframework.security.OtherTargetObject;
import org.springframework.security.intercept.AbstractSecurityInterceptor;
import org.springframework.security.intercept.method.MethodInvocationPrivilegeEvaluator;
import org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.MethodInvocationUtils;

public class MethodInvocationPrivilegeEvaluatorTests
extends TestCase {
    public MethodInvocationPrivilegeEvaluatorTests() {
    }

    public MethodInvocationPrivilegeEvaluatorTests(String arg0) {
        super(arg0);
    }

    private Object lookupTargetObject() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/springframework/security/intercept/method/aopalliance/applicationContext.xml");
        return context.getBean("target");
    }

    public static void main(String[] args) {
        TestRunner.run(MethodInvocationPrivilegeEvaluatorTests.class);
    }

    private MethodSecurityInterceptor makeSecurityInterceptor() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/springframework/security/intercept/method/aopalliance/applicationContext.xml");
        return (MethodSecurityInterceptor)context.getBean("securityInterceptor");
    }

    public void testAllowsAccessUsingCreate() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_LOWER")});
        Object object = this.lookupTargetObject();
        MethodInvocation mi = MethodInvocationUtils.create((Object)object, (String)"makeLowerCase", (Object[])new Object[]{"foobar"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertTrue((boolean)mipe.isAllowed(mi, (Authentication)token));
    }

    public void testAllowsAccessUsingCreateFromClass() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_LOWER")});
        MethodInvocation mi = MethodInvocationUtils.createFromClass((Object)new OtherTargetObject(), ITargetObject.class, (String)"makeLowerCase", (Class[])new Class[]{String.class}, (Object[])new Object[]{"Hello world"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertTrue((boolean)mipe.isAllowed(mi, (Authentication)token));
    }

    public void testDeclinesAccessUsingCreate() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_NOT_HELD")});
        Object object = this.lookupTargetObject();
        MethodInvocation mi = MethodInvocationUtils.create((Object)object, (String)"makeLowerCase", (Object[])new Object[]{"foobar"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertFalse((boolean)mipe.isAllowed(mi, (Authentication)token));
    }

    public void testDeclinesAccessUsingCreateFromClass() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_NOT_HELD")});
        MethodInvocation mi = MethodInvocationUtils.createFromClass((Object)new OtherTargetObject(), ITargetObject.class, (String)"makeLowerCase", (Class[])new Class[]{String.class}, (Object[])new Object[]{"helloWorld"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertFalse((boolean)mipe.isAllowed(mi, (Authentication)token));
    }
}

