/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationTrustResolverImpl;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.providers.rememberme.RememberMeAuthenticationToken;

public class AuthenticationTrustResolverImplTests
extends TestCase {
    public AuthenticationTrustResolverImplTests() {
    }

    public AuthenticationTrustResolverImplTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(AuthenticationTrustResolverImplTests.class);
    }

    public void testCorrectOperationIsAnonymous() {
        AuthenticationTrustResolverImpl trustResolver = new AuthenticationTrustResolverImpl();
        AuthenticationTrustResolverImplTests.assertTrue((boolean)trustResolver.isAnonymous((Authentication)new AnonymousAuthenticationToken("ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")})));
        AuthenticationTrustResolverImplTests.assertFalse((boolean)trustResolver.isAnonymous((Authentication)new TestingAuthenticationToken((Object)"ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")})));
    }

    public void testCorrectOperationIsRememberMe() {
        AuthenticationTrustResolverImpl trustResolver = new AuthenticationTrustResolverImpl();
        AuthenticationTrustResolverImplTests.assertTrue((boolean)trustResolver.isRememberMe((Authentication)new RememberMeAuthenticationToken("ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")})));
        AuthenticationTrustResolverImplTests.assertFalse((boolean)trustResolver.isAnonymous((Authentication)new TestingAuthenticationToken((Object)"ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")})));
    }

    public void testGettersSetters() {
        AuthenticationTrustResolverImpl trustResolver = new AuthenticationTrustResolverImpl();
        AuthenticationTrustResolverImplTests.assertEquals(AnonymousAuthenticationToken.class, (Object)trustResolver.getAnonymousClass());
        trustResolver.setAnonymousClass(String.class);
        AuthenticationTrustResolverImplTests.assertEquals(String.class, (Object)trustResolver.getAnonymousClass());
        AuthenticationTrustResolverImplTests.assertEquals(RememberMeAuthenticationToken.class, (Object)trustResolver.getRememberMeClass());
        trustResolver.setRememberMeClass(String.class);
        AuthenticationTrustResolverImplTests.assertEquals(String.class, (Object)trustResolver.getRememberMeClass());
    }
}

