/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.ClasspathAccessRule;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.XMLWriter;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClasspathEntry
implements IClasspathEntry {
    public static final String TAG_CLASSPATH = "classpath";
    public static final String TAG_CLASSPATHENTRY = "classpathentry";
    public static final String TAG_OUTPUT = "output";
    public static final String TAG_KIND = "kind";
    public static final String TAG_PATH = "path";
    public static final String TAG_SOURCEPATH = "sourcepath";
    public static final String TAG_ROOTPATH = "rootpath";
    public static final String TAG_EXPORTED = "exported";
    public static final String TAG_INCLUDING = "including";
    public static final String TAG_EXCLUDING = "excluding";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_ATTRIBUTE_NAME = "name";
    public static final String TAG_ATTRIBUTE_VALUE = "value";
    public static final String TAG_COMBINE_ACCESS_RULES = "combineaccessrules";
    public static final String TAG_ACCESS_RULES = "accessrules";
    public static final String TAG_ACCESS_RULE = "accessrule";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_ACCESSIBLE = "accessible";
    public static final String TAG_NON_ACCESSIBLE = "nonaccessible";
    public static final String TAG_DISCOURAGED = "discouraged";
    public int entryKind;
    public int contentKind;
    public IPath path;
    private IPath[] inclusionPatterns;
    private char[][] fullInclusionPatternChars;
    private IPath[] exclusionPatterns;
    private char[][] fullExclusionPatternChars;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private boolean combineAccessRules;
    private String rootID;
    private AccessRuleSet accessRuleSet;
    public static final IPath[] INCLUDE_ALL = new IPath[0];
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    public static final IClasspathAttribute[] NO_EXTRA_ATTRIBUTES = new IClasspathAttribute[0];
    public static final IAccessRule[] NO_ACCESS_RULES = new IAccessRule[0];
    public IPath sourceAttachmentPath;
    public IPath sourceAttachmentRootPath;
    public IPath specificOutputLocation;
    public static final int K_OUTPUT = 10;
    public boolean isExported;
    IClasspathAttribute[] extraAttributes;

    public ClasspathEntry(int contentKind, int entryKind, IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath specificOutputLocation, boolean isExported, IAccessRule[] accessRules, boolean combineAccessRules, IClasspathAttribute[] extraAttributes) {
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        AccessRuleSet ruleSet = ClasspathEntry.createAccessRuleSet(accessRules);
        if (ruleSet != null) {
            ruleSet.messageTemplate = this.getMessageTemplate();
        }
        this.accessRuleSet = ruleSet;
        this.combineAccessRules = combineAccessRules;
        this.extraAttributes = extraAttributes;
        if (inclusionPatterns != INCLUDE_ALL && inclusionPatterns.length > 0) {
            this.fullInclusionPatternChars = UNINIT_PATTERNS;
        }
        if (exclusionPatterns.length > 0) {
            this.fullExclusionPatternChars = UNINIT_PATTERNS;
        }
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.specificOutputLocation = specificOutputLocation;
        this.isExported = isExported;
    }

    private static AccessRuleSet createAccessRuleSet(IAccessRule[] accessRules) {
        int length;
        int n = length = accessRules == null ? 0 : accessRules.length;
        if (length == 0) {
            return null;
        }
        AccessRule[] rules = new AccessRule[length];
        System.arraycopy(accessRules, 0, rules, 0, length);
        return new AccessRuleSet(rules);
    }

    public boolean combineAccessRules() {
        return this.combineAccessRules;
    }

    public ClasspathEntry combineWith(ClasspathEntry referringEntry) {
        if (referringEntry == null) {
            return this;
        }
        if (referringEntry.isExported() || referringEntry.getAccessRuleSet() != null) {
            boolean combine = this.entryKind == 3 || referringEntry.combineAccessRules();
            return new ClasspathEntry(this.getContentKind(), this.getEntryKind(), this.getPath(), this.inclusionPatterns, this.exclusionPatterns, this.getSourceAttachmentPath(), this.getSourceAttachmentRootPath(), this.getOutputLocation(), referringEntry.isExported() || this.isExported, this.combine(referringEntry.getAccessRules(), this.getAccessRules(), combine), this.combineAccessRules, this.extraAttributes);
        }
        return this;
    }

    private IAccessRule[] combine(IAccessRule[] referringRules, IAccessRule[] rules, boolean combine) {
        if (!combine) {
            return rules;
        }
        if (rules == null || rules.length == 0) {
            return referringRules;
        }
        int referringRulesLength = referringRules.length;
        int accessRulesLength = rules.length;
        int rulesLength = referringRulesLength + accessRulesLength;
        IAccessRule[] result = new IAccessRule[rulesLength];
        System.arraycopy(referringRules, 0, result, 0, referringRulesLength);
        System.arraycopy(rules, 0, result, referringRulesLength, accessRulesLength);
        return result;
    }

    static IClasspathAttribute[] decodeExtraAttributes(Element element) {
        Node extra = element.getElementsByTagName(TAG_ATTRIBUTES).item(0);
        if (extra == null) {
            return NO_EXTRA_ATTRIBUTES;
        }
        NodeList attributes = element.getElementsByTagName(TAG_ATTRIBUTE);
        if (attributes == null) {
            return NO_EXTRA_ATTRIBUTES;
        }
        int length = attributes.getLength();
        if (length == 0) {
            return NO_EXTRA_ATTRIBUTES;
        }
        IClasspathAttribute[] result = new IClasspathAttribute[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            String value;
            Element attribute;
            String name;
            Node node = attributes.item(i);
            if (node.getNodeType() == 1 && (name = (attribute = (Element)node).getAttribute(TAG_ATTRIBUTE_NAME)) != null && (value = attribute.getAttribute(TAG_ATTRIBUTE_VALUE)) != null) {
                result[index++] = new ClasspathAttribute(name, value);
            }
            ++i;
        }
        if (index != length) {
            IClasspathAttribute[] iClasspathAttributeArray = result;
            result = new IClasspathAttribute[index];
            System.arraycopy(iClasspathAttributeArray, 0, result, 0, index);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    static IAccessRule[] decodeAccessRules(Element element) {
        Node accessRules = element.getElementsByTagName(TAG_ACCESS_RULES).item(0);
        if (accessRules == null || accessRules.getNodeType() != 1) {
            return null;
        }
        NodeList list = ((Element)accessRules).getElementsByTagName(TAG_ACCESS_RULE);
        int length = list.getLength();
        if (length == 0) {
            return null;
        }
        IAccessRule[] result = new IAccessRule[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            block8: {
                void var11_11;
                String pattern;
                block10: {
                    int kind;
                    String tagKind;
                    block11: {
                        block9: {
                            Node accessRule = list.item(i);
                            if (accessRule == null || accessRule.getNodeType() != 1) {
                                return null;
                            }
                            Element elementAccessRule = (Element)accessRule;
                            pattern = elementAccessRule.getAttribute(TAG_PATTERN);
                            if (pattern == null) break block8;
                            tagKind = elementAccessRule.getAttribute(TAG_KIND);
                            if (!TAG_ACCESSIBLE.equals(tagKind)) break block9;
                            kind = 0;
                            break block10;
                        }
                        if (!TAG_NON_ACCESSIBLE.equals(tagKind)) break block11;
                        kind = 1;
                        break block10;
                    }
                    if (!TAG_DISCOURAGED.equals(tagKind)) break block8;
                    kind = 2;
                }
                result[index++] = new ClasspathAccessRule((IPath)new Path(pattern), (int)var11_11);
            }
            ++i;
        }
        if (index != length) {
            IAccessRule[] iAccessRuleArray = result;
            result = new IAccessRule[index];
            System.arraycopy(iAccessRuleArray, 0, result, 0, index);
        }
        return result;
    }

    private static IPath[] decodePatterns(Element element, String tag) {
        char[][] patterns;
        int patternCount;
        String sequence = element.getAttribute(tag);
        if (!sequence.equals("") && (patternCount = (patterns = CharOperation.splitOn('|', sequence.toCharArray())).length) > 0) {
            IPath[] paths = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                paths[j] = new Path(new String(patterns[j]));
                ++j;
            }
            return paths;
        }
        return null;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullExclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullExclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullExclusionPatternChars[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullExclusionPatternChars;
    }

    public char[][] fullInclusionPatternChars() {
        if (this.fullInclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.inclusionPatterns.length;
            this.fullInclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullInclusionPatternChars[i] = prefixPath.append(this.inclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullInclusionPatternChars;
    }

    public void elementEncode(XMLWriter writer, IPath projectPath, boolean indent, boolean newLine) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TAG_KIND, ClasspathEntry.kindToString(this.entryKind));
        IPath xmlPath = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
            if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            } else {
                xmlPath = xmlPath.makeAbsolute();
            }
        }
        parameters.put(TAG_PATH, String.valueOf(xmlPath));
        if (this.sourceAttachmentPath != null) {
            xmlPath = this.sourceAttachmentPath;
            if (this.entryKind != 4 && projectPath != null && projectPath.isPrefixOf(xmlPath) && xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            }
            parameters.put(TAG_SOURCEPATH, String.valueOf(xmlPath));
        }
        if (this.sourceAttachmentRootPath != null) {
            parameters.put(TAG_ROOTPATH, String.valueOf(this.sourceAttachmentRootPath));
        }
        if (this.isExported) {
            parameters.put(TAG_EXPORTED, "true");
        }
        ClasspathEntry.encodePatterns(this.inclusionPatterns, TAG_INCLUDING, parameters);
        ClasspathEntry.encodePatterns(this.exclusionPatterns, TAG_EXCLUDING, parameters);
        if (this.entryKind == 2 && !this.combineAccessRules) {
            parameters.put(TAG_COMBINE_ACCESS_RULES, "false");
        }
        if (this.specificOutputLocation != null) {
            IPath outputLocation = this.specificOutputLocation.removeFirstSegments(1);
            outputLocation = outputLocation.makeRelative();
            parameters.put(TAG_OUTPUT, String.valueOf(outputLocation));
        }
        boolean hasExtraAttributes = this.extraAttributes.length != 0;
        boolean hasRestrictions = this.getAccessRuleSet() != null;
        writer.printTag(TAG_CLASSPATHENTRY, parameters, indent, newLine, !hasExtraAttributes && !hasRestrictions);
        if (hasExtraAttributes) {
            this.encodeExtraAttributes(writer, indent, newLine);
        }
        if (hasRestrictions) {
            this.encodeAccessRules(writer, indent, newLine);
        }
        if (hasExtraAttributes || hasRestrictions) {
            writer.endTag(TAG_CLASSPATHENTRY, indent);
        }
    }

    void encodeExtraAttributes(XMLWriter writer, boolean indent, boolean newLine) {
        writer.startTag(TAG_ATTRIBUTES, indent);
        int i = 0;
        while (i < this.extraAttributes.length) {
            IClasspathAttribute attribute = this.extraAttributes[i];
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(TAG_ATTRIBUTE_NAME, attribute.getName());
            parameters.put(TAG_ATTRIBUTE_VALUE, attribute.getValue());
            writer.printTag(TAG_ATTRIBUTE, parameters, indent, newLine, true);
            ++i;
        }
        writer.endTag(TAG_ATTRIBUTES, indent);
    }

    void encodeAccessRules(XMLWriter writer, boolean indent, boolean newLine) {
        writer.startTag(TAG_ACCESS_RULES, indent);
        AccessRule[] rules = this.getAccessRuleSet().getAccessRules();
        int i = 0;
        int length = rules.length;
        while (i < length) {
            this.encodeAccessRule(rules[i], writer, indent, newLine);
            ++i;
        }
        writer.endTag(TAG_ACCESS_RULES, indent);
    }

    private void encodeAccessRule(AccessRule accessRule, XMLWriter writer, boolean indent, boolean newLine) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TAG_PATTERN, new String(accessRule.pattern));
        switch (accessRule.problemId) {
            case 0x1000133: {
                parameters.put(TAG_KIND, TAG_NON_ACCESSIBLE);
                break;
            }
            case 0x1000118: {
                parameters.put(TAG_KIND, TAG_DISCOURAGED);
                break;
            }
            default: {
                parameters.put(TAG_KIND, TAG_ACCESSIBLE);
            }
        }
        writer.printTag(TAG_ACCESS_RULE, parameters, indent, newLine, true);
    }

    public static IClasspathEntry elementDecode(Element element, IJavaProject project) {
        IAccessRule[] accessRules;
        IPath[] exclusionPatterns;
        Path sourceAttachmentPath;
        IPath projectPath = project.getProject().getFullPath();
        String kindAttr = element.getAttribute(TAG_KIND);
        String pathAttr = element.getAttribute(TAG_PATH);
        Path path = new Path(pathAttr);
        int kind = ClasspathEntry.kindFromString(kindAttr);
        if (kind != 4 && kind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path path2 = sourceAttachmentPath = element.hasAttribute(TAG_SOURCEPATH) ? new Path(element.getAttribute(TAG_SOURCEPATH)) : null;
        if (kind != 4 && sourceAttachmentPath != null && !sourceAttachmentPath.isAbsolute()) {
            sourceAttachmentPath = projectPath.append((IPath)sourceAttachmentPath);
        }
        Path sourceAttachmentRootPath = element.hasAttribute(TAG_ROOTPATH) ? new Path(element.getAttribute(TAG_ROOTPATH)) : null;
        boolean isExported = element.getAttribute(TAG_EXPORTED).equals("true");
        IPath[] inclusionPatterns = ClasspathEntry.decodePatterns(element, TAG_INCLUDING);
        if (inclusionPatterns == null) {
            inclusionPatterns = INCLUDE_ALL;
        }
        if ((exclusionPatterns = ClasspathEntry.decodePatterns(element, TAG_EXCLUDING)) == null) {
            exclusionPatterns = EXCLUDE_NONE;
        }
        if ((accessRules = ClasspathEntry.decodeAccessRules(element)) == null) {
            accessRules = ClasspathEntry.getAccessRules(inclusionPatterns, exclusionPatterns);
        }
        boolean combineAccessRestrictions = !element.getAttribute(TAG_COMBINE_ACCESS_RULES).equals("false");
        IClasspathAttribute[] extraAttributes = ClasspathEntry.decodeExtraAttributes(element);
        IPath outputLocation = element.hasAttribute(TAG_OUTPUT) ? projectPath.append(element.getAttribute(TAG_OUTPUT)) : null;
        IClasspathEntry entry = null;
        switch (kind) {
            case 2: {
                entry = JavaCore.newProjectEntry((IPath)path, accessRules, combineAccessRestrictions, extraAttributes, isExported);
                break;
            }
            case 1: {
                entry = JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, accessRules, extraAttributes, isExported);
                break;
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getElementName())) {
                    return JavaCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, outputLocation, extraAttributes);
                }
                if (path.segmentCount() == 1) {
                    entry = JavaCore.newProjectEntry((IPath)path, accessRules, combineAccessRestrictions, extraAttributes, isExported);
                    break;
                }
                return JavaCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, outputLocation, extraAttributes);
            }
            case 4: {
                entry = JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, accessRules, extraAttributes, isExported);
                break;
            }
            case 5: {
                entry = JavaCore.newContainerEntry((IPath)path, accessRules, extraAttributes, isExported);
                break;
            }
            case 10: {
                if (!path.isAbsolute()) {
                    return null;
                }
                return new ClasspathEntry(10, 1, (IPath)path, INCLUDE_ALL, EXCLUDE_NONE, null, null, null, false, null, false, NO_EXTRA_ATTRIBUTES);
            }
            default: {
                throw new Assert.AssertionFailedException(Messages.bind(Messages.classpath_unknownKind, kindAttr));
            }
        }
        return entry;
    }

    private static void encodePatterns(IPath[] patterns, String tag, Map parameters) {
        if (patterns != null && patterns.length > 0) {
            StringBuffer rule = new StringBuffer(10);
            int i = 0;
            int max = patterns.length;
            while (i < max) {
                if (i > 0) {
                    rule.append('|');
                }
                rule.append(patterns[i]);
                ++i;
            }
            parameters.put(tag, String.valueOf(rule));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ClasspathEntry) {
            ClasspathEntry otherEntry = (ClasspathEntry)object;
            if (this.contentKind != otherEntry.getContentKind()) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != otherEntry.isExported()) {
                return false;
            }
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            IPath otherPath = otherEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? otherPath != null : !this.sourceAttachmentPath.equals((Object)otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentRootPath();
            if (this.sourceAttachmentRootPath == null ? otherPath != null : !this.sourceAttachmentRootPath.equals((Object)otherPath)) {
                return false;
            }
            if (!ClasspathEntry.equalPatterns(this.inclusionPatterns, otherEntry.getInclusionPatterns())) {
                return false;
            }
            if (!ClasspathEntry.equalPatterns(this.exclusionPatterns, otherEntry.getExclusionPatterns())) {
                return false;
            }
            AccessRuleSet otherRuleSet = otherEntry.getAccessRuleSet();
            if (this.getAccessRuleSet() != null ? !this.getAccessRuleSet().equals(otherRuleSet) : otherRuleSet != null) {
                return false;
            }
            if (this.combineAccessRules != otherEntry.combineAccessRules()) {
                return false;
            }
            otherPath = otherEntry.getOutputLocation();
            if (this.specificOutputLocation == null ? otherPath != null : !this.specificOutputLocation.equals((Object)otherPath)) {
                return false;
            }
            return ClasspathEntry.equalAttributes(this.extraAttributes, otherEntry.getExtraAttributes());
        }
        return false;
    }

    private static boolean equalAttributes(IClasspathAttribute[] firstAttributes, IClasspathAttribute[] secondAttributes) {
        if (firstAttributes != secondAttributes) {
            if (firstAttributes == null) {
                return false;
            }
            int length = firstAttributes.length;
            if (secondAttributes == null || secondAttributes.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!firstAttributes[i].equals(secondAttributes[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean equalPatterns(IPath[] firstPatterns, IPath[] secondPatterns) {
        if (firstPatterns != secondPatterns) {
            if (firstPatterns == null) {
                return false;
            }
            int length = firstPatterns.length;
            if (secondPatterns == null || secondPatterns.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!firstPatterns[i].toString().equals(secondPatterns[i].toString())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public IAccessRule[] getAccessRules() {
        if (this.accessRuleSet == null) {
            return NO_ACCESS_RULES;
        }
        AccessRule[] rules = this.accessRuleSet.getAccessRules();
        int length = rules.length;
        if (length == 0) {
            return NO_ACCESS_RULES;
        }
        IAccessRule[] result = new IAccessRule[length];
        System.arraycopy(rules, 0, result, 0, length);
        return result;
    }

    public AccessRuleSet getAccessRuleSet() {
        return this.accessRuleSet;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IClasspathAttribute[] getExtraAttributes() {
        return this.extraAttributes;
    }

    private String getMessageTemplate() {
        if (this.entryKind == 2 || this.entryKind == 3) {
            return Messages.bind(Messages.restrictedAccess_project, new String[]{"{0}", this.getPath().segment(0)});
        }
        IPath libPath = this.getPath();
        Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), libPath, false);
        String pathString = target instanceof File ? libPath.toOSString() : libPath.makeRelative().toString();
        return Messages.bind(Messages.restrictedAccess_library, new String[]{"{0}", pathString});
    }

    public IPath[] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public IPath getOutputLocation() {
        return this.specificOutputLocation;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isExported() {
        return this.isExported;
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase(TAG_OUTPUT)) {
            return 10;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
            case 10: {
                return TAG_OUTPUT;
            }
        }
        return "unknown";
    }

    public static IAccessRule[] getAccessRules(IPath[] accessibleFiles, IPath[] nonAccessibleFiles) {
        int nonAccessibleFilesLength;
        int accessibleFilesLength = accessibleFiles == null ? 0 : accessibleFiles.length;
        int length = accessibleFilesLength + (nonAccessibleFilesLength = nonAccessibleFiles == null ? 0 : nonAccessibleFiles.length);
        if (length == 0) {
            return null;
        }
        IAccessRule[] accessRules = new IAccessRule[length];
        int i = 0;
        while (i < accessibleFilesLength) {
            accessRules[i] = JavaCore.newAccessRule(accessibleFiles[i], 0);
            ++i;
        }
        i = 0;
        while (i < nonAccessibleFilesLength) {
            accessRules[accessibleFilesLength + i] = JavaCore.newAccessRule(nonAccessibleFiles[i], 1);
            ++i;
        }
        return accessRules;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath().toString());
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CPE_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CPE_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CPE_SOURCE");
                break;
            }
            case 4: {
                buffer.append("CPE_VARIABLE");
                break;
            }
            case 5: {
                buffer.append("CPE_CONTAINER");
            }
        }
        buffer.append("][");
        switch (this.getContentKind()) {
            case 2: {
                buffer.append("K_BINARY");
                break;
            }
            case 1: {
                buffer.append("K_SOURCE");
                break;
            }
            case 10: {
                buffer.append("K_OUTPUT");
            }
        }
        buffer.append(']');
        if (this.getSourceAttachmentPath() != null) {
            buffer.append("[sourcePath:");
            buffer.append(this.getSourceAttachmentPath());
            buffer.append(']');
        }
        if (this.getSourceAttachmentRootPath() != null) {
            buffer.append("[rootPath:");
            buffer.append(this.getSourceAttachmentRootPath());
            buffer.append(']');
        }
        buffer.append("[isExported:");
        buffer.append(this.isExported);
        buffer.append(']');
        IPath[] patterns = this.inclusionPatterns;
        int length = patterns == null ? 0 : patterns.length;
        if (length > 0) {
            buffer.append("[including:");
            i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if ((length = (patterns = this.exclusionPatterns) == null ? 0 : patterns.length) > 0) {
            buffer.append("[excluding:");
            i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if (this.accessRuleSet != null) {
            buffer.append('[');
            buffer.append(this.accessRuleSet.toString(false));
            buffer.append(']');
        }
        if (this.entryKind == 2) {
            buffer.append("[combine access rules:");
            buffer.append(this.combineAccessRules);
            buffer.append(']');
        }
        if (this.getOutputLocation() != null) {
            buffer.append("[output:");
            buffer.append(this.getOutputLocation());
            buffer.append(']');
        }
        if ((length = this.extraAttributes == null ? 0 : this.extraAttributes.length) > 0) {
            buffer.append("[attributes:");
            i = 0;
            while (i < length) {
                buffer.append(this.extraAttributes[i]);
                if (i != length - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public IClasspathEntry getResolvedEntry() {
        return JavaCore.getResolvedClasspathEntry(this);
    }

    public static IJavaModelStatus validateClasspath(IJavaProject javaProject, IClasspathEntry[] rawClasspath, IPath projectOutputLocation) {
        String entryPathMsg;
        boolean isProjectRelative;
        int kind;
        IClasspathEntry entry;
        IClasspathEntry resolvedEntry;
        IClasspathEntry[] classpath;
        IProject project = javaProject.getProject();
        IPath projectPath = project.getFullPath();
        String projectName = javaProject.getElementName();
        if (projectOutputLocation == null) {
            return new JavaModelStatus(970);
        }
        if (projectOutputLocation.isAbsolute()) {
            if (!projectPath.isPrefixOf(projectOutputLocation)) {
                return new JavaModelStatus(971, (IJavaElement)javaProject, projectOutputLocation.toString());
            }
        } else {
            return new JavaModelStatus(972, projectOutputLocation);
        }
        boolean hasSource = false;
        boolean hasLibFolder = false;
        if (rawClasspath == null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        try {
            classpath = ((JavaProject)javaProject).getResolvedClasspath(rawClasspath, null, true, false, null);
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        int length = classpath.length;
        int outputCount = 1;
        IPath[] outputLocations = new IPath[length + 1];
        boolean[] allowNestingInOutputLocations = new boolean[length + 1];
        outputLocations[0] = projectOutputLocation;
        IPath potentialNestedOutput = null;
        int sourceEntryCount = 0;
        boolean disableExclusionPatterns = "disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.exclusionPatterns", true));
        boolean disableCustomOutputLocations = "disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.multipleOutputLocations", true));
        int i = 0;
        while (i < length) {
            resolvedEntry = classpath[i];
            if (disableExclusionPatterns && (resolvedEntry.getInclusionPatterns() != null && resolvedEntry.getInclusionPatterns().length > 0 || resolvedEntry.getExclusionPatterns() != null && resolvedEntry.getExclusionPatterns().length > 0)) {
                return new JavaModelStatus(1002, (IJavaElement)javaProject, resolvedEntry.getPath());
            }
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    ++sourceEntryCount;
                    IPath customOutput = resolvedEntry.getOutputLocation();
                    if (customOutput == null) break;
                    if (disableCustomOutputLocations) {
                        return new JavaModelStatus(1003, (IJavaElement)javaProject, resolvedEntry.getPath());
                    }
                    if (customOutput.isAbsolute()) {
                        if (!javaProject.getPath().isPrefixOf(customOutput)) {
                            return new JavaModelStatus(971, (IJavaElement)javaProject, customOutput.toString());
                        }
                    } else {
                        return new JavaModelStatus(972, customOutput);
                    }
                    if (Util.indexOfMatchingPath(customOutput, outputLocations, outputCount) != -1) break;
                    outputLocations[outputCount++] = customOutput;
                }
            }
            ++i;
        }
        i = 1;
        while (i < outputCount) {
            IPath customOutput = outputLocations[i];
            int index = Util.indexOfEnclosingPath(customOutput, outputLocations, outputCount);
            if (index != -1 && index != i) {
                if (index == 0) {
                    if (potentialNestedOutput == null) {
                        potentialNestedOutput = customOutput;
                    }
                } else {
                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestOutputInOutput, new String[]{customOutput.makeRelative().toString(), outputLocations[index].makeRelative().toString()}));
                }
            }
            ++i;
        }
        if (sourceEntryCount <= outputCount - 1) {
            allowNestingInOutputLocations[0] = true;
        } else if (potentialNestedOutput != null) {
            return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestOutputInOutput, new String[]{potentialNestedOutput.makeRelative().toString(), outputLocations[0].makeRelative().toString()}));
        }
        i = 0;
        while (i < length) {
            resolvedEntry = classpath[i];
            IPath path = resolvedEntry.getPath();
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    hasSource = true;
                    int index = Util.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                    break;
                }
                case 1: {
                    hasLibFolder |= !org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(path.lastSegment());
                    int index = Util.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                }
            }
            ++i;
        }
        if (!hasSource && !hasLibFolder) {
            i = 0;
            while (i < outputCount) {
                allowNestingInOutputLocations[i] = true;
                ++i;
            }
        }
        HashSet<IPath> pathes = new HashSet<IPath>(length);
        int i2 = 0;
        while (i2 < length) {
            entry = classpath[i2];
            if (entry != null) {
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                isProjectRelative = projectName.equals(entryPath.segment(0));
                String string = entryPathMsg = isProjectRelative ? entryPath.removeFirstSegments(1).toString() : entryPath.makeRelative().toString();
                if (!pathes.add(entryPath)) {
                    return new JavaModelStatus(977, Messages.bind(Messages.classpath_duplicateEntryPath, new String[]{entryPathMsg, projectName}));
                }
                if (entryPath.equals((Object)projectPath)) {
                    if (kind == 2) {
                        return new JavaModelStatus(979, Messages.bind(Messages.classpath_cannotReferToItself, entryPath.makeRelative().toString()));
                    }
                } else {
                    IPath currentOutput;
                    if (kind == 3 || kind == 1 && !org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(entryPath.lastSegment())) {
                        int j = 0;
                        while (j < classpath.length) {
                            IClasspathEntry otherEntry = classpath[j];
                            if (otherEntry != null) {
                                int otherKind = otherEntry.getEntryKind();
                                IPath otherPath = otherEntry.getPath();
                                if (entry != otherEntry && (otherKind == 3 || otherKind == 1 && !org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(otherPath.lastSegment())) && otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath)) {
                                    char[][] inclusionPatterns = ((ClasspathEntry)otherEntry).fullInclusionPatternChars();
                                    char[][] exclusionPatterns = ((ClasspathEntry)otherEntry).fullExclusionPatternChars();
                                    if (!Util.isExcluded(entryPath.append("*"), inclusionPatterns, exclusionPatterns, false)) {
                                        String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                                        if (Util.isExcluded(entryPath, inclusionPatterns, exclusionPatterns, false)) {
                                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_mustEndWithSlash, new String[]{exclusionPattern, entryPath.makeRelative().toString()}));
                                        }
                                        if (otherKind == 3) {
                                            exclusionPattern = String.valueOf(exclusionPattern) + '/';
                                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestEntryInEntry, new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString(), exclusionPattern}));
                                        }
                                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestEntryInLibrary, new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString()}));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    char[][] inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                    char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                    int j = 0;
                    while (j < outputCount) {
                        currentOutput = outputLocations[j];
                        if (!(entryPath.equals((Object)currentOutput) || !entryPath.isPrefixOf(currentOutput) || kind == 3 && Util.isExcluded(currentOutput, inclusionPatterns, exclusionPatterns, true))) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestOutputInEntry, new String[]{currentOutput.makeRelative().toString(), entryPath.makeRelative().toString()}));
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < outputCount) {
                        if (!allowNestingInOutputLocations[j] && (currentOutput = outputLocations[j]).isPrefixOf(entryPath)) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestEntryInOutput, new String[]{entryPath.makeRelative().toString(), currentOutput.makeRelative().toString()}));
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            entry = classpath[i2];
            if (entry != null) {
                IPath output;
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                isProjectRelative = projectName.equals(entryPath.segment(0));
                String string = entryPathMsg = isProjectRelative ? entryPath.removeFirstSegments(1).toString() : entryPath.makeRelative().toString();
                if (kind == 3 && (output = entry.getOutputLocation()) != null) {
                    int j = 0;
                    while (j < length) {
                        IClasspathEntry otherEntry = classpath[j];
                        if (otherEntry != entry) {
                            boolean opStartsWithProject = projectName.equals(otherEntry.getPath().segment(0));
                            String otherPathMsg = opStartsWithProject ? otherEntry.getPath().removeFirstSegments(1).toString() : otherEntry.getPath().makeRelative().toString();
                            switch (otherEntry.getEntryKind()) {
                                case 3: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotUseDistinctSourceFolderAsOutput, new String[]{entryPathMsg, otherPathMsg, projectName}));
                                }
                                case 1: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotUseLibraryAsOutput, new String[]{entryPathMsg, otherPathMsg, projectName}));
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    /*
     * Unable to fully structure code
     */
    public static IJavaModelStatus validateClasspathEntry(IJavaProject project, IClasspathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        path = entry.getPath();
        projectName = project.getElementName();
        pathStartsWithProject = projectName.equals(path.segment(0));
        entryPathMsg = pathStartsWithProject != false ? path.removeFirstSegments(1).makeRelative().toString() : path.toString();
        switch (entry.getEntryKind()) {
            case 5: {
                if (path != null && path.segmentCount() >= 1) {
                    try {
                        container = JavaModelManager.getJavaModelManager().getClasspathContainer(path, project);
                        if (container == null) {
                            return new JavaModelStatus(963, (IJavaElement)project, path);
                        }
                        if (container == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                            extraAttributes = entry.getExtraAttributes();
                            if (extraAttributes != null) {
                                length = extraAttributes.length;
                                set = new HashSet<String>(length);
                                i = 0;
                                while (i < length) {
                                    attName = extraAttributes[i].getName();
                                    if (!set.add(attName)) {
                                        return new JavaModelStatus(977, Messages.bind(Messages.classpath_duplicateEntryExtraAttribute, new String[]{attName, entryPathMsg, projectName}));
                                    }
                                    ++i;
                                }
                            }
                            return JavaModelStatus.VERIFIED_OK;
                        }
                        containerEntries = container.getClasspathEntries();
                        if (containerEntries == null) break;
                        i = 0;
                        length = containerEntries.length;
                        while (i < length) {
                            containerEntry = containerEntries[i];
                            v0 = kind = containerEntry == null ? 0 : containerEntry.getEntryKind();
                            if (containerEntry == null || kind == 3 || kind == 4 || kind == 5) {
                                description = container.getDescription();
                                if (description == null) {
                                    description = path.makeRelative().toString();
                                }
                                return new JavaModelStatus(962, (IJavaElement)project, path);
                            }
                            if (recurseInContainers && !(containerEntryStatus = ClasspathEntry.validateClasspathEntry(project, containerEntry, checkSourceAttachment, recurseInContainers)).isOK()) {
                                return containerEntryStatus;
                            }
                            ++i;
                        }
                        break;
                    }
                    catch (JavaModelException e) {
                        return new JavaModelStatus(e);
                    }
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalContainerPath, new String[]{entryPathMsg, projectName}));
            }
            case 4: {
                if (path != null && path.segmentCount() >= 1) {
                    try {
                        entry = JavaCore.getResolvedClasspathEntry(entry);
                    }
                    catch (Assert.AssertionFailedException e) {
                        return new JavaModelStatus(979, e.getMessage());
                    }
                    if (entry == null) {
                        return new JavaModelStatus(965, (IJavaElement)project, path);
                    }
                    return ClasspathEntry.validateClasspathEntry(project, entry, checkSourceAttachment, recurseInContainers);
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalVariablePath, new String[]{entryPathMsg, projectName}));
            }
            case 1: {
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    sourceAttachment = entry.getSourceAttachmentPath();
                    target = JavaModel.getTarget((IContainer)workspaceRoot, path, true);
                    if (target != null && project.getOption("org.eclipse.jdt.core.incompatibleJDKLevel", true) != "ignore") {
                        projectTargetJDK = CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                        libraryJDK = Util.getJdkLevel(target);
                        if (libraryJDK != 0L && libraryJDK > projectTargetJDK) {
                            return new JavaModelStatus(1004, project, path, CompilerOptions.versionFromJdkLevel(libraryJDK));
                        }
                    }
                    if (target instanceof IResource) {
                        resolvedResource = (IResource)target;
                        switch (resolvedResource.getType()) {
                            case 1: {
                                if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resolvedResource.getName())) {
                                    if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceAttachment, new String[]{sourceAttachment.toString(), path.toString(), projectName}));
                                }
                                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalLibraryArchive, new String[]{entryPathMsg, projectName}));
                            }
                            case 2: {
                                if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                                return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceAttachment, new String[]{sourceAttachment.toString(), path.toString(), projectName}));
                            }
                        }
                        break;
                    }
                    if (target instanceof File) {
                        file = JavaModel.getFile(target);
                        if (file == null) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalExternalFolder, new String[]{path.toOSString(), projectName}));
                        }
                        if (!org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(file.getName())) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalLibraryArchive, new String[]{path.toOSString(), projectName}));
                        }
                        if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceAttachment, new String[]{sourceAttachment.toString(), path.toOSString(), projectName}));
                    }
                    v1 = isExternal = path.getDevice() != null || workspaceRoot.getProject(path.segment(0)).exists() == false;
                    if (isExternal) {
                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundLibrary, new String[]{path.toOSString(), projectName}));
                    }
                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundLibrary, new String[]{entryPathMsg, projectName}));
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalLibraryPath, new String[]{entryPathMsg, projectName}));
            }
            case 2: {
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    prereqProjectRsc = workspaceRoot.getProject(path.segment(0));
                    prereqProject = JavaCore.create(prereqProjectRsc);
                    try {
                        if (!prereqProjectRsc.exists() || !prereqProjectRsc.hasNature("org.eclipse.jdt.core.javanature")) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundProject, new String[]{path.segment(0), projectName}));
                        }
                        if (!prereqProjectRsc.isOpen()) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_closedProject, new String[]{path.segment(0)}));
                        }
                        if (project.getOption("org.eclipse.jdt.core.incompatibleJDKLevel", true) == "ignore") ** break;
                        projectTargetJDK = CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                        prereqProjectTargetJDK = CompilerOptions.versionToJdkLevel(prereqProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                        if (prereqProjectTargetJDK <= projectTargetJDK) ** break;
                        return new JavaModelStatus(1004, project, path, CompilerOptions.versionFromJdkLevel(prereqProjectTargetJDK));
                        break;
                    }
                    catch (CoreException v2) {
                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundProject, new String[]{path.segment(0), projectName}));
                    }
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalProjectPath, new String[]{path.segment(0), projectName}));
            }
            case 3: {
                if ((entry.getInclusionPatterns() != null && entry.getInclusionPatterns().length > 0 || entry.getExclusionPatterns() != null && entry.getExclusionPatterns().length > 0) && "disabled".equals(project.getOption("org.eclipse.jdt.core.classpath.exclusionPatterns", true))) {
                    return new JavaModelStatus(1002, (IJavaElement)project, path);
                }
                if (entry.getOutputLocation() != null && "disabled".equals(project.getOption("org.eclipse.jdt.core.classpath.multipleOutputLocations", true))) {
                    return new JavaModelStatus(1003, (IJavaElement)project, path);
                }
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    projectPath = project.getProject().getFullPath();
                    if (projectPath.isPrefixOf(path) && JavaModel.getTarget((IContainer)workspaceRoot, path, true) != null) break;
                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceFolder, new String[]{entryPathMsg, projectName}));
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalSourceFolderPath, new String[]{entryPathMsg, projectName}));
            }
        }
        extraAttributes = entry.getExtraAttributes();
        if (extraAttributes != null) {
            length = extraAttributes.length;
            set = new HashSet<String>(length);
            i = 0;
            while (i < length) {
                attName = extraAttributes[i].getName();
                if (!set.add(attName)) {
                    return new JavaModelStatus(977, Messages.bind(Messages.classpath_duplicateEntryExtraAttribute, new String[]{attName, entryPathMsg, projectName}));
                }
                ++i;
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

