/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util;

import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static boolean isToday(Date date) {
        return DateUtils.isSameDay(date, new Date());
    }

    public static boolean isYesterday(Date date) {
        return DateUtils.isSameDay(date, DateUtils.rollDay(new Date(), -1L));
    }

    public static boolean isThisYear(Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        Calendar cal2 = Calendar.getInstance();
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    private static Date rollDay(Date date, long amount) {
        long millisecondsInDay = 86400000L;
        long rolledTime = date.getTime() + amount * millisecondsInDay;
        return new Date(rolledTime);
    }
}

