/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ParameterSlot;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.CellFormatter;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Parameter;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.Modulos;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNamedSetEvaluator;
import mondrian.rolap.RolapTupleCalculation;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.util.ConcatenableList;
import mondrian.util.Format;
import mondrian.util.ObjectPool;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapResult
extends ResultBase {
    static final Logger LOGGER = Logger.getLogger(ResultBase.class);
    private RolapEvaluator evaluator;
    private final CellKey point;
    private CellInfoContainer cellInfos;
    private FastBatchingCellReader batchingReader;
    private final CellReader aggregatingReader = AggregationManager.instance().getCacheCellReader();
    private Modulos modulos = null;
    private final int maxEvalDepth;
    private final Map<Integer, Boolean> positionsHighCardinality;
    private final Map<Integer, Iterator<Position>> positionsIterators;
    private final Map<Integer, Integer> positionsIndexes;
    private final Map<Integer, List<Position>> positionsCurrent;
    protected static final Map<Locale, ValueFormatter> formatValueFormatters = Collections.synchronizedMap(new HashMap());
    protected static final Map<CellFormatter, ValueFormatter> cellFormatters = Collections.synchronizedMap(new HashMap());

    RolapResult(Query query, boolean execute) {
        super(query, new Axis[query.axes.length]);
        this.maxEvalDepth = MondrianProperties.instance().MaxEvalDepth.get();
        this.positionsHighCardinality = new HashMap<Integer, Boolean>();
        this.positionsIterators = new HashMap<Integer, Iterator<Position>>();
        this.positionsIndexes = new HashMap<Integer, Integer>();
        this.positionsCurrent = new HashMap<Integer, List<Position>>();
        this.point = CellKey.Generator.newCellKey(query.axes.length);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            this.evaluator = new RolapDependencyTestingEvaluator(this, expDeps);
        } else {
            RolapResultEvaluatorRoot root = new RolapResultEvaluatorRoot(this);
            this.evaluator = new RolapEvaluator(root);
        }
        RolapCube cube = (RolapCube)query.getCube();
        this.batchingReader = new FastBatchingCellReader(cube);
        CellInfoContainer cellInfoContainer = this.cellInfos = query.axes.length > 4 ? new CellInfoMap(this.point) : new CellInfoPool(query.axes.length);
        if (!execute) {
            return;
        }
        boolean normalExecution = true;
        try {
            Calc calc;
            Calc calc2;
            QueryAxis axis;
            cube.clearCachedAggregations();
            cube.checkAggregateModifications();
            AxisMember axisMembers = new AxisMember();
            ArrayList<Member> nonDefaultAllMembers = new ArrayList<Member>();
            ArrayList<List<Member>> nonAllMembers = new ArrayList<List<Member>>();
            ArrayList<Member> measureMembers = new ArrayList<Member>();
            this.loadSpecialMembers(nonDefaultAllMembers, nonAllMembers, measureMembers);
            query.clearEvalCache();
            query.putEvalCache("ALL_MEMBER_LIST", nonDefaultAllMembers);
            List<List<Member>> emptyNonAllMembers = Collections.emptyList();
            axisMembers.setSlicer(true);
            this.loadMembers(emptyNonAllMembers, this.evaluator, query.slicerAxis, query.slicerCalc, axisMembers);
            axisMembers.setSlicer(false);
            RolapEvaluator savedEvaluator = this.evaluator.push();
            if (!axisMembers.isEmpty()) {
                for (Member m : axisMembers) {
                    if (m == null) break;
                    this.evaluator.setSlicerContext(m);
                    if (!m.isMeasure()) continue;
                    measureMembers.clear();
                }
                this.replaceNonAllMembers(nonAllMembers, axisMembers);
                axisMembers.clearMembers();
            }
            boolean changed = false;
            axisMembers.clearTotalCellCount();
            for (int i = 0; i < this.axes.length; ++i) {
                axis = query.axes[i];
                calc2 = query.axisCalcs[i];
                this.loadMembers(emptyNonAllMembers, this.evaluator, axis, calc2, axisMembers);
            }
            if (!axisMembers.isEmpty()) {
                for (Member m : axisMembers) {
                    if (!m.isMeasure()) continue;
                    measureMembers.clear();
                }
                changed = this.replaceNonAllMembers(nonAllMembers, axisMembers);
                axisMembers.clearMembers();
            }
            if (changed) {
                axisMembers.countOnly(true);
                axisMembers.clearTotalCellCount();
                for (int i = 0; i < this.axes.length; ++i) {
                    axis = query.axes[i];
                    calc2 = query.axisCalcs[i];
                    this.loadMembers(nonAllMembers, this.evaluator.push(), axis, calc2, axisMembers);
                }
            }
            axisMembers.checkLimit();
            this.slicerAxis = this.evalExecute(nonAllMembers, nonAllMembers.size() - 1, savedEvaluator, query.slicerAxis, query.slicerCalc);
            final List<Position> positionList = this.slicerAxis.getPositions();
            RolapEvaluator evaluator = this.evaluator;
            if (positionList.size() > 1) {
                int arity = positionList.get(0).size();
                List<Member[]> tupleList = new ArrayList<Member[]>(positionList.size());
                for (Position position : positionList) {
                    Member[] members = new Member[arity];
                    for (int i = 0; i < position.size(); ++i) {
                        members[i] = (Member)position.get(i);
                    }
                    tupleList.add(members);
                }
                tupleList = AggregateFunDef.AggregateCalc.optimizeTupleList(evaluator, tupleList);
                final ValueCalc valueCalc = new ValueCalc(new DummyExp(new ScalarType()));
                final List<Member[]> tupleList1 = tupleList;
                calc = new GenericCalc(new DummyExp(query.slicerCalc.getType())){

                    public Object evaluate(Evaluator evaluator) {
                        return AggregateFunDef.AggregateCalc.aggregate(valueCalc, evaluator, tupleList1);
                    }
                };
                AbstractList<RolapHierarchy> hierarchyList = new AbstractList<RolapHierarchy>(){
                    final Position pos0;
                    {
                        this.pos0 = (Position)positionList.get(0);
                    }

                    @Override
                    public RolapHierarchy get(int index) {
                        return ((RolapMember)this.pos0.get(index)).getHierarchy();
                    }

                    @Override
                    public int size() {
                        return 0;
                    }
                };
                evaluator = evaluator.push(new RolapTupleCalculation((List<RolapHierarchy>)hierarchyList, calc));
            }
            boolean redo = true;
            while (redo) {
                RolapEvaluator e = evaluator.push();
                redo = false;
                for (int i = 0; i < this.axes.length; ++i) {
                    List<Position> pl;
                    QueryAxis axis2 = query.axes[i];
                    calc = query.axisCalcs[i];
                    Axis axisResult = this.evalExecute(nonAllMembers, nonAllMembers.size() - 1, e, axis2, calc);
                    if (!nonAllMembers.isEmpty() && !(pl = axisResult.getPositions()).isEmpty()) {
                        Position p = pl.get(0);
                        for (Member m : p) {
                            if (!m.isCalculated()) continue;
                            CalculatedMeasureVisitor visitor = new CalculatedMeasureVisitor();
                            m.getExpression().accept(visitor);
                            Dimension dimension = visitor.dimension;
                            redo = this.removeDimension(dimension, nonAllMembers);
                        }
                    }
                    this.axes[i] = axisResult;
                }
            }
            this.executeBody(evaluator, this.query, new int[this.axes.length]);
            if (this.cellInfos.size() > 10000) {
                this.cellInfos.trimToSize();
            }
        }
        catch (ResultLimitExceededException ex) {
            normalExecution = false;
            this.evaluator = null;
            this.cellInfos = null;
            this.batchingReader = null;
            for (int i = 0; i < this.axes.length; ++i) {
                this.axes[i] = null;
            }
            this.slicerAxis = null;
            query.clearEvalCache();
            throw ex;
        }
        finally {
            if (normalExecution) {
                cube.pushAggregateModificationsToGlobalCache();
                this.evaluator.clearExpResultCache(true);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("RolapResult<init>: " + Util.printMemory()));
            }
        }
    }

    protected boolean removeDimension(Dimension dimension, List<List<Member>> nonAllMembers) {
        boolean changed = false;
        ListIterator<List<Member>> it = nonAllMembers.listIterator();
        while (it.hasNext()) {
            List<Member> ms = it.next();
            Dimension d = ms.get(0).getHierarchy().getDimension();
            if (!d.equals(dimension)) continue;
            it.remove();
        }
        return changed;
    }

    protected boolean replaceNonAllMembers(List<List<Member>> nonAllMembers, AxisMember axisMembers) {
        boolean changed = false;
        ArrayList<Member> mList = new ArrayList<Member>();
        ListIterator<List<Member>> it = nonAllMembers.listIterator();
        while (it.hasNext()) {
            List<Member> ms = it.next();
            Hierarchy h = ms.get(0).getHierarchy();
            mList.clear();
            for (Member m : axisMembers) {
                if (!m.getHierarchy().equals(h)) continue;
                mList.add(m);
            }
            if (mList.isEmpty()) continue;
            changed = true;
            it.set(mList);
        }
        return changed;
    }

    protected void loadMembers(List<List<Member>> nonAllMembers, RolapEvaluator evaluator, QueryAxis axis, Calc calc, AxisMember axisMembers) {
        block1: {
            int attempt = 0;
            evaluator.setCellReader(this.batchingReader);
            do {
                axisMembers.clearAxisCount();
                this.evalLoad(nonAllMembers, nonAllMembers.size() - 1, evaluator, axis, calc, axisMembers);
                if (!this.batchingReader.loadAggregations(this.query)) break block1;
                evaluator.clearExpResultCache(false);
            } while (attempt++ <= this.maxEvalDepth);
            throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + " passes; there's probably a cycle");
        }
    }

    void evalLoad(List<List<Member>> nonAllMembers, int cnt, Evaluator evaluator, QueryAxis axis, Calc calc, AxisMember axisMembers) {
        if (cnt < 0) {
            this.executeAxis(evaluator.push(), axis, calc, false, axisMembers);
        } else {
            for (Member m : nonAllMembers.get(cnt)) {
                evaluator.setContext(m);
                this.evalLoad(nonAllMembers, cnt - 1, evaluator, axis, calc, axisMembers);
            }
        }
    }

    Axis evalExecute(List<List<Member>> nonAllMembers, int cnt, RolapEvaluator evaluator, QueryAxis axis, Calc calc) {
        if (cnt < 0) {
            evaluator.setCellReader(this.aggregatingReader);
            return this.executeAxis(evaluator.push(), axis, calc, true, null);
        }
        Axis axisResult = null;
        for (Member m : nonAllMembers.get(cnt)) {
            evaluator.setContext(m);
            Axis a = this.evalExecute(nonAllMembers, cnt - 1, evaluator, axis, calc);
            boolean ordered = false;
            if (axis != null) {
                ordered = axis.isOrdered();
            }
            axisResult = RolapResult.mergeAxes(axisResult, a, evaluator, ordered);
        }
        return axisResult;
    }

    protected void loadSpecialMembers(List<Member> nonDefaultAllMembers, List<List<Member>> nonAllMembers, List<Member> measureMembers) {
        Member[] evalMembers;
        SchemaReader schemaReader = this.evaluator.getSchemaReader();
        block0: for (Member em : evalMembers = this.evaluator.getMembers()) {
            Hierarchy h;
            Dimension d;
            if (em.isCalculated() || (d = (h = em.getHierarchy()).getDimension()).getDimensionType() == DimensionType.TimeDimension || em.isAll()) continue;
            List<Member> rootMembers = schemaReader.getHierarchyRootMembers(h);
            if (em.isMeasure()) {
                for (Member mm : rootMembers) {
                    measureMembers.add(mm);
                }
                continue;
            }
            if (h.hasAll()) {
                for (Member m : rootMembers) {
                    if (!m.isAll()) continue;
                    nonDefaultAllMembers.add(m);
                    continue block0;
                }
                continue;
            }
            nonAllMembers.add(rootMembers);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public final RolapCube getCube() {
        return this.evaluator.getCube();
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public Cell getCell(int[] pos) {
        if (pos.length != this.point.size()) {
            throw Util.newError("coordinates should have dimension " + this.point.size());
        }
        for (int i = 0; i < pos.length; ++i) {
            if (!this.positionsHighCardinality.get(i).booleanValue()) continue;
            this.executeBody(this.evaluator, this.query, pos);
            break;
        }
        CellInfo ci = this.cellInfos.lookup(pos);
        if (ci.value == null) {
            for (int i = 0; i < pos.length; ++i) {
                int po = pos[i];
                if (po >= 0 && po < this.axes[i].getPositions().size()) continue;
                throw Util.newError("coordinates out of range");
            }
            ci.value = Util.nullValue;
        }
        return new RolapCell(this, (int[])pos.clone(), ci);
    }

    private Axis executeAxis(Evaluator evaluator, QueryAxis axis, Calc axisCalc, boolean construct, AxisMember axisMembers) {
        RolapAxis axisResult = null;
        if (axis == null) {
            if (construct) {
                axisResult = new RolapAxis.SingleEmptyPosition();
            }
        } else {
            int arity = axis.getSet().getType() instanceof SetType ? ((SetType)axis.getSet().getType()).getArity() : (axis.getSet().getType() instanceof TupleType ? ((TupleType)axis.getSet().getType()).elementTypes.length : 1);
            evaluator.setNonEmpty(axis.isNonEmpty());
            evaluator.setEvalAxes(true);
            Object value = axisCalc.evaluate(evaluator);
            if (axisCalc.getClass().getName().indexOf("OrderFunDef") != -1) {
                axis.setOrdered(true);
            }
            evaluator.setNonEmpty(false);
            if (value != null) {
                if (value instanceof List) {
                    List list = (List)value;
                    if (construct) {
                        axisResult = list.isEmpty() ? new RolapAxis.NoPosition() : (arity == 1 ? new RolapAxis.MemberList((List)value) : new RolapAxis.MemberArrayList((List)value));
                    } else if (axisMembers != null) {
                        if (arity == 1) {
                            axisMembers.mergeMemberList((List)value);
                        } else {
                            axisMembers.mergeTupleList((List)value);
                        }
                    }
                } else {
                    Iterable iter = (Iterable)value;
                    Iterator it = iter.iterator();
                    if (construct) {
                        axisResult = !it.hasNext() ? new RolapAxis.NoPosition() : (arity != 1 ? new RolapAxis.MemberArrayIterable((Iterable)value) : new RolapAxis.MemberIterable((Iterable)value));
                    } else if (axisMembers != null) {
                        if (arity == 1) {
                            axisMembers.mergeMemberIter(it);
                        } else {
                            axisMembers.mergeTupleIter(it);
                        }
                    }
                }
            }
            evaluator.setEvalAxes(false);
        }
        return axisResult;
    }

    private void executeBody(RolapEvaluator evaluator, Query query, int[] pos) {
        int count = 0;
        while (true) {
            evaluator.setCellReader(this.batchingReader);
            this.executeStripe(query.axes.length - 1, evaluator.push(), pos);
            if (!this.batchingReader.loadAggregations(query)) {
                return;
            }
            evaluator.clearExpResultCache(false);
            if (count++ > this.maxEvalDepth) {
                if (evaluator instanceof RolapDependencyTestingEvaluator) {
                    ((RolapDependencyTestingEvaluator.DteRoot)evaluator.root).disabled = true;
                    if (count > this.maxEvalDepth * 2) {
                        throw Util.newInternal("Query required more than " + count + " iterations");
                    }
                } else {
                    throw Util.newInternal("Query required more than " + count + " iterations");
                }
            }
            this.cellInfos.clear();
        }
    }

    boolean isDirty() {
        return this.batchingReader.isDirty();
    }

    Object evaluateExp(Calc calc, RolapEvaluator evaluator) {
        RolapEvaluator ev;
        boolean dirty;
        block4: {
            int attempt = 0;
            dirty = this.batchingReader.isDirty();
            do {
                ev = evaluator.push();
                ev.setCellReader(this.batchingReader);
                Object preliminaryValue = calc.evaluate(ev);
                if (preliminaryValue instanceof Iterable && !(preliminaryValue instanceof List)) {
                    Iterable iterable = (Iterable)preliminaryValue;
                    for (Object anIterable : iterable) {
                        Util.discard(anIterable);
                    }
                }
                if (!this.batchingReader.loadAggregations(evaluator.getQuery())) break block4;
                ev.clearExpResultCache(false);
            } while (attempt++ <= this.maxEvalDepth);
            throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + "passes; there's probably a cycle");
        }
        if (dirty) {
            this.batchingReader.setDirty(true);
        }
        ev = evaluator.push();
        ev.setCellReader(this.aggregatingReader);
        return calc.evaluate(ev);
    }

    private void executeStripe(int axisOrdinal, RolapEvaluator revaluator, int[] pos) {
        if (axisOrdinal < 0) {
            Axis axis = this.slicerAxis;
            List<Position> positions = axis.getPositions();
            for (Position position : positions) {
                Object o;
                this.getQuery().checkCancelOrTimeout();
                revaluator.setContext(position);
                try {
                    o = revaluator.evaluateCurrent();
                }
                catch (MondrianEvaluationException e) {
                    LOGGER.warn((Object)"Mondrian: exception in executeStripe.", (Throwable)e);
                    o = e;
                }
                CellInfo ci = null;
                try {
                    ValueFormatter valueFormatter;
                    ci = this.cellInfos.create(this.point.getOrdinals());
                    String cachedFormatString = null;
                    RolapCube cube = this.getCube();
                    Hierarchy measuresHierarchy = cube.getMeasuresHierarchy();
                    RolapMeasure m = (RolapMeasure)((Object)revaluator.getContext(measuresHierarchy));
                    CellFormatter cf = m.getFormatter();
                    if (cf != null) {
                        valueFormatter = cellFormatters.get(cf);
                        if (valueFormatter == null) {
                            valueFormatter = new CellFormatterValueFormatter(cf);
                            cellFormatters.put(cf, valueFormatter);
                        }
                    } else {
                        cachedFormatString = revaluator.getFormatString();
                        Locale locale = this.query.getConnection().getLocale();
                        valueFormatter = formatValueFormatters.get(locale);
                        if (valueFormatter == null) {
                            valueFormatter = new FormatValueFormatter(locale);
                            formatValueFormatters.put(locale, valueFormatter);
                        }
                    }
                    ci.formatString = cachedFormatString;
                    ci.valueFormatter = valueFormatter;
                }
                catch (ResultLimitExceededException e) {
                    throw e;
                }
                catch (MondrianEvaluationException e) {
                    LOGGER.warn((Object)"Mondrian: exception in executeStripe.", (Throwable)e);
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOGGER.warn((Object)"Mondrian: exception in executeStripe.", e);
                    Util.discard((Object)e);
                }
                if (o == RolapUtil.valueNotReadyException) continue;
                ci.value = o;
            }
        } else {
            Axis axis = this.axes[axisOrdinal];
            List<Position> positions = axis.getPositions();
            if (this.positionsHighCardinality.get(axisOrdinal) == null && !positions.isEmpty() && !positions.get(0).isEmpty()) {
                this.positionsHighCardinality.put(axisOrdinal, ((Member)positions.get(0).get(0)).getDimension().isHighCardinality());
            }
            if (this.positionsHighCardinality.get(axisOrdinal) != null && this.positionsHighCardinality.get(axisOrdinal).booleanValue()) {
                int pi;
                Iterator<Position> it;
                int limit = MondrianProperties.instance().HighCardChunkSize.get();
                if (this.positionsIterators.get(axisOrdinal) == null) {
                    it = positions.iterator();
                    this.positionsIterators.put(axisOrdinal, it);
                    this.positionsIndexes.put(axisOrdinal, 0);
                    ArrayList<Position> subPositions = new ArrayList<Position>();
                    for (int i = 0; i < limit && it.hasNext(); ++i) {
                        subPositions.add(it.next());
                    }
                    this.positionsCurrent.put(axisOrdinal, subPositions);
                }
                it = this.positionsIterators.get(axisOrdinal);
                int positionIndex = this.positionsIndexes.get(axisOrdinal);
                List<Position> subPositions = this.positionsCurrent.get(axisOrdinal);
                if (subPositions == null) {
                    return;
                }
                if (pos[axisOrdinal] > positionIndex + subPositions.size() - 1 && subPositions.size() == limit) {
                    pi = positionIndex + subPositions.size();
                    this.positionsIndexes.put(axisOrdinal, positionIndex + subPositions.size());
                    subPositions.subList(0, subPositions.size()).clear();
                    for (int i = 0; i < limit && it.hasNext(); ++i) {
                        subPositions.add(it.next());
                    }
                    this.positionsCurrent.put(axisOrdinal, subPositions);
                } else {
                    pi = positionIndex;
                }
                for (Position position : subPositions) {
                    this.point.setAxis(axisOrdinal, pi);
                    revaluator.setContext(position);
                    this.getQuery().checkCancelOrTimeout();
                    this.executeStripe(axisOrdinal - 1, revaluator, pos);
                    ++pi;
                }
            } else {
                int positionIndex = 0;
                for (Position position : positions) {
                    this.point.setAxis(axisOrdinal, positionIndex);
                    revaluator.setContext(position);
                    this.getQuery().checkCancelOrTimeout();
                    this.executeStripe(axisOrdinal - 1, revaluator, pos);
                    ++positionIndex;
                }
            }
        }
    }

    int getCellOrdinal(int[] pos) {
        if (this.modulos == null) {
            this.makeModulos();
        }
        return this.modulos.getCellOrdinal(pos);
    }

    protected void makeModulos() {
        this.modulos = Modulos.Generator.create(this.axes);
    }

    RolapEvaluator getCellEvaluator(int[] pos) {
        RolapEvaluator cellEvaluator = this.evaluator.push();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].getPositions().get(pos[i]);
            cellEvaluator.setContext(position);
        }
        return cellEvaluator;
    }

    RolapMember[] getCellMembers(int[] pos) {
        RolapMember[] members = (RolapMember[])this.evaluator.getMembers().clone();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].getPositions().get(pos[i]);
            for (Member member : position) {
                RolapMember m = (RolapMember)member;
                int ordinal = m.getHierarchy().getOrdinalInCube();
                members[ordinal] = m;
            }
        }
        return members;
    }

    Evaluator getRootEvaluator() {
        return this.evaluator;
    }

    Evaluator getEvaluator(int[] pos) {
        RolapEvaluator cellEvaluator = this.evaluator.push();
        for (int i = -1; i < this.axes.length; ++i) {
            int index;
            Axis axis;
            if (i < 0) {
                axis = this.slicerAxis;
                index = 0;
            } else {
                axis = this.axes[i];
                index = pos[i];
            }
            Position position = axis.getPositions().get(index);
            cellEvaluator.setContext(position);
        }
        return cellEvaluator;
    }

    static Axis mergeAxes(Axis axis1, Axis axis2, RolapEvaluator evaluator, boolean ordered) {
        if (axis1 == null) {
            return axis2;
        }
        List<Position> posList1 = axis1.getPositions();
        List<Position> posList2 = axis2.getPositions();
        int arrayLen = -1;
        if (posList1 instanceof RolapAxis.PositionListBase) {
            if (posList1.isEmpty()) {
                return axis2;
            }
            arrayLen = posList1.get(0).size();
        }
        if (axis1 instanceof RolapAxis.SingleEmptyPosition) {
            return axis2;
        }
        if (axis1 instanceof RolapAxis.NoPosition) {
            return axis2;
        }
        if (posList2 instanceof RolapAxis.PositionListBase) {
            if (posList2.isEmpty()) {
                return axis1;
            }
            arrayLen = posList2.get(0).size();
        }
        if (axis2 instanceof RolapAxis.SingleEmptyPosition) {
            return axis1;
        }
        if (axis2 instanceof RolapAxis.NoPosition) {
            return axis1;
        }
        if (arrayLen == -1) {
            arrayLen = 0;
            Iterator<Position> i$ = posList1.iterator();
            if (i$.hasNext()) {
                Position p1 = i$.next();
                arrayLen += p1.size();
            }
            posList1 = axis1.getPositions();
        }
        if (arrayLen == 1) {
            LinkedHashSet<Member> orderedSet = new LinkedHashSet<Member>();
            for (Position p1 : posList1) {
                for (Member m1 : p1) {
                    orderedSet.add(m1);
                }
            }
            for (Position p2 : posList2) {
                for (Member m2 : p2) {
                    orderedSet.add(m2);
                }
            }
            return new RolapAxis.MemberList(Arrays.asList(orderedSet.toArray(new Member[orderedSet.size()])));
        }
        HashSet<Position> set = new HashSet<Position>();
        ArrayList<Member[]> list = new ArrayList<Member[]>();
        for (Position p1 : posList1) {
            if (!set.add(p1)) continue;
            Member[] members = new Member[arrayLen];
            for (int i = 0; i < p1.size(); ++i) {
                members[i] = (Member)p1.get(i);
            }
            list.add(members);
        }
        int halfWay = list.size();
        for (Position p2 : posList2) {
            if (!set.add(p2)) continue;
            Member[] members = new Member[arrayLen];
            for (int i = 0; i < p2.size(); ++i) {
                Member m2;
                members[i] = m2 = (Member)p2.get(i);
            }
            list.add(members);
        }
        if (halfWay > 0 && halfWay < list.size() && !ordered) {
            Member[] membs = (Member[])list.get(0);
            int membsSize = membs.length;
            ValueCalc valCalc = new ValueCalc(new DummyExp(new ScalarType()));
            FunUtil.sortTuples(evaluator, list, list, valCalc, false, false, membsSize);
        }
        return new RolapAxis.MemberArrayList(list);
    }

    static class CellInfoPool
    implements CellInfoContainer {
        protected static final long MAX_AXIS_SIZE_2 = Integer.MAX_VALUE;
        protected static final long MAX_AXIS_SIZE_3 = 2000000L;
        protected static final long MAX_AXIS_SIZE_4 = 50000L;
        private final ObjectPool<CellInfo> cellInfoPool;
        private final CellKeyMaker cellKeyMaker;

        CellInfoPool(int axisLength) {
            this.cellInfoPool = new ObjectPool();
            this.cellKeyMaker = CellInfoPool.createCellKeyMaker(axisLength);
        }

        CellInfoPool(int axisLength, int initialSize) {
            this.cellInfoPool = new ObjectPool(initialSize);
            this.cellKeyMaker = CellInfoPool.createCellKeyMaker(axisLength);
        }

        private static CellKeyMaker createCellKeyMaker(int axisLength) {
            switch (axisLength) {
                case 0: {
                    return new Zero();
                }
                case 1: {
                    return new One();
                }
                case 2: {
                    return new Two();
                }
                case 3: {
                    return new Three();
                }
                case 4: {
                    return new Four();
                }
            }
            throw new RuntimeException("Creating CellInfoPool with axisLength=" + axisLength);
        }

        public int size() {
            return this.cellInfoPool.size();
        }

        public void trimToSize() {
            this.cellInfoPool.trimToSize();
        }

        public void clear() {
            this.cellInfoPool.clear();
        }

        public CellInfo create(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        public CellInfo lookup(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        static class Four
        implements CellKeyMaker {
            Four() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                l += 50000L * (long)pos[1];
                l += 2500000000L * (long)pos[2];
                return l += 125000000000000L * (long)pos[3];
            }
        }

        static class Three
        implements CellKeyMaker {
            Three() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                l += 2000000L * (long)pos[1];
                return l += 4000000000000L * (long)pos[2];
            }
        }

        static class Two
        implements CellKeyMaker {
            Two() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                return l += Integer.MAX_VALUE * (long)pos[1];
            }
        }

        static class One
        implements CellKeyMaker {
            One() {
            }

            public long generate(int[] pos) {
                return pos[0];
            }
        }

        static class Zero
        implements CellKeyMaker {
            Zero() {
            }

            public long generate(int[] pos) {
                return 0L;
            }
        }

        static interface CellKeyMaker {
            public long generate(int[] var1);
        }
    }

    static class CellInfoMap
    implements CellInfoContainer {
        private final Map<CellKey, CellInfo> cellInfoMap;
        private final CellKey point;

        CellInfoMap(CellKey point) {
            this.point = point;
            this.cellInfoMap = new HashMap<CellKey, CellInfo>();
        }

        public int size() {
            return this.cellInfoMap.size();
        }

        public void trimToSize() {
        }

        public void clear() {
            this.cellInfoMap.clear();
        }

        public CellInfo create(int[] pos) {
            CellKey key = this.point.copy();
            CellInfo ci = this.cellInfoMap.get(key);
            if (ci == null) {
                ci = new CellInfo(0L);
                this.cellInfoMap.put(key, ci);
            }
            return ci;
        }

        public CellInfo lookup(int[] pos) {
            CellKey key = CellKey.Generator.newCellKey(pos);
            return this.cellInfoMap.get(key);
        }
    }

    static interface CellInfoContainer {
        public int size();

        public void trimToSize();

        public void clear();

        public CellInfo create(int[] var1);

        public CellInfo lookup(int[] var1);
    }

    static class CellInfo {
        Object value;
        String formatString;
        ValueFormatter valueFormatter;
        long key;

        CellInfo(long key) {
            this(key, null, null, ValueFormatter.EMPTY);
        }

        CellInfo(long key, Object value, String formatString, ValueFormatter valueFormatter) {
            this.key = key;
            this.value = value;
            this.formatString = formatString;
            this.valueFormatter = valueFormatter;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 11 ^ this.key >>> 24);
        }

        public boolean equals(Object o) {
            if (o instanceof CellInfo) {
                CellInfo that = (CellInfo)o;
                return that.key == this.key;
            }
            return false;
        }

        String getFormatValue() {
            return this.valueFormatter.format(this.value, this.formatString);
        }
    }

    static class FormatValueFormatter
    implements ValueFormatter {
        final Locale locale;

        FormatValueFormatter(Locale locale) {
            this.locale = locale;
        }

        public String format(Object value, String formatString) {
            if (value == Util.nullValue) {
                Format format = this.getFormat(formatString);
                return format.format(null);
            }
            if (value instanceof Throwable) {
                return "#ERR: " + value.toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            Format format = this.getFormat(formatString);
            return format.format(value);
        }

        private Format getFormat(String formatString) {
            return Format.get(formatString, this.locale);
        }
    }

    static class CellFormatterValueFormatter
    implements ValueFormatter {
        final CellFormatter cf;

        CellFormatterValueFormatter(CellFormatter cf) {
            this.cf = cf;
        }

        public String format(Object value, String formatString) {
            return this.cf.formatCell(value);
        }
    }

    static interface ValueFormatter {
        public static final ValueFormatter EMPTY = new ValueFormatter(){

            public String format(Object value, String formatString) {
                return "";
            }
        };

        public String format(Object var1, String var2);
    }

    protected static class RolapResultEvaluatorRoot
    extends RolapEvaluatorRoot {
        private final Map<String, RolapNamedSetEvaluator> namedSetEvaluators = new HashMap<String, RolapNamedSetEvaluator>();
        RolapEvaluator slicerEvaluator;
        final RolapResult result;
        private static final Object CycleSentinel = new Object();
        private static final Object NullSentinel = new Object();

        public RolapResultEvaluatorRoot(RolapResult result) {
            super(result.query);
            this.result = result;
        }

        protected void init(Evaluator evaluator) {
            this.slicerEvaluator = (RolapEvaluator)evaluator;
        }

        protected Evaluator.NamedSetEvaluator evaluateNamedSet(NamedSet namedSet, boolean create) {
            String name = namedSet.getNameUniqueWithinQuery();
            RolapNamedSetEvaluator value = namedSet.isDynamic() && !create ? null : this.namedSetEvaluators.get(name);
            if (value == null) {
                value = new RolapNamedSetEvaluator(this, namedSet);
                this.namedSetEvaluators.put(name, value);
            }
            return value;
        }

        public Object getParameterValue(ParameterSlot slot) {
            if (slot.isParameterSet()) {
                return slot.getParameterValue();
            }
            Parameter.Scope scope = slot.getParameter().getScope();
            switch (scope) {
                case System: 
                case Schema: 
                case Connection: 
                case Statement: {
                    break;
                }
                default: {
                    throw Util.badValue(scope);
                }
            }
            Object liftedValue = slot.getCachedDefaultValue();
            if (liftedValue != null) {
                if (liftedValue == CycleSentinel) {
                    throw MondrianResource.instance().CycleDuringParameterEvaluation.ex(slot.getParameter().getName());
                }
                Object value = liftedValue == NullSentinel ? null : liftedValue;
                return value;
            }
            slot.setCachedDefaultValue(CycleSentinel);
            Object value = this.result.evaluateExp(slot.getDefaultValueCalc(), this.slicerEvaluator.push());
            liftedValue = value == null ? NullSentinel : value;
            slot.setCachedDefaultValue(liftedValue);
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AxisMember
    implements Iterable<Member> {
        private final List<Member> members = new ConcatenableList<Member>();
        private final int limit;
        private boolean isSlicer;
        private int totalCellCount = 1;
        private int axisCount = 0;
        private boolean countOnly = false;

        AxisMember() {
            this.limit = MondrianProperties.instance().ResultLimit.get();
        }

        @Override
        public Iterator<Member> iterator() {
            return this.members.iterator();
        }

        void setSlicer(boolean isSlicer) {
            this.isSlicer = isSlicer;
        }

        boolean isEmpty() {
            return this.members.isEmpty();
        }

        void countOnly(boolean countOnly) {
            this.countOnly = countOnly;
        }

        void checkLimit() {
            if (this.limit > 0) {
                this.totalCellCount *= this.axisCount;
                if (this.totalCellCount > this.limit) {
                    throw MondrianResource.instance().TotalMembersLimitExceeded.ex(this.totalCellCount, this.limit);
                }
                this.axisCount = 0;
            }
        }

        void clearAxisCount() {
            this.axisCount = 0;
        }

        void clearTotalCellCount() {
            this.totalCellCount = 1;
        }

        void clearMembers() {
            this.members.clear();
            this.axisCount = 0;
            this.totalCellCount = 1;
        }

        List<Member> members() {
            return this.members;
        }

        void mergeMemberList(List<Member> list) {
            for (Member o : list) {
                if (o == null) continue;
                if (o.getDimension().isHighCardinality()) break;
                this.mergeMember(o);
            }
        }

        void mergeTupleList(List<Member[]> list) {
            for (Member[] o : list) {
                this.mergeTuple(o);
            }
        }

        private void mergeMemberIter(Iterator<Member> it) {
            while (it.hasNext()) {
                this.mergeMember(it.next());
            }
        }

        private void mergeTupleIter(Iterator<Member[]> it) {
            while (it.hasNext()) {
                this.mergeTuple(it.next());
            }
        }

        private Member getTopParent(Member m) {
            Member parent = m.getParentMember();
            return parent == null ? m : this.getTopParent(parent);
        }

        private void mergeTuple(Member[] members) {
            for (Member member : members) {
                this.mergeMember(member);
            }
        }

        private void mergeMember(Member member) {
            ++this.axisCount;
            if (!this.countOnly) {
                if (this.isSlicer) {
                    if (!this.members.contains(member)) {
                        this.members.add(member);
                    }
                } else {
                    if (member.isNull()) {
                        return;
                    }
                    if (member.isMeasure()) {
                        return;
                    }
                    if (member.isCalculated()) {
                        return;
                    }
                    if (member.isAll()) {
                        return;
                    }
                    Member topParent = this.getTopParent(member);
                    if (!this.members.contains(topParent)) {
                        this.members.add(topParent);
                    }
                }
            }
        }
    }

    private static class CalculatedMeasureVisitor
    extends MdxVisitorImpl {
        Dimension dimension;

        CalculatedMeasureVisitor() {
        }

        public Object visit(DimensionExpr dimensionExpr) {
            this.dimension = dimensionExpr.getDimension();
            return null;
        }

        public Object visit(HierarchyExpr hierarchyExpr) {
            Hierarchy hierarchy = hierarchyExpr.getHierarchy();
            this.dimension = hierarchy.getDimension();
            return null;
        }

        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            this.dimension = member.getHierarchy().getDimension();
            return null;
        }
    }
}

