/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.report;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceCallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceInTemplateCaller;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceAlreadyExistsException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.AccessDeniedException;

public class ReportsServiceCallTemplate<T>
implements RemoteServiceCallTemplate<T> {
    private static final Log log = LogFactory.getLog(ReportsServiceCallTemplate.class);

    public <ResponseType> ResponseType callRemoteService(RemoteServiceInTemplateCaller<ResponseType, T> caller, T service) {
        Response response;
        try {
            response = (Response)caller.call(service);
        }
        catch (JSValidationException e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getErrors()).build();
        }
        catch (ResourceNotFoundException e) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getErrorDescriptor()).build();
        }
        catch (ResourceAlreadyExistsException e) {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getErrorDescriptor()).build();
        }
        catch (JSResourceNotFoundException e) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorDescriptor.Builder().setMessage("Resource not found").setErrorCode("resource.not.found").setParameters(e.getArgs()).getErrorDescriptor()).build();
        }
        catch (AccessDeniedException e) {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new com.jaspersoft.jasperserver.remote.exception.AccessDeniedException(e.getMessage()).getErrorDescriptor()).build();
        }
        catch (com.jaspersoft.jasperserver.remote.exception.AccessDeniedException e) {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getErrorDescriptor()).build();
        }
        catch (RemoteException e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getErrorDescriptor()).build();
        }
        catch (WebApplicationException e) {
            response = e.getResponse();
        }
        return (ResponseType)response;
    }
}

