/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.report;

import com.jaspersoft.jasperserver.api.engine.common.service.SchedulerReportExecutionStatusSearchCriteria;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionHelper;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionRequest;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionStatusEntity;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionsSetWrapper;
import com.jaspersoft.jasperserver.jaxrs.report.ReportsServiceCallTemplate;
import com.jaspersoft.jasperserver.remote.common.AbstractRemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.common.CallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.ExportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportOutputPages;
import com.jaspersoft.jasperserver.remote.services.ReportOutputResource;
import com.jaspersoft.jasperserver.remote.services.RunReportService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
@Path(value="/reportExecutions")
@CallTemplate(value=ReportsServiceCallTemplate.class)
public class ReportExecutionsJaxrsService
extends RemoteServiceWrapper<RunReportService> {
    @Resource(name="runReportService")
    public void setRemoteService(RunReportService remoteService) {
        this.remoteService = remoteService;
    }

    @GET
    @Path(value="/{executionId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getReportExecution(final @PathParam(value="executionId") String executionId) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                return Response.ok((Object)remoteService.getReportExecution(executionId)).build();
            }
        });
    }

    @GET
    @Path(value="/{executionId}/exports/{exportOutput}/outputResource")
    public Response getOutputResource(final @PathParam(value="executionId") String executionId, final @PathParam(value="exportOutput") PathSegment exportOutput) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                ReportOutputResource reportOutputResource = remoteService.getOutputResource(executionId, ReportExecutionsJaxrsService.this.toExecutionId(exportOutput));
                return ReportExecutionHelper.buildResponseFromOutputResource(reportOutputResource);
            }
        });
    }

    @POST
    @Path(value="/{executionId}/exports")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response export(final @PathParam(value="executionId") String executionId, final ExportExecutionOptions exportOptions) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                return Response.ok((Object)remoteService.executeExport(executionId, exportOptions)).build();
            }
        });
    }

    protected ExportExecutionOptions toExecutionId(PathSegment exportOutput) throws IllegalParameterValueException {
        ExportExecutionOptions exportOptions = null;
        if (exportOutput != null) {
            exportOptions = new ExportExecutionOptions();
            exportOptions.setOutputFormat(exportOutput.getPath());
            String pages = (String)exportOutput.getMatrixParameters().getFirst((Object)"pages");
            String attachmentsPrefix = (String)exportOutput.getMatrixParameters().getFirst((Object)"attachmentsPrefix");
            if (pages != null && !pages.isEmpty()) {
                exportOptions.setPages(ReportOutputPages.valueOf((String)pages));
            }
            if (attachmentsPrefix != null && !attachmentsPrefix.isEmpty()) {
                exportOptions.setAttachmentsPrefix(attachmentsPrefix);
            }
        }
        return exportOptions;
    }

    @GET
    @Path(value="/{executionId}/exports/{exportOutput}/attachments/{attachment}")
    public Response getAttachment(final @PathParam(value="executionId") String executionId, final @PathParam(value="exportOutput") PathSegment exportOutput, final @PathParam(value="attachment") String attachmentName) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                ReportOutputResource attachment = remoteService.getAttachment(executionId, ReportExecutionsJaxrsService.this.toExecutionId(exportOutput), attachmentName);
                return ReportExecutionHelper.buildResponseFromOutputResource(attachment);
            }
        });
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getReportsRuntimeInformation(final @QueryParam(value="reportURI") String reportURI, final @QueryParam(value="jobID") String jobID, final @QueryParam(value="jobLabel") String jobLabel, final @QueryParam(value="userName") String userName, final @QueryParam(value="fireTimeFrom") String fireTimeFrom, final @QueryParam(value="fireTimeTo") String fireTimeTo) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                Set currentlyRunningReports;
                SchedulerReportExecutionStatusSearchCriteria criteria = null;
                if (StringUtils.isNotEmpty((String)reportURI) || StringUtils.isNotEmpty((String)jobID) || StringUtils.isNotEmpty((String)jobLabel) || StringUtils.isNotEmpty((String)userName) || StringUtils.isNotEmpty((String)fireTimeFrom) || StringUtils.isNotEmpty((String)fireTimeTo)) {
                    criteria = new SchedulerReportExecutionStatusSearchCriteria();
                    criteria.setReportURI(StringUtils.isNotEmpty((String)reportURI) ? reportURI : null);
                    criteria.setJobLabel(StringUtils.isNotEmpty((String)jobLabel) ? jobLabel : null);
                    criteria.setUserName(StringUtils.isNotEmpty((String)userName) ? userName : null);
                    criteria.setJobID(StringUtils.isNotEmpty((String)jobID) ? Long.valueOf(jobID) : null);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
                    try {
                        criteria.setFireTimeFrom(StringUtils.isNotEmpty((String)fireTimeFrom) ? simpleDateFormat.parse(fireTimeFrom) : null);
                    }
                    catch (ParseException e) {
                        throw new IllegalParameterValueException("fireTimeFrom", fireTimeFrom);
                    }
                    try {
                        criteria.setFireTimeTo(StringUtils.isNotEmpty((String)fireTimeTo) ? simpleDateFormat.parse(fireTimeTo) : null);
                    }
                    catch (ParseException e) {
                        throw new IllegalParameterValueException("fireTimeTo", fireTimeTo);
                    }
                }
                if ((currentlyRunningReports = remoteService.getCurrentlyRunningReports(criteria)) != null && !currentlyRunningReports.isEmpty()) {
                    return Response.ok((Object)new ReportExecutionsSetWrapper(currentlyRunningReports)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        });
    }

    @GET
    @Path(value="/{executionId}/exports/{exportOutput}/status")
    @Produces(value={"application/xml", "application/json"})
    public Response getExportExecutionStatus(final @PathParam(value="executionId") String executionId, final @PathParam(value="exportOutput") PathSegment exportOutput) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                String status = remoteService.getExportExecution(executionId, ReportExecutionsJaxrsService.this.toExecutionId(exportOutput)).getStatus().toString();
                ReportExecutionStatusEntity statusEntity = new ReportExecutionStatusEntity();
                statusEntity.setValue(status);
                return Response.ok((Object)statusEntity).build();
            }
        });
    }

    @GET
    @Path(value="/{executionId}/status")
    @Produces(value={"application/xml", "application/json"})
    public Response getReportExecutionStatus(final @PathParam(value="executionId") String executionId) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                String status = remoteService.getReportExecution(executionId).getStatus().toString();
                ReportExecutionStatusEntity statusEntity = new ReportExecutionStatusEntity();
                statusEntity.setValue(status);
                return Response.ok((Object)statusEntity).build();
            }
        });
    }

    @PUT
    @Path(value="/{executionId}/status")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response cancelReportExecution(final @PathParam(value="executionId") String executionId, ReportExecutionStatusEntity statusEntity) {
        Response response = statusEntity != null && "cancelled".equals(statusEntity.getValue()) ? (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                Boolean cancellationResult = remoteService.cancelReportExecution(executionId);
                return cancellationResult != false ? Response.ok((Object)new ReportExecutionStatusEntity()).build() : Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        }) : Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        return response;
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    public Response getReportOutputMetadata(final ReportExecutionRequest reportExecutionRequest, final @Context HttpServletRequest request) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                ReportExecutionOptions reportExecutionOptions = new ReportExecutionOptions().setIgnorePagination(reportExecutionRequest.getIgnorePagination()).setTransformerKey(reportExecutionRequest.getTransformerKey()).setFreshData(reportExecutionRequest.getFreshData()).setSaveDataSnapshot(reportExecutionRequest.getSaveDataSnapshot()).setInteractive(reportExecutionRequest.getInteractive()).setAsync(reportExecutionRequest.getAsync()).setDefaultAttachmentsPrefixTemplate(ReportExecutionHelper.getDefaultAttachmentsPrefixTemplateFromRequest(request.getRequestURI().replace(request.getContextPath(), "") + "/")).setContextPath(request.getContextPath());
                ExportExecutionOptions exportOptions = new ExportExecutionOptions().setOutputFormat(reportExecutionRequest.getOutputFormat()).setPages(ReportOutputPages.valueOf((String)reportExecutionRequest.getPages())).setAttachmentsPrefix(reportExecutionRequest.getAttachmentsPrefix());
                return Response.ok((Object)remoteService.getReportExecutionFromRawParameters(reportExecutionRequest.getReportUnitUri(), reportExecutionRequest.getParameters() != null ? reportExecutionRequest.getParameters().getRawParameters() : new HashMap(), reportExecutionOptions, exportOptions)).build();
            }
        });
    }
}

