/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.report;

import com.jaspersoft.jasperserver.dto.reports.ReportParameters;
import com.jaspersoft.jasperserver.jaxrs.report.InputControlStateListWrapper;
import com.jaspersoft.jasperserver.jaxrs.report.JsonObjectParametersConverter;
import com.jaspersoft.jasperserver.jaxrs.report.ReportInputControlsListWrapper;
import com.jaspersoft.jasperserver.jaxrs.report.ReportsServiceCallTemplate;
import com.jaspersoft.jasperserver.remote.common.AbstractRemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.common.CallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.exception.ModificationNotAllowedException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlsLogicService;
import com.jaspersoft.jasperserver.war.cascade.InputControlsValidationException;
import com.jaspersoft.jasperserver.war.dto.ReportInputControl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.security.SpringSecurityException;
import org.springframework.stereotype.Service;

@Service
@Path(value="/reports/{reportUnitURI: .+}/inputControls")
@CallTemplate(value=ReportsServiceCallTemplate.class)
public class InputControlsJaxrsService
extends RemoteServiceWrapper<InputControlsLogicService> {
    @Resource(name="inputControlsLogicService")
    public void setRemoteService(InputControlsLogicService remoteService) {
        this.remoteService = remoteService;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getReportInputParameters(@PathParam(value="reportUnitURI") String reportUnitURI, @Context HttpServletRequest request) {
        Map rawParameters = request.getParameterMap();
        return this.internalGetReportInputParameters(reportUnitURI, null, rawParameters);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getReportInputParametersViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, JSONObject jsonParameters) {
        return this.internalGetReportInputParameters(reportUnitURI, null, JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response getReportInputParametersViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, ReportParameters parameters) {
        return this.internalGetReportInputParameters(reportUnitURI, null, parameters.getRawParameters());
    }

    protected Response internalGetReportInputParameters(final String reportUnitUri, final Set<String> inputControlIds, final Map<String, String[]> rawParameters) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(InputControlsLogicService remoteService) throws RemoteException {
                List inputControlsForReport;
                try {
                    inputControlsForReport = remoteService.getInputControlsWithValues("/" + reportUnitUri, inputControlIds, rawParameters);
                }
                catch (CascadeResourceNotFoundException e) {
                    throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
                }
                if (inputControlsForReport != null && !inputControlsForReport.isEmpty()) {
                    return Response.ok((Object)new ReportInputControlsListWrapper(inputControlsForReport)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        });
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response reorderInputControls(final @PathParam(value="reportUnitURI") String reportUnitURI, final ReportInputControlsListWrapper toUpdateWrapper) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(InputControlsLogicService remoteService) throws RemoteException {
                List updated;
                List<ReportInputControl> toUpdate = toUpdateWrapper.getInputParameters();
                ArrayList<String> newList = new ArrayList<String>(toUpdate.size());
                for (ReportInputControl control : toUpdate) {
                    newList.add(control.getId());
                }
                try {
                    updated = remoteService.reorderInputControls("/" + reportUnitURI, newList);
                }
                catch (CascadeResourceNotFoundException e) {
                    throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
                }
                catch (SpringSecurityException spe) {
                    throw new ModificationNotAllowedException("");
                }
                catch (InputControlsValidationException e) {
                    throw new ModificationNotAllowedException(new ErrorDescriptor.Builder().setMessage("Malformed data").setParameters(new Object[]{e.getErrors()}).getErrorDescriptor());
                }
                return Response.ok((Object)new ReportInputControlsListWrapper(updated)).build();
            }
        });
    }

    @GET
    @Path(value="/{inputControlIds: [^;/]+(;[^;/]+)*}")
    @Produces(value={"application/xml", "application/json"})
    public Response getReportInputParametersForSpecifiedInputControls(@PathParam(value="reportUnitURI") String reportUnitURI, @PathParam(value="inputControlIds") PathSegment inputControlIds, @Context HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return this.internalGetReportInputParameters(reportUnitURI, this.getInputControlIdsFromPathSegment(inputControlIds), parameterMap);
    }

    @POST
    @Path(value="/{inputControlIds: [^;/]+(;[^;/]+)*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getReportInputParametersForSpecifiedInputControlsViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, @PathParam(value="inputControlIds") PathSegment inputControlIds, JSONObject jsonParameters) {
        return this.internalGetReportInputParameters(reportUnitURI, this.getInputControlIdsFromPathSegment(inputControlIds), JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    @POST
    @Path(value="/{inputControlIds: [^;/]+(;[^;/]+)*}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response getReportInputParametersForSpecifiedInputControlsViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, @PathParam(value="inputControlIds") PathSegment inputControlIds, ReportParameters parameters) {
        return this.internalGetReportInputParameters(reportUnitURI, this.getInputControlIdsFromPathSegment(inputControlIds), parameters.getRawParameters());
    }

    @GET
    @Path(value="/values")
    @Produces(value={"application/xml", "application/json"})
    public Response getInputControlsInitialValues(@PathParam(value="reportUnitURI") String reportUnitURI, @Context HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return this.internalGetInputControlsInitialValues(reportUnitURI, parameterMap);
    }

    @POST
    @Path(value="/values")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInputControlsInitialValuesViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, JSONObject jsonParameters) {
        return this.internalGetInputControlsInitialValues(reportUnitURI, JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    @POST
    @Path(value="/values")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response getInputControlsInitialValuesViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, ReportParameters parameters) {
        return this.internalGetInputControlsInitialValues(reportUnitURI, parameters.getRawParameters());
    }

    protected Response internalGetInputControlsInitialValues(final String reportUnitURI, final Map<String, String[]> parameters) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(InputControlsLogicService remoteService) throws RemoteException {
                List values;
                String completeInputControlUri = "/" + reportUnitURI;
                try {
                    values = remoteService.getValuesForInputControls(completeInputControlUri, null, parameters);
                }
                catch (CascadeResourceNotFoundException e) {
                    throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
                }
                if (values != null && !values.isEmpty()) {
                    return Response.ok((Object)new InputControlStateListWrapper(values)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)("No input controls values found for the report /" + reportUnitURI)).build();
            }
        });
    }

    @GET
    @Path(value="/{inputControlIds: [^;/]+(;[^;/]+)*}/values")
    @Produces(value={"application/xml", "application/json"})
    public Response getReportInputControlValues(@PathParam(value="reportUnitURI") String reportUnitUri, @PathParam(value="inputControlIds") PathSegment inputControlIds, @Context HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return this.internalGetInputControlValues("/" + reportUnitUri, inputControlIds, parameterMap);
    }

    @POST
    @Path(value="/{inputControlIds: [^;/]+(;[^;/]+)*}/values")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getReportInputControlValuesViaPost(@PathParam(value="reportUnitURI") String reportUnitUri, @PathParam(value="inputControlIds") PathSegment inputControlIds, JSONObject jsonParameters) {
        return this.internalGetInputControlValues("/" + reportUnitUri, inputControlIds, JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    @POST
    @Path(value="/{inputControlIds: [^;/]+(;[^;/]+)*}/values")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response getReportInputControlValuesViaPost(@PathParam(value="reportUnitURI") String reportUnitUri, @PathParam(value="inputControlIds") PathSegment inputControlIds, ReportParameters parameters) {
        return this.internalGetInputControlValues("/" + reportUnitUri, inputControlIds, parameters.getRawParameters());
    }

    protected Response internalGetInputControlValues(final String reportUnitUri, final PathSegment inputControlIdsSegment, final Map<String, String[]> parameters) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(InputControlsLogicService remoteService) throws RemoteException {
                List values;
                try {
                    values = remoteService.getValuesForInputControls(reportUnitUri, InputControlsJaxrsService.this.getInputControlIdsFromPathSegment(inputControlIdsSegment), parameters);
                }
                catch (CascadeResourceNotFoundException e) {
                    throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
                }
                if (values != null && !values.isEmpty()) {
                    return Response.ok((Object)new InputControlStateListWrapper(values)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)("No input controls values found for the report /" + reportUnitUri)).build();
            }
        });
    }

    protected Set<String> getInputControlIdsFromPathSegment(PathSegment inputControlIdsSegment) {
        HashSet<String> inputControlIds = new HashSet<String>();
        inputControlIds.add(inputControlIdsSegment.getPath());
        for (String currentId : inputControlIdsSegment.getMatrixParameters().keySet()) {
            inputControlIds.add(currentId);
        }
        return inputControlIds;
    }
}

