/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.job;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceCallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceInTemplateCaller;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.services.JobsService;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.AccessDeniedException;

public class JobsServiceCallTemplate
implements RemoteServiceCallTemplate<JobsService> {
    private static final Log log = LogFactory.getLog(JobsServiceCallTemplate.class);

    public <ResponseType> ResponseType callRemoteService(RemoteServiceInTemplateCaller<ResponseType, JobsService> caller, JobsService service) {
        Response response = null;
        Throwable exceptionToLog = null;
        Response.Status status = Response.Status.BAD_REQUEST;
        ValidationErrors entity = null;
        try {
            response = (Response)caller.call((Object)service);
        }
        catch (ReportJobNotFoundException e) {
            status = Response.Status.NOT_FOUND;
            entity = new ResourceNotFoundException("" + e.getJobId()).getErrorDescriptor();
        }
        catch (AccessDeniedException e) {
            status = Response.Status.FORBIDDEN;
            entity = new ErrorDescriptor.Builder().setErrorCode("access.denied").setMessage(e.getMessage()).getErrorDescriptor();
        }
        catch (JSValidationException e) {
            entity = e.getErrors();
        }
        catch (RemoteException e) {
            entity = e.getErrorDescriptor();
            if (e.isUnexpected().booleanValue()) {
                exceptionToLog = e;
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        catch (Exception e) {
            ErrorDescriptor errorDescriptor = new ErrorDescriptor.Builder().setErrorCode("unexpected.error").setParameters(new String[]{e.getClass().getName()}).getErrorDescriptor();
            if (e.getMessage() != null) {
                errorDescriptor.setMessage(e.getMessage());
            }
            entity = errorDescriptor;
            exceptionToLog = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (exceptionToLog != null) {
            log.error((Object)"Unexpected error occurs", exceptionToLog);
        }
        return (ResponseType)(entity != null ? Response.status((Response.Status)status).entity((Object)entity).build() : response);
    }
}

