/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.importexport;

import com.jaspersoft.jasperserver.export.service.ImportExportService;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.async.BaseImportExportTaskRunnable;
import com.jaspersoft.jasperserver.remote.services.async.ImportExportTask;
import com.jaspersoft.jasperserver.remote.services.async.ImportRunnable;
import com.jaspersoft.jasperserver.remote.services.async.StateDto;
import com.jaspersoft.jasperserver.remote.services.async.Task;
import com.jaspersoft.jasperserver.remote.services.async.TasksManager;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
@Path(value="/import")
public class ImportJaxrsService {
    private static final Log log = LogFactory.getLog(ImportJaxrsService.class);
    @Resource
    private ImportExportService synchImportExportService;
    @Resource
    private TasksManager basicTaskManager;
    @Resource
    private MessageSource messageSource;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml", "application/json"})
    public Response handleMultipartUpload(@FormDataParam(value="file") InputStream stream, @DefaultValue(value="true") @FormDataParam(value="update") Boolean update, @DefaultValue(value="true") @FormDataParam(value="skip-user-update") Boolean skipUserUpdate, @DefaultValue(value="true") @FormDataParam(value="include-audit-events") Boolean includeAuditEvents, @DefaultValue(value="true") @FormDataParam(value="include-access-events") Boolean includeAccessEvents, @DefaultValue(value="true") @FormDataParam(value="include-monitoring-events") Boolean includeMonitoringEvents, @DefaultValue(value="true") @FormDataParam(value="include-server-settings") Boolean includeSettings) throws Exception {
        return this.handleUpload(stream, update == false, skipUserUpdate == false, includeAuditEvents == false, includeAccessEvents == false, includeMonitoringEvents == false, includeSettings == false);
    }

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/xml", "application/json"})
    public Response handleDirectUpload(InputStream stream, @DefaultValue(value="false") @QueryParam(value="update") Boolean update, @DefaultValue(value="false") @QueryParam(value="skipUserUpdate") Boolean skipUserUpdate, @DefaultValue(value="false") @QueryParam(value="includeAuditEvents") Boolean includeAuditEvents, @DefaultValue(value="false") @QueryParam(value="includeAccessEvents") Boolean includeAccessEvents, @DefaultValue(value="false") @QueryParam(value="includeMonitoringEvents") Boolean includeMonitoringEvents, @DefaultValue(value="false") @QueryParam(value="includeServerSettings") Boolean includeSettings) throws Exception {
        return this.handleUpload(stream, update, skipUserUpdate, includeAuditEvents, includeAccessEvents, includeMonitoringEvents, includeSettings);
    }

    protected Response handleUpload(InputStream stream, Boolean update, Boolean skipUserUpdate, Boolean includeAuditEvents, Boolean includeAccessEvents, Boolean includeMonitoringEvents, Boolean includeSettings) throws Exception {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("update", update);
        params.put("skip-user-update", skipUserUpdate);
        params.put("include-audit-events", includeAuditEvents);
        params.put("include-access-events", includeAccessEvents);
        params.put("include-monitoring-events", includeMonitoringEvents);
        params.put("include-server-settings", includeSettings);
        if (log.isDebugEnabled()) {
            log.debug((Object)new StringBuffer().append("Request to start import is: \n").append(StringUtils.join(params.entrySet(), (String)"\n")).toString());
        }
        ImportRunnable importRunner = new ImportRunnable(params, stream);
        importRunner.setService(this.synchImportExportService);
        importRunner.setMessageSource(this.messageSource);
        this.basicTaskManager.startTask((Task)new ImportExportTask((BaseImportExportTaskRunnable)importRunner));
        return Response.ok((Object)importRunner.getState()).build();
    }

    @GET
    @Path(value="/{id}/state")
    @Produces(value={"application/xml", "application/json"})
    public Response getStateOfTheTask(@PathParam(value="id") String taskId) throws RemoteException {
        StateDto taskState = this.basicTaskManager.getTaskState(taskId);
        if (!taskState.getPhase().equals("inprogress")) {
            this.basicTaskManager.finishTask(taskId);
        }
        return Response.ok((Object)taskState).build();
    }
}

