/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.importexport;

import com.jaspersoft.jasperserver.export.service.ImportExportService;
import com.jaspersoft.jasperserver.jaxrs.importexport.ExportTaskDto;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.async.BaseImportExportTaskRunnable;
import com.jaspersoft.jasperserver.remote.services.async.ExportRunnable;
import com.jaspersoft.jasperserver.remote.services.async.ImportExportTask;
import com.jaspersoft.jasperserver.remote.services.async.Task;
import com.jaspersoft.jasperserver.remote.services.async.TasksManager;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
@Path(value="/export")
public class ExportJaxrsService {
    @Resource
    private ImportExportService synchImportExportService;
    @Resource
    private TasksManager basicTaskManager;
    @Resource
    private MessageSource messageSource;

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createNewTask(ExportTaskDto data) throws RemoteException {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        if (data.getParameters() != null) {
            for (String par : data.getParameters()) {
                params.put(par, true);
            }
        }
        ExportRunnable exportRunnable = new ExportRunnable(params, data.getUris(), data.getScheduledJobs(), data.getRoles(), data.getUsers());
        exportRunnable.setService(this.synchImportExportService);
        exportRunnable.setMessageSource(this.messageSource);
        this.basicTaskManager.startTask((Task)new ImportExportTask((BaseImportExportTaskRunnable)exportRunnable));
        return Response.ok((Object)exportRunnable.getState()).build();
    }

    @GET
    @Path(value="/{id}/state")
    @Produces(value={"application/xml", "application/json"})
    public Response getStateOfTheTask(@PathParam(value="id") String taskId) throws RemoteException {
        return Response.ok((Object)this.basicTaskManager.getTaskState(taskId)).build();
    }

    @GET
    @Path(value="/{id}/{name}")
    @Produces(value={"application/zip"})
    public Response downloadFile(@PathParam(value="id") String taskId, @PathParam(value="name") String name) throws RemoteException {
        Response response = Response.ok((Object)this.basicTaskManager.getTask(taskId).getResult()).build();
        this.basicTaskManager.finishTask(taskId);
        return response;
    }
}

