/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.common;

import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.builders.LocalizedErrorDescriptorBuilder;
import javax.annotation.Resource;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class GenericRemoteExceptionMapper
implements ExceptionMapper<RemoteException> {
    private static final Log log = LogFactory.getLog(GenericRemoteExceptionMapper.class);
    @Resource(name="localizedErrorDescriptorBuilder")
    private LocalizedErrorDescriptorBuilder builder;

    public Response toResponse(RemoteException exception) {
        Response.Status status = Response.Status.BAD_REQUEST;
        if (exception.isUnexpected().booleanValue()) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
            log.error((Object)"Unexpected error occurs", (Throwable)exception);
        }
        return Response.status((Response.Status)status).entity((Object)this.builder.localizeDescriptor(exception.getErrorDescriptor())).build();
    }
}

