/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.authority;

import com.jaspersoft.jasperserver.dto.authority.ClientUser;
import com.jaspersoft.jasperserver.dto.authority.ClientUserAttribute;
import com.jaspersoft.jasperserver.dto.authority.UserAttributesListWrapper;
import com.jaspersoft.jasperserver.jaxrs.authority.UsersJaxrsService;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/users")
public class UsersJaxrsServiceWrapper {
    @Resource(name="usersJaxrsService")
    private UsersJaxrsService service;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getUsers(@QueryParam(value="offset") Integer startIndex, @QueryParam(value="limit") Integer limit, @QueryParam(value="maxRecords") int maxRecords, @QueryParam(value="subOrgId") String tenantId, @QueryParam(value="includeSubOrgs") Boolean includeSubOrgs, @QueryParam(value="hasAllRequiredRoles") Boolean hasAllRequiredRoles, @QueryParam(value="search") String search, @QueryParam(value="q") String q, @QueryParam(value="requiredRole") List<String> requredRoleNames) throws RemoteException {
        if (q != null) {
            search = q;
        }
        if (limit != null) {
            maxRecords = limit;
        }
        return this.service.getUsers(startIndex == null ? 0 : startIndex, maxRecords, tenantId, includeSubOrgs, hasAllRequiredRoles, search, requredRoleNames);
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response getPropertiesOfUser(@PathParam(value="name") String name) throws RemoteException {
        return this.service.getPropertiesOfUser(name, null);
    }

    @PUT
    @Path(value="/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response putUser(ClientUser clientUser, @PathParam(value="name") String name) throws RemoteException {
        if (clientUser.getTenantId() != null && clientUser.getTenantId() != "") {
            throw new IllegalParameterValueException("tenantId", clientUser.getTenantId());
        }
        return this.service.putUser(clientUser, name, null);
    }

    @DELETE
    @Path(value="/{name}")
    public Response deleteUser(@PathParam(value="name") String name) throws RemoteException {
        return this.service.deleteUser(name, null);
    }

    @GET
    @Path(value="/{name}/attributes")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttributesOfUser(@PathParam(value="name") String name, @QueryParam(value="name") Set<String> attrNames, @QueryParam(value="offset") Integer startIndex, @QueryParam(value="limit") Integer limit) throws RemoteException {
        return this.service.getAttributesOfUser(startIndex == null ? 0 : startIndex, limit == null ? 0 : limit, name, null, attrNames);
    }

    @PUT
    @Path(value="/{name}/attributes")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response putAttributes(UserAttributesListWrapper newCollection, @PathParam(value="name") String name) throws RemoteException {
        return this.service.putAttributes(newCollection.getProfileAttributes(), name, null);
    }

    @DELETE
    @Path(value="/{name}/attributes")
    public Response deleteAttributes(@PathParam(value="name") String name, @QueryParam(value="name") Set<String> attrNames) throws RemoteException {
        return this.service.deleteAttributes(name, null, attrNames);
    }

    @GET
    @Path(value="/{name}/attributes/{attrName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getSpecificAttributeOfUser(@PathParam(value="name") String name, @PathParam(value="attrName") String attrName) throws RemoteException {
        return this.service.getSpecificAttributeOfUser(name, null, attrName);
    }

    @PUT
    @Path(value="/{name}/attributes/{attrName}")
    @Produces(value={"application/xml", "application/json"})
    public Response putAttribute(ClientUserAttribute attr, @PathParam(value="name") String name, @PathParam(value="attrName") String attrName) throws RemoteException {
        return this.service.putAttribute(attr, name, null, attrName);
    }

    @DELETE
    @Path(value="/{name}/attributes/{attrName}")
    public Response deleteAttribute(@PathParam(value="name") String name, @PathParam(value="attrName") String attrName) throws RemoteException {
        return this.service.deleteAttribute(name, null, attrName);
    }
}

