/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.authority;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ProfileAttributeImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.dto.authority.ClientUser;
import com.jaspersoft.jasperserver.dto.authority.ClientUserAttribute;
import com.jaspersoft.jasperserver.dto.authority.UserAttributesListWrapper;
import com.jaspersoft.jasperserver.jaxrs.authority.UsersListWrapper;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.common.UserSearchCriteria;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceAlreadyExistsException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.converters.UserAttributesConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.UserConverter;
import com.jaspersoft.jasperserver.remote.services.GenericAttributesService;
import com.jaspersoft.jasperserver.remote.services.UserAndRoleService;
import com.jaspersoft.jasperserver.remote.services.impl.UserAndRoleServiceImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.ws.rs.core.Response;

public class UsersJaxrsService {
    @Resource
    private UserConverter userConverter;
    @Resource
    private UserAttributesConverter userAttributesConverter;
    private UserAndRoleService service;
    private GenericAttributesService<User> attributesService;
    private int maxLengthAttrName = 255;
    private int maxLengthAttrValue = 255;
    private Pattern empty = Pattern.compile("^\\s*$");

    public Response getUsers(int startIndex, int maxRecords, String tenantId, Boolean includeSubOrgs, Boolean hasAllRequiredRoles, String search, List<String> requredRoleNames) throws RemoteException {
        List<User> users;
        int totalCount;
        UserSearchCriteria criteria = new UserSearchCriteria();
        criteria.setIncludeSubOrgs(includeSubOrgs);
        criteria.setName(search == null ? "" : search);
        criteria.setTenantId("".equals(tenantId) ? null : tenantId);
        criteria.setHasAllRequiredRoles(Boolean.valueOf(hasAllRequiredRoles == null ? true : hasAllRequiredRoles));
        if (requredRoleNames != null && requredRoleNames.size() > 0) {
            LinkedList<Role> roles = new LinkedList<Role>();
            for (String name : requredRoleNames) {
                Role found = this.findRole(name);
                if (found == null) {
                    throw new ResourceNotFoundException(name);
                }
                roles.add(found);
            }
            criteria.setRequiredRoles(roles);
        }
        if ((totalCount = (users = this.service.findUsers(criteria)).size()) < startIndex) {
            users.clear();
        } else if (maxRecords != 0) {
            users = startIndex + maxRecords > totalCount ? users.subList(startIndex, totalCount) : users.subList(startIndex, startIndex + maxRecords);
        } else if (startIndex > 0) {
            users = users.subList(startIndex, totalCount);
        }
        Response response = users.size() == 0 ? Response.status((Response.Status)Response.Status.NO_CONTENT).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)users.size()).header("Total-Count", (Object)totalCount).build() : Response.ok().entity((Object)new UsersListWrapper(users)).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)users.size()).header("Total-Count", (Object)totalCount).build();
        return response;
    }

    public Response putUsers() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public Response createUser(ClientUser clientUser) throws RemoteException {
        if (this.findUser(clientUser.getUsername(), clientUser.getTenantId()) != null) {
            throw new ResourceAlreadyExistsException(clientUser.getUsername());
        }
        User created = this.service.putUser(this.userConverter.toServer(clientUser));
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.userConverter.toClient(created)).build();
    }

    public Response deleteUsers() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public Response getPropertiesOfUser(String name, String tenantId) throws RemoteException {
        User user = this.findUser(name, tenantId);
        if (user != null) {
            return Response.ok((Object)this.userConverter.toClient(user)).build();
        }
        throw new ResourceNotFoundException(name);
    }

    public Response putUser(ClientUser clientUser, String name, String tenantId) throws RemoteException {
        User user = this.findUser(name, tenantId);
        Response.Status status = Response.Status.OK;
        if (user == null) {
            status = Response.Status.CREATED;
            user = new UserImpl();
        }
        user = this.userConverter.toServer(clientUser, user);
        user.setUsername(name);
        user.setTenantId(tenantId);
        return Response.status((Response.Status)status).entity((Object)this.userConverter.toClient(this.service.putUser(user))).build();
    }

    public Response postToUser(String name) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public Response deleteUser(String name, String tenantId) throws RemoteException {
        User user = this.findUser(name, tenantId);
        if (user == null) {
            throw new ResourceNotFoundException(name);
        }
        this.service.deleteUser(user);
        return Response.noContent().build();
    }

    public Response getAttributesOfUser(int startIndex, int maxRecords, String name, String tenantId, Set<String> attrNames) throws RemoteException {
        List<ProfileAttribute> attributes;
        UserImpl user = new UserImpl();
        user.setUsername(name);
        user.setTenantId("".equals(tenantId) ? null : tenantId);
        try {
            attributes = this.getAttributes((User)user, attrNames);
        }
        catch (ServiceException se) {
            throw new ResourceNotFoundException(name);
        }
        int totalCount = attributes.size();
        if (totalCount < startIndex) {
            attributes.clear();
        } else if (maxRecords != 0) {
            attributes = startIndex + maxRecords > totalCount ? attributes.subList(startIndex, totalCount) : attributes.subList(startIndex, startIndex + maxRecords);
        } else if (startIndex > 0) {
            attributes = attributes.subList(startIndex, totalCount);
        }
        ArrayList<ClientUserAttribute> clientUserAttributes = new ArrayList<ClientUserAttribute>(attributes.size());
        for (ProfileAttribute pa : attributes) {
            clientUserAttributes.add(this.userAttributesConverter.toClient(pa));
        }
        Response response = attributes.size() == 0 ? Response.status((Response.Status)Response.Status.NO_CONTENT).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)attributes.size()).header("Total-Count", (Object)totalCount).build() : Response.ok().entity((Object)new UserAttributesListWrapper(clientUserAttributes)).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)attributes.size()).header("Total-Count", (Object)totalCount).build();
        return response;
    }

    public Response putAttributes(List<ClientUserAttribute> newCollection, String name, String tenantId) throws RemoteException {
        for (ClientUserAttribute pa : newCollection) {
            if (this.isEmpty(pa.getName()) || pa.getName().length() > this.maxLengthAttrName) {
                throw new IllegalParameterValueException("name", pa.getName());
            }
            if (!this.isEmpty(pa.getValue()) && pa.getValue().length() <= this.maxLengthAttrValue) continue;
            throw new IllegalParameterValueException("value", pa.getValue());
        }
        User user = this.findUser(name, tenantId);
        if (user == null) {
            throw new ResourceNotFoundException(name);
        }
        List<ProfileAttribute> oldCollection = this.getAttributes(user, null);
        for (ProfileAttribute profileAttribute : oldCollection) {
            this.attributesService.deleteAttribute((Object)user, profileAttribute);
        }
        for (ClientUserAttribute clientUserAttribute : newCollection) {
            this.attributesService.putAttribute((Object)user, this.userAttributesConverter.toServer(clientUserAttribute));
        }
        return Response.ok().build();
    }

    public Response addAttribute(ClientUserAttribute clientUserAttribute, String name, String tenantId) throws RemoteException {
        ProfileAttribute pa = this.userAttributesConverter.toServer(clientUserAttribute);
        User user = this.findUser(name, tenantId);
        if (user == null) {
            throw new ResourceNotFoundException(name);
        }
        if (this.attributesService.getAttribute((Object)user, pa.getAttrName()) != null) {
            throw new ResourceAlreadyExistsException(pa.getAttrName());
        }
        this.attributesService.putAttribute((Object)user, pa);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)pa).build();
    }

    public Response deleteAttributes(String name, String tenantId, Set<String> attrNames) throws RemoteException {
        User user = this.findUser(name, tenantId);
        if (user == null) {
            throw new ResourceNotFoundException(name);
        }
        List<ProfileAttribute> list = this.getAttributes(user, attrNames);
        for (ProfileAttribute pa : list) {
            this.attributesService.deleteAttribute((Object)user, pa);
        }
        return Response.noContent().build();
    }

    public Response getSpecificAttributeOfUser(String name, String tenantId, String attrName) throws RemoteException {
        ArrayList attributes = new ArrayList(1);
        UserImpl user = new UserImpl();
        user.setUsername(name);
        user.setTenantId("".equals(tenantId) ? null : tenantId);
        ProfileAttribute attribute = null;
        try {
            attribute = this.attributesService.getAttribute((Object)user, attrName);
        }
        catch (JSException np) {
            throw new ResourceNotFoundException(name, (Throwable)np);
        }
        if (attribute == null) {
            throw new ResourceNotFoundException(attrName);
        }
        return Response.ok((Object)this.userAttributesConverter.toClient(attribute)).build();
    }

    public Response putAttribute(ClientUserAttribute clientUserAttribute, String name, String tenantId, String attrName) throws RemoteException {
        Response.Status status = Response.Status.OK;
        ProfileAttribute attr = this.userAttributesConverter.toServer(clientUserAttribute);
        if (attr.getAttrName() == null) {
            attr.setAttrName(attrName);
        } else if (this.isEmpty(attr.getAttrName())) {
            throw new IllegalParameterValueException("name", "<empty>");
        }
        User user = this.findUser(name, tenantId);
        if (user == null) {
            throw new ResourceNotFoundException(name);
        }
        if (attrName.equals(attr.getAttrName())) {
            if (this.isEmpty(attr.getAttrValue())) {
                throw new IllegalParameterValueException("value", "<empty>");
            }
            if (this.attributesService.getAttribute((Object)user, attr.getAttrName()) == null) {
                status = Response.Status.CREATED;
            }
            this.attributesService.putAttribute((Object)user, attr);
        } else {
            ProfileAttribute existing = this.attributesService.getAttribute((Object)user, attrName);
            if (existing == null) {
                throw new ResourceNotFoundException(attrName);
            }
            if (attr.getAttrValue() == null) {
                attr.setAttrValue(existing.getAttrValue());
            }
            this.attributesService.putAttribute((Object)user, attr);
            this.attributesService.deleteAttribute((Object)user, existing);
        }
        return Response.status((Response.Status)status).build();
    }

    public Response postToAttribute(String name, String attrName) throws RemoteException {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public Response deleteAttribute(String name, String tenantId, String attrName) throws RemoteException {
        User user = this.findUser(name, tenantId);
        if (user == null) {
            throw new ResourceNotFoundException(name);
        }
        ProfileAttributeImpl dto = new ProfileAttributeImpl();
        dto.setAttrName(attrName);
        try {
            this.attributesService.deleteAttribute((Object)user, (ProfileAttribute)dto);
        }
        catch (ServiceException se) {
            if (se.getErrorCode() == 404) {
                throw new ResourceNotFoundException(attrName);
            }
            throw se;
        }
        return Response.noContent().build();
    }

    private User findUser(String name, String tenantId) throws RemoteException {
        UserSearchCriteria criteria = new UserSearchCriteria();
        criteria.setName(name);
        criteria.setTenantId("".equals(tenantId) ? null : tenantId);
        try {
            List found = this.service.findUsers(criteria);
            for (User user : found) {
                if (!this.requestedUser(user, name, tenantId)) continue;
                return user;
            }
        }
        catch (IllegalStateException ise) {
            throw new IllegalParameterValueException("username", "null");
        }
        return null;
    }

    private boolean requestedUser(User user, String name, String tenantId) {
        return user.getUsername().equals(name) && (user.getTenantId() == null && tenantId == null || user.getTenantId() != null && user.getTenantId().equals(tenantId));
    }

    private List<ProfileAttribute> getAttributes(User user, Set<String> attrNames) throws RemoteException {
        LinkedList<ProfileAttribute> needed;
        LinkedList<ProfileAttribute> found = this.attributesService.getAttributes((Object)user);
        if (attrNames != null && !attrNames.isEmpty()) {
            needed = new LinkedList<ProfileAttribute>();
            for (ProfileAttribute pa : found) {
                if (!attrNames.contains(pa.getAttrName())) continue;
                needed.add(pa);
            }
        } else {
            needed = found;
        }
        return needed;
    }

    private boolean isEmpty(String val) {
        return val == null || this.empty.matcher(val).matches();
    }

    private Role findRole(String name) throws RemoteException {
        return ((UserAndRoleServiceImpl)this.service).getUserAuthorityService().getRole(null, name);
    }

    public UserAndRoleService getService() {
        return this.service;
    }

    public void setService(UserAndRoleService service) {
        this.service = service;
    }

    public GenericAttributesService<User> getAttributesService() {
        return this.attributesService;
    }

    public void setAttributesService(GenericAttributesService<User> attributesService) {
        this.attributesService = attributesService;
    }

    public int getMaxLengthAttrName() {
        return this.maxLengthAttrName;
    }

    public void setMaxLengthAttrName(int maxLengthAttrName) {
        this.maxLengthAttrName = maxLengthAttrName;
    }

    public int getMaxLengthAttrValue() {
        return this.maxLengthAttrValue;
    }

    public void setMaxLengthAttrValue(int maxLengthAttrValue) {
        this.maxLengthAttrValue = maxLengthAttrValue;
    }
}

