/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.util.Map;
import nux.xom.pool.Pool;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.XOMUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

class FullTextPool {
    private static final long DEFAULT_CAPACITY = XOMUtil.getSystemProperty("nux.xom.pool.FullTextPool.capacity", 0x2800000L);
    private static final String FIELD_NAME = "f";
    public static final FullTextPool GLOBAL_POOL = new FullTextPool();
    private final Map entries;

    public FullTextPool() {
        this(FullTextPool.createConfig());
    }

    public FullTextPool(PoolConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.entries = Pool.createPool(config);
    }

    private static PoolConfig createConfig() {
        PoolConfig config = new PoolConfig();
        config.setMaxIdleTime(30000L);
        long capacity = Runtime.getRuntime().maxMemory() / 5L;
        capacity = Math.min(capacity, DEFAULT_CAPACITY);
        config.setCapacity(capacity);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float match(String text, String query, Analyzer textAnalyzer, Analyzer queryAnalyzer) throws ParseException {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query expression must not be null");
        }
        if (textAnalyzer == null) {
            throw new IllegalArgumentException("textAnalyzer must not be null");
        }
        if (queryAnalyzer == null) {
            throw new IllegalArgumentException("queryAnalyzer must not be null");
        }
        if (DEFAULT_CAPACITY <= 0L) {
            MemoryIndex index = new MemoryIndex();
            index.addField(FIELD_NAME, text, textAnalyzer);
            return index.search(this.parse(query, queryAnalyzer));
        }
        Object key = Pool.createHashKeys(new Object[]{text, query, textAnalyzer, queryAnalyzer});
        Float score = (Float)this.entries.get(key);
        if (score == null) {
            Object qkey = Pool.createHashKeys(new Object[]{query, queryAnalyzer});
            Query luceneQuery = (Query)this.entries.get(qkey);
            if (luceneQuery == null) {
                luceneQuery = this.parse(query, queryAnalyzer);
                this.entries.put(qkey, luceneQuery);
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = text;
            objectArray[1] = textAnalyzer;
            Object tkey = Pool.createHashKeys(objectArray);
            MemoryIndex index = (MemoryIndex)this.entries.get(tkey);
            if (index == null) {
                index = new MemoryIndex();
                index.addField(FIELD_NAME, text, textAnalyzer);
                this.entries.put(tkey, index);
            }
            Query query2 = luceneQuery;
            synchronized (query2) {
                score = new Float(index.search(luceneQuery));
            }
            this.entries.put(key, score);
        }
        return score.floatValue();
    }

    private Query parse(String query, Analyzer analyzer) throws ParseException {
        QueryParser parser = new QueryParser(FIELD_NAME, analyzer);
        return parser.parse(query);
    }
}

