/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ContentResourceURIResolver;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ExceptionInfo;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.MemoryDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ReportExecutionJobMailNotificationImpl
implements ReportExecutionJobMailNotification {
    private static final Log log = LogFactory.getLog(ReportExecutionJobMailNotificationImpl.class);

    @Override
    public void sendMailNotification(ReportExecutionJob job, ReportJob jobDetails, List reportOutputs) throws JobExecutionException {
        ReportJobMailNotification mailNotification = jobDetails.getMailNotification();
        if (mailNotification != null) {
            try {
                if (mailNotification.isSkipNotificationWhenJobFails() && !job.exceptions.isEmpty()) {
                    return;
                }
                JavaMailSender mailSender = job.getMailSender();
                String fromAddress = job.getFromAddress();
                MimeMessage message = mailSender.createMimeMessage();
                MimeMessageHelper messageHelper = new MimeMessageHelper(message, true, job.getCharacterEncoding());
                messageHelper.setFrom(fromAddress);
                messageHelper.setSubject(mailNotification.getSubject());
                StringBuffer messageText = new StringBuffer();
                this.addMailRecipients(mailNotification, messageHelper);
                boolean isEmailBodyOccupied = false;
                if (reportOutputs != null && !reportOutputs.isEmpty()) {
                    byte resultSendType = jobDetails.getMailNotification().getResultSendType();
                    if (resultSendType == 4) {
                        for (ReportOutput output : reportOutputs) {
                            if (!isEmailBodyOccupied && output.getFileType().equals("html") && job.exceptions.isEmpty()) {
                                this.embedOutput(messageHelper, output);
                                isEmailBodyOccupied = true;
                                continue;
                            }
                            this.attachOutput(job, messageHelper, output, resultSendType == 2);
                        }
                    } else if (resultSendType == 2 || resultSendType == 3) {
                        for (ReportOutput output : reportOutputs) {
                            this.attachOutput(job, messageHelper, output, resultSendType == 2);
                        }
                    } else {
                        this.appendRepositoryLinks(job, messageText, reportOutputs);
                    }
                }
                if (mailNotification.isIncludingStackTraceWhenJobFails() && !job.exceptions.isEmpty()) {
                    for (ExceptionInfo exception : job.exceptions) {
                        messageText.append("\n");
                        messageText.append(exception.getMessage());
                        ReportExecutionJobMailNotificationImpl.attachException(messageHelper, exception);
                    }
                }
                String text = mailNotification.getMessageText();
                if (!job.exceptions.isEmpty()) {
                    text = mailNotification.getMessageTextWhenJobFails() != null ? mailNotification.getMessageTextWhenJobFails() : job.getMessage("report.scheduling.job.default.mail.notification.message.on.fail", null);
                }
                if (!isEmailBodyOccupied) {
                    messageHelper.setText(text + "\n" + messageText.toString());
                }
                mailSender.send(message);
            }
            catch (MessagingException e) {
                log.error((Object)"Error while sending report job result mail", (Throwable)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
    }

    protected void appendRepositoryLinks(ReportExecutionJob job, StringBuffer notificationMessage, List reportOutputs) {
        if (reportOutputs != null && !reportOutputs.isEmpty()) {
            String preamble = job.getMessage("report.scheduling.notification.repository.links.preamble", null);
            notificationMessage.append(preamble);
            String linkDescription = job.getRepositoryLinkDescription();
            ContentResourceURIResolver contentResourceURIResolver = job.getContentResourceURIResolver();
            for (ReportOutput output : reportOutputs) {
                String resourcePath = output.getRepositoryPath();
                if (resourcePath == null) continue;
                String resourceURI = contentResourceURIResolver.resolveURI(resourcePath);
                String line = job.getMessage("report.scheduling.notification.repository.link.line", new Object[]{linkDescription, resourceURI});
                notificationMessage.append(line);
            }
        }
    }

    protected void embedOutput(MimeMessageHelper messageHelper, ReportOutput output) throws MessagingException, JobExecutionException {
        String childName;
        StringBuffer primaryPage = new StringBuffer(new String(output.getData().getData()));
        for (ReportOutput child : output.getChildren()) {
            childName = child.getFilename();
            if (!output.getFileType().equals("html")) continue;
            if (primaryPage == null) {
                primaryPage = new StringBuffer(new String(output.getData().getData()));
            }
            int fromIndex = 0;
            while ((fromIndex = primaryPage.indexOf("src=\"" + childName + "\"", fromIndex)) > 0) {
                primaryPage.insert(fromIndex + 5, "cid:");
            }
        }
        messageHelper.setText(primaryPage.toString(), true);
        for (ReportOutput child : output.getChildren()) {
            childName = child.getFilename();
            DataContainerResource dataContainerResource = new DataContainerResource(child.getData());
            dataContainerResource.setFilename(childName);
            messageHelper.addInline(childName, (Resource)dataContainerResource);
        }
    }

    protected void attachOutput(ReportExecutionJob job, MimeMessageHelper messageHelper, ReportOutput output, boolean useZipFormat) throws MessagingException, JobExecutionException {
        DataContainer attachmentData;
        String attachmentName;
        if (output.getChildren().isEmpty()) {
            attachmentName = output.getFilename();
            attachmentData = output.getData();
        } else if (useZipFormat) {
            attachmentData = job.createDataContainer();
            boolean close = true;
            ZipOutputStream zipOut = new ZipOutputStream(attachmentData.getOutputStream());
            try {
                zipOut.putNextEntry(new ZipEntry(output.getFilename()));
                DataContainerStreamUtil.pipeDataAndCloseInput((InputStream)output.getData().getInputStream(), (OutputStream)zipOut);
                zipOut.closeEntry();
                for (ReportOutput child : output.getChildren()) {
                    String childName = this.getChildrenFolderName(job, output.getFilename()) + '/' + child.getFilename();
                    zipOut.putNextEntry(new ZipEntry(childName));
                    DataContainerStreamUtil.pipeDataAndCloseInput((InputStream)child.getData().getInputStream(), (OutputStream)zipOut);
                    zipOut.closeEntry();
                }
                zipOut.finish();
                zipOut.flush();
                close = false;
                zipOut.close();
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        zipOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
            attachmentName = output.getFilename() + ".zip";
        } else {
            String attachmentName2 = output.getFilename();
            try {
                attachmentName2 = MimeUtility.encodeWord((String)attachmentName2, (String)job.getCharacterEncoding(), null);
            }
            catch (UnsupportedEncodingException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            StringBuffer primaryPage = null;
            for (ReportOutput child : output.getChildren()) {
                String childName = child.getFilename();
                if (output.getFileType().equals("html")) {
                    if (primaryPage == null) {
                        primaryPage = new StringBuffer(new String(output.getData().getData()));
                    }
                    int fromIndex = 0;
                    while ((fromIndex = primaryPage.indexOf("src=\"" + childName + "\"", fromIndex)) > 0) {
                        primaryPage.insert(fromIndex + 5 + childName.length(), ".dat");
                    }
                    childName = childName + ".dat";
                }
                try {
                    childName = MimeUtility.encodeWord((String)childName, (String)job.getCharacterEncoding(), null);
                }
                catch (UnsupportedEncodingException e) {
                    throw new JSExceptionWrapper((Exception)e);
                }
                messageHelper.addAttachment(childName, (InputStreamSource)new DataContainerResource(child.getData()));
            }
            if (primaryPage == null) {
                messageHelper.addAttachment(attachmentName2, (InputStreamSource)new DataContainerResource(output.getData()));
            } else {
                messageHelper.addAttachment(attachmentName2, (InputStreamSource)new DataContainerResource((DataContainer)new MemoryDataContainer(primaryPage.toString().getBytes())));
            }
            return;
        }
        try {
            attachmentName = MimeUtility.encodeWord((String)attachmentName, (String)job.getCharacterEncoding(), null);
        }
        catch (UnsupportedEncodingException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        messageHelper.addAttachment(attachmentName, (InputStreamSource)new DataContainerResource(attachmentData));
    }

    protected static void attachException(MimeMessageHelper messageHelper, ExceptionInfo exceptionInfo) throws MessagingException {
        Throwable exception = exceptionInfo.getException();
        if (exception == null) {
            return;
        }
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream printOut = new PrintStream(bufOut);
        exception.printStackTrace(printOut);
        printOut.flush();
        String attachmentName = "exception_" + System.identityHashCode(exception) + ".txt";
        messageHelper.addAttachment(attachmentName, (InputStreamSource)new ByteArrayResource(bufOut.toByteArray()));
    }

    protected String getChildrenFolderName(ReportExecutionJob job, String resourceName) {
        return job.getRepository().getChildrenFolderName(resourceName);
    }

    protected void addMailRecipients(ReportJobMailNotification mailNotification, MimeMessageHelper messageHelper) throws MessagingException {
        List bccAddresses;
        List ccAddresses;
        List toAddresses = mailNotification.getToAddresses();
        if (toAddresses != null && !toAddresses.isEmpty()) {
            String[] addressArray = new String[toAddresses.size()];
            toAddresses.toArray(addressArray);
            messageHelper.setTo(addressArray);
        }
        if ((ccAddresses = mailNotification.getCcAddresses()) != null && !ccAddresses.isEmpty()) {
            String[] addressArray = new String[ccAddresses.size()];
            ccAddresses.toArray(addressArray);
            messageHelper.setCc(addressArray);
        }
        if ((bccAddresses = mailNotification.getBccAddresses()) != null && !bccAddresses.isEmpty()) {
            String[] addressArray = new String[bccAddresses.size()];
            bccAddresses.toArray(addressArray);
            messageHelper.setBcc(addressArray);
        }
    }
}

