/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class QuartzSchedulerControl
implements ApplicationContextAware,
ApplicationListener {
    private static final Log log = LogFactory.getLog(QuartzSchedulerControl.class);
    private Scheduler scheduler;
    private ApplicationContext applicationContext;
    private static boolean schedulerStarted = false;

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void start() {
        log.debug((Object)"QuartzSchedulerControl => start() just got called - will DELAY the REAL START of the Quartz Scheduler until later...");
        log.debug((Object)("QuartzSchedulerControl => start() schedulerStarted = " + schedulerStarted));
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            log.debug((Object)"QuartzSchedulerControl => Got a ContextRefreshedEvent event !!!!!");
            try {
                if (this.getScheduler().isInStandbyMode() && !this.applicationContext.containsBean("importCommandMetadata")) {
                    if (!schedulerStarted) {
                        this.getScheduler().start();
                        schedulerStarted = true;
                        log.debug((Object)("QuartzSchedulerControl => start() STARTED the Quartz scheduler, schedulerStarted = " + schedulerStarted));
                    }
                } else if (!this.getScheduler().isInStandbyMode()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"QuartzSchedulerControl => Scheduler already running.");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"QuartzSchedulerControl => Scheduler can't be started in the scope of import-export tool.");
                }
            }
            catch (SchedulerException e) {
                log.error((Object)"QuartzSchedulerControl => Error starting the scheduler", (Throwable)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
    }
}

