/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.user.UserPersistenceHandler;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.FTPInfoModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobAlertModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobCalendarTriggerModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobMailNotificationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobRepositoryDestinationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSimpleTriggerModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSourceModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.DuplicateOutputLocationException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobRuntimeInfoException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.TriggerTypeMismatchException;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class HibernateReportJobsPersistenceService
extends HibernateDaoImpl
implements ReportJobsPersistenceService,
ReportJobsInternalService {
    protected static final Log log = LogFactory.getLog(HibernateReportJobsPersistenceService.class);
    private UserPersistenceHandler userHandler;
    private ProfileAttributeService profileAttributeService;

    public UserPersistenceHandler getUserHandler() {
        return this.userHandler;
    }

    public void setUserHandler(UserPersistenceHandler userHandler) {
        this.userHandler = userHandler;
    }

    public ProfileAttributeService getProfileAttributeService() {
        return this.profileAttributeService;
    }

    public void setProfileAttributeService(ProfileAttributeService profileAttributeService) {
        this.profileAttributeService = profileAttributeService;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ReportJob saveJob(ExecutionContext context, ReportJob job) {
        return this.saveJob(context, job, true);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ReportJob saveJob(final ExecutionContext context, final ReportJob job, final boolean setContextUsername) {
        return (ReportJob)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                PersistentReportJob persistentJob = new PersistentReportJob();
                RepoUser owner = setContextUsername ? HibernateReportJobsPersistenceService.this.userHandler.getPersistentUserFromContext() : HibernateReportJobsPersistenceService.this.userHandler.getPersistentUserFromUsername(job.getUsername());
                persistentJob.setOwner(owner);
                ArrayList unusedEntities = new ArrayList();
                persistentJob.copyFrom(job, hibernateTemplate, unusedEntities, HibernateReportJobsPersistenceService.this.getProfileAttributeService(), context);
                persistentJob.cascadeSave(hibernateTemplate);
                hibernateTemplate.save((Object)persistentJob);
                hibernateTemplate.deleteAll(unusedEntities);
                hibernateTemplate.flush();
                ReportJob clientJob = HibernateReportJobsPersistenceService.this.toClient(persistentJob, context);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saved report job " + clientJob.getId() + " for report " + clientJob.getSource().getReportUnitURI()));
                }
                return clientJob;
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ReportJob updateJob(final ExecutionContext context, final ReportJob job) {
        return (ReportJob)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(job.getId(), true);
                ArrayList unusedEntities = new ArrayList();
                persistentJob.copyFrom(job, hibernateTemplate, unusedEntities, HibernateReportJobsPersistenceService.this.getProfileAttributeService(), context);
                persistentJob.cascadeSave(hibernateTemplate);
                hibernateTemplate.update((Object)persistentJob);
                hibernateTemplate.deleteAll(unusedEntities);
                hibernateTemplate.flush();
                ReportJob clientJob = HibernateReportJobsPersistenceService.this.toClient(persistentJob, context);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updated report job " + clientJob.getId()));
                }
                return clientJob;
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public List<ReportJobIdHolder> updateJobsByID(final ExecutionContext context, final List<ReportJobIdHolder> reportJobHolders, final ReportJobModel jobModel, final boolean replaceTriggerIgnoreType) throws TriggerTypeMismatchException, ReportJobNotFoundException, DuplicateOutputLocationException {
        return (List)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                if (jobModel == null || reportJobHolders == null || reportJobHolders.size() == 0) {
                    return new ArrayList();
                }
                List persistentJobs = HibernateReportJobsPersistenceService.this.getJobsByID(reportJobHolders);
                HibernateReportJobsPersistenceService.this.foundInvalidID(reportJobHolders, persistentJobs);
                ArrayList<PersistentReportJob> resultList = new ArrayList<PersistentReportJob>();
                ArrayList<ReportJobIdHolder> idList = new ArrayList<ReportJobIdHolder>();
                if (jobModel.getTrigger() != null && !replaceTriggerIgnoreType) {
                    HibernateReportJobsPersistenceService.this.verifyTriggerType(persistentJobs, jobModel.getTrigger());
                }
                HibernateReportJobsPersistenceService.this.verifyOutputLocation(persistentJobs, jobModel, context);
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                ArrayList<PersistentReportJob> newEntities = new ArrayList<PersistentReportJob>();
                ArrayList unusedEntities = new ArrayList();
                for (Object persistentJob : persistentJobs) {
                    PersistentReportJob result = HibernateReportJobsPersistenceService.this.updateJob((PersistentReportJob)persistentJob, jobModel, replaceTriggerIgnoreType, hibernateTemplate, newEntities, unusedEntities, context);
                    if (result == null) continue;
                    resultList.add(result);
                    idList.add(new ReportJobIdHolder(result.getId()));
                }
                for (PersistentReportJob entity : resultList) {
                    newEntities.add(entity);
                }
                hibernateTemplate.saveOrUpdateAll(newEntities);
                hibernateTemplate.deleteAll(unusedEntities);
                hibernateTemplate.flush();
                return idList;
            }
        });
    }

    public List<ReportJob> updateJobs(final ExecutionContext context, final List<ReportJob> reportJobList, final ReportJobModel jobModel, final boolean replaceTriggerIgnoreType) throws TriggerTypeMismatchException, DuplicateOutputLocationException {
        return (List)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                if (jobModel == null) {
                    return new ArrayList();
                }
                List persistentJobs = HibernateReportJobsPersistenceService.this.getJobs(reportJobList);
                ArrayList<PersistentReportJob> resultList = new ArrayList<PersistentReportJob>();
                ArrayList<ReportJob> idList = new ArrayList<ReportJob>();
                if (jobModel.getTrigger() != null && !replaceTriggerIgnoreType) {
                    HibernateReportJobsPersistenceService.this.verifyTriggerType(persistentJobs, jobModel.getTrigger());
                }
                HibernateReportJobsPersistenceService.this.verifyOutputLocation(persistentJobs, jobModel, context);
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                ArrayList<PersistentReportJob> newEntities = new ArrayList<PersistentReportJob>();
                ArrayList unusedEntities = new ArrayList();
                for (Object persistentJob : persistentJobs) {
                    PersistentReportJob result = HibernateReportJobsPersistenceService.this.updateJob((PersistentReportJob)persistentJob, jobModel, replaceTriggerIgnoreType, hibernateTemplate, newEntities, unusedEntities, context);
                    if (result == null) continue;
                    resultList.add(result);
                }
                for (PersistentReportJob entity : resultList) {
                    newEntities.add(entity);
                }
                hibernateTemplate.saveOrUpdateAll(newEntities);
                hibernateTemplate.deleteAll(unusedEntities);
                hibernateTemplate.flush();
                for (PersistentReportJob result : resultList) {
                    idList.add(result.toClient(HibernateReportJobsPersistenceService.this.profileAttributeService, context));
                }
                return idList;
            }
        });
    }

    private void verifyOutputLocation(List persistentJobs, ReportJobModel jobModel, ExecutionContext context) throws DuplicateOutputLocationException {
        Boolean isSaveToRepository = null;
        if (jobModel.getContentRepositoryDestinationModel() != null && jobModel.getContentRepositoryDestinationModel().isSaveToRepositoryModified()) {
            isSaveToRepository = jobModel.getContentRepositoryDestinationModel().isSaveToRepository();
        }
        if (isSaveToRepository != null && !isSaveToRepository.booleanValue()) {
            return;
        }
        String baseOutputName = null;
        if (jobModel.getContentRepositoryDestinationModel() != null && jobModel.getContentRepositoryDestinationModel().isFolderURIModified()) {
            baseOutputName = jobModel.getBaseOutputFilename();
        }
        String folderURI = null;
        if (jobModel.getContentRepositoryDestinationModel() != null && jobModel.getContentRepositoryDestinationModel().isFolderURIModified()) {
            folderURI = jobModel.getContentRepositoryDestinationModel().getFolderURI();
        }
        Boolean isUsingDefaultFolderURI = null;
        if (jobModel.getContentRepositoryDestinationModel() != null && jobModel.getContentRepositoryDestinationModel().isUsingDefaultReportOutputFolderURIModified()) {
            isUsingDefaultFolderURI = jobModel.getContentRepositoryDestinationModel().isUsingDefaultReportOutputFolderURI();
        }
        String defaultFolderURI = null;
        if (jobModel.getContentRepositoryDestinationModel() != null && jobModel.getContentRepositoryDestinationModel().isDefaultReportOutputFolderURIModified()) {
            defaultFolderURI = jobModel.getContentRepositoryDestinationModel().getDefaultReportOutputFolderURI();
        }
        if (isSaveToRepository == null && folderURI == null && baseOutputName == null && isUsingDefaultFolderURI == null && defaultFolderURI == null) {
            return;
        }
        HashSet<String> pathList = new HashSet<String>();
        for (Object persistentJob : persistentJobs) {
            boolean isUsingDefaultFolderURI_TMP;
            boolean isSaveToRepository_TMP;
            ReportJob job = this.toClient((PersistentReportJob)persistentJob, context);
            if (job.getContentRepositoryDestination() == null || !(isSaveToRepository_TMP = isSaveToRepository != null ? isSaveToRepository.booleanValue() : job.getContentRepositoryDestination().isSaveToRepository())) continue;
            String baseOutputName_TMP = baseOutputName != null ? new String(baseOutputName) : job.getBaseOutputFilename();
            boolean bl = isUsingDefaultFolderURI_TMP = isUsingDefaultFolderURI != null ? isUsingDefaultFolderURI.booleanValue() : job.getContentRepositoryDestination().isUsingDefaultReportOutputFolderURI();
            String folderURI_TMP = isUsingDefaultFolderURI_TMP ? (defaultFolderURI != null ? new String(defaultFolderURI) : job.getContentRepositoryDestination().getDefaultReportOutputFolderURI()) : (folderURI != null ? new String(folderURI) : job.getContentRepositoryDestination().getFolderURI());
            String path = folderURI_TMP + "/" + baseOutputName_TMP;
            if (pathList.contains(path)) {
                throw new DuplicateOutputLocationException(((PersistentReportJob)persistentJob).getId(), path);
            }
            pathList.add(path);
        }
    }

    private void verifyTriggerType(List persistentJobs, ReportJobTrigger jobTrigger) throws TriggerTypeMismatchException {
        for (Object persistentJob : persistentJobs) {
            if (((PersistentReportJob)persistentJob).getTrigger().supports(jobTrigger.getClass())) continue;
            throw new TriggerTypeMismatchException(((PersistentReportJob)persistentJob).getId(), jobTrigger instanceof ReportJobSimpleTriggerModel ? TriggerTypeMismatchException.TRIGGER_TYPE.SIMPLE_TRIGGER : TriggerTypeMismatchException.TRIGGER_TYPE.CALENDAR_TRIGGER);
        }
    }

    private PersistentReportJob updateJob(PersistentReportJob persistentJob, ReportJobModel jobModel, boolean replaceTrigger, HibernateTemplate hibernateTemplate, List newEntities, List unusedEntities, ExecutionContext context) {
        persistentJob.copyFrom(jobModel, replaceTrigger, hibernateTemplate, unusedEntities, this.getProfileAttributeService(), context);
        persistentJob.cascadeSave(newEntities);
        return persistentJob;
    }

    private void foundInvalidID(List<ReportJobIdHolder> expectedIDs, List actualIDs) throws ReportJobNotFoundException {
        if (actualIDs == null) {
            throw new ReportJobNotFoundException(expectedIDs.get(0).getId());
        }
        ArrayList<Long> foundIDList = new ArrayList<Long>();
        for (Object persistentJob : actualIDs) {
            foundIDList.add(((PersistentReportJob)persistentJob).getId());
        }
        for (ReportJobIdHolder expectedID : expectedIDs) {
            if (foundIDList.contains(expectedID.getId())) continue;
            throw new ReportJobNotFoundException(expectedID.getId());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ReportJob loadJob(final ExecutionContext context, ReportJobIdHolder jobIdHolder) {
        final long jobId = jobIdHolder.getId();
        return (ReportJob)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(jobId, false);
                ReportJob job = persistentJob == null ? null : HibernateReportJobsPersistenceService.this.toClient(persistentJob, context);
                return job;
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<ReportJob> loadJobs(final ExecutionContext context, final List<ReportJobIdHolder> jobIDList) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getJobsByID(jobIDList);
                if (persistentJobs == null) {
                    return null;
                }
                ArrayList<ReportJob> newList = new ArrayList<ReportJob>();
                for (Object persistentJob : persistentJobs) {
                    newList.add(HibernateReportJobsPersistenceService.this.toClient((PersistentReportJob)persistentJob, context));
                }
                return newList;
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteJob(ExecutionContext context, ReportJobIdHolder jobIdHolder) {
        this.deleteJob(jobIdHolder.getId());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteJob(final long jobId) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob job = HibernateReportJobsPersistenceService.this.findJob(jobId, false);
                if (job != null) {
                    HibernateReportJobsPersistenceService.this.deleteJob(job);
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Report job with id " + jobId + " not found for deletion"));
                }
                return null;
            }
        }, false);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List listJobs(ExecutionContext context, final String reportUnitURI) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(reportUnitURI);
                return HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
            }
        });
    }

    public List<ReportJobSummary> listJobs(final ExecutionContext context, final ReportJobModel reportJobCriteria, final int startIndex, final int numberOfRows, final ReportJobModel.ReportJobSortType sortType, final boolean isAscending) throws ReportJobRuntimeInfoException {
        if (sortType != null) {
            switch (sortType) {
                case SORTBY_STATUS: 
                case SORTBY_LASTRUN: 
                case SORTBY_NEXTRUN: {
                    throw new ReportJobRuntimeInfoException(sortType);
                }
            }
        }
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(reportJobCriteria, context);
                List<ReportJobSummary> jobs = HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
                Comparator comparator = HibernateReportJobsPersistenceService.this.getComparator(context, sortType);
                if (comparator != null) {
                    if (!isAscending) {
                        comparator = Collections.reverseOrder(comparator);
                    }
                    Collections.sort(jobs, comparator);
                } else if (!isAscending) {
                    Collections.reverse(jobs);
                }
                int beginningIndex = 0;
                if (startIndex > 0) {
                    beginningIndex = startIndex;
                }
                if (beginningIndex == 0 && numberOfRows == -1) {
                    return jobs;
                }
                ArrayList<ReportJobSummary> newList = new ArrayList<ReportJobSummary>();
                if (beginningIndex >= jobs.size()) {
                    return newList;
                }
                int showRowCount = numberOfRows;
                if (numberOfRows < 0 || numberOfRows > jobs.size() - startIndex) {
                    showRowCount = jobs.size() - beginningIndex;
                }
                for (int i = beginningIndex; i < showRowCount + beginningIndex; ++i) {
                    newList.add(jobs.get(i));
                }
                return newList;
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List listJobs(ExecutionContext context, final List<ReportJob> list) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getJobs(list);
                return HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List listJobs(ExecutionContext context) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getAllJobs();
                return HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
            }
        });
    }

    protected PersistentReportJob findJob(long jobId, boolean required) {
        PersistentReportJob job = (PersistentReportJob)this.getHibernateTemplate().get(PersistentReportJob.class, (Serializable)Long.valueOf(jobId));
        if (job == null && required) {
            throw new ReportJobNotFoundException(jobId);
        }
        return job;
    }

    @Override
    public String getJobOwner(final long jobId) {
        return (String)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(jobId, true);
                return HibernateReportJobsPersistenceService.this.userHandler.getClientUsername(persistentJob.getOwner());
            }
        });
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public long[] deleteReportUnitJobs(final String reportUnitURI) {
        return (long[])this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List jobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(reportUnitURI);
                return HibernateReportJobsPersistenceService.this.deletePersistentJobs(jobs);
            }
        }, false);
    }

    protected void deleteJob(PersistentReportJob job) {
        job.delete(this.getHibernateTemplate());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted job " + job.getId()));
        }
    }

    protected List getReportUnitJobs(String reportUnitURI) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        DetachedCriteria crit = DetachedCriteria.forClass(PersistentReportJob.class);
        crit.add((Criterion)Restrictions.eq((String)"source.reportUnitURI", (Object)reportUnitURI));
        return hibernateTemplate.findByCriteria(crit);
    }

    protected List getReportUnitJobs(ReportJobModel criteriaReportJob, ExecutionContext context) {
        ReportJobSourceModel des;
        if (criteriaReportJob == null) {
            return this.getAllJobs();
        }
        boolean requireDetailSearch = false;
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        DetachedCriteria crit = DetachedCriteria.forClass(PersistentReportJob.class);
        if (criteriaReportJob.isBaseOutputFileNameModified()) {
            this.addLikeRestriction(crit, "baseOutputFilename", criteriaReportJob.getBaseOutputFilename());
        }
        if (criteriaReportJob.isCreationDateModified() && criteriaReportJob.getCreationDate() != null) {
            requireDetailSearch = true;
        }
        if (criteriaReportJob.isLabelModified()) {
            this.addLikeRestriction(crit, "label", criteriaReportJob.getLabel());
        }
        if (criteriaReportJob.isDescriptionModified()) {
            this.addLikeRestriction(crit, "description", criteriaReportJob.getDescription());
        }
        if (criteriaReportJob.isOutputLocaleModified()) {
            this.addEqualRestriction(crit, "outputLocale", criteriaReportJob.getOutputLocale());
        }
        if (criteriaReportJob.isUsernameModified() && criteriaReportJob.getUsername() != null) {
            crit.createAlias("owner", "owner");
            this.addEqualRestriction(crit, "owner.username", criteriaReportJob.getUsername());
        }
        if (criteriaReportJob.isOutputFormatsModified() && criteriaReportJob.getOutputFormatsSet() != null) {
            requireDetailSearch = true;
        }
        if (criteriaReportJob.isTriggerModified() && criteriaReportJob.getTriggerModel() != null) {
            requireDetailSearch = true;
        }
        if (criteriaReportJob.isSourceModified() && criteriaReportJob.getSourceModel() != null) {
            des = criteriaReportJob.getSourceModel();
            if (des.isParametersMapModified()) {
                this.addEqualRestriction(crit, "source.parametersMap", des.getParametersMap());
            }
            if (des.isReportUnitURIModified()) {
                this.addLikeRestriction(crit, "source.reportUnitURI", des.getReportUnitURI());
            }
        }
        if (criteriaReportJob.isContentRespositoryDestinationModified() && criteriaReportJob.getContentRepositoryDestinationModel() != null) {
            crit.createAlias("contentRepositoryDestination", "contentRepositoryDestination");
            des = criteriaReportJob.getContentRepositoryDestinationModel();
            if (des.isFolderURIModified()) {
                this.addLikeRestriction(crit, "contentRepositoryDestination.folderURI", des.getFolderURI());
            }
            if (des.isOutputDescriptionsModified()) {
                this.addLikeRestriction(crit, "contentRepositoryDestination.outputDescription", des.getOutputDescription());
            }
            if (des.isTimestampPatternModified()) {
                this.addEqualRestriction(crit, "contentRepositoryDestination.timestampPattern", des.getTimestampPattern());
            }
            if (des.isOverwriteFilesModified()) {
                this.addEqualRestriction(crit, "contentRepositoryDestination.overwriteFiles", des.isOverwriteFiles());
            }
            if (des.isSaveToRepositoryModified()) {
                this.addEqualRestriction(crit, "contentRepositoryDestination.saveToRepository", des.isSaveToRepository());
            }
            if (des.isSequentialFilenamesModified()) {
                this.addEqualRestriction(crit, "contentRepositoryDestination.sequentialFilenames", des.isSequentialFilenames());
            }
            if (des.isDefaultReportOutputFolderURIModified()) {
                requireDetailSearch = true;
            }
            if (des.isUsingDefaultReportOutputFolderURIModified()) {
                this.addEqualRestriction(crit, "contentRepositoryDestination.usingDefaultReportOutputFolderURI", des.isUsingDefaultReportOutputFolderURIModified());
            }
            if (des.isOutputLocalFolderModified()) {
                this.addEqualRestriction(crit, "contentRepositoryDestination.outputLocalFolder", des.getOutputLocalFolder());
            }
            if (des.isOutputFTPInfoModified() && des.getOutputFTPInfoModel() != null) {
                FTPInfoModel ftpInfoModel = des.getOutputFTPInfoModel();
                if (ftpInfoModel.isUserNameModified()) {
                    this.addLikeRestriction(crit, "contentRepositoryDestination.outputFTPInfo.userName", ftpInfoModel.getUserName());
                }
                if (ftpInfoModel.isPasswordModified()) {
                    this.addEqualRestriction(crit, "contentRepositoryDestination.outputFTPInfo.password", ftpInfoModel.getPassword());
                }
                if (ftpInfoModel.isServerNameModified()) {
                    this.addLikeRestriction(crit, "contentRepositoryDestination.outputFTPInfo.server_name", ftpInfoModel.getUserName());
                }
                if (ftpInfoModel.isFolderPathModified()) {
                    this.addLikeRestriction(crit, "contentRepositoryDestination.outputFTPInfo.folder_path", ftpInfoModel.getPassword());
                }
                if (ftpInfoModel.isPropertiesMapModified()) {
                    this.addEqualRestriction(crit, "contentRepositoryDestination.outputFTPInfo.propertiesMap", ftpInfoModel.getPropertiesMap());
                }
            }
        }
        if (criteriaReportJob.isMailNotificationModified() && criteriaReportJob.getMailNotificationModel() != null) {
            crit.createAlias("mailNotification", "mailNotification");
            des = criteriaReportJob.getMailNotificationModel();
            if (des.isSubjectModified()) {
                this.addLikeRestriction(crit, "mailNotification.subject", des.getSubject());
            }
            if (des.isMessageTextModified()) {
                this.addLikeRestriction(crit, "mailNotification.messageText", des.getMessageText());
            }
            if (des.isMessageTextWhenJobFailsModified()) {
                this.addLikeRestriction(crit, "mailNotification.messageTextWhenJobFails", des.getMessageTextWhenJobFails());
            }
            if (des.isIncludingStackTraceWhenJobFailsModified()) {
                this.addEqualRestriction(crit, "mailNotification.includingStackTraceWhenJobFails", des.isIncludingStackTraceWhenJobFails());
            }
            if (des.isSkipNotificationWhenJobFailsModified()) {
                this.addEqualRestriction(crit, "mailNotification.skipNotificationWhenJobFails", des.isSkipNotificationWhenJobFails());
            }
            if (des.isResultSendTypeModified()) {
                this.addEqualRestriction(crit, "mailNotification.resultSendType", des.getResultSendTypeCode());
            }
            if (des.isSkipEmptyReportsModified()) {
                this.addEqualRestriction(crit, "mailNotification.skipEmptyReports", des.isSkipEmptyReports());
            }
            if (des.isToAddressesModified() && des.getToAddresses() != null && des.getToAddresses().size() > 0 || des.isCcAddressesModified() && des.getCcAddresses() != null && des.getCcAddresses().size() > 0 || des.isBccAddressesModified() && des.getBccAddresses() != null && des.getBccAddresses().size() > 0) {
                requireDetailSearch = true;
            }
        }
        if (criteriaReportJob.isAlertModified() && criteriaReportJob.getAlertModel() != null) {
            crit.createAlias("alert", "alert");
            des = criteriaReportJob.getAlertModel();
            if (des.isMessageTextModified()) {
                this.addLikeRestriction(crit, "alert.messageText", des.getMessageText());
            }
            if (des.isMessageTextWhenJobFailsModified()) {
                this.addLikeRestriction(crit, "alert.messageTextWhenJobFails", des.getMessageTextWhenJobFails());
            }
            if (des.isSubjectModified()) {
                this.addLikeRestriction(crit, "alert.subject", des.getSubject());
            }
            if (des.isIncludingStackTraceModified()) {
                this.addEqualRestriction(crit, "alert.includingStackTrace", des.isIncludingStackTrace());
            }
            if (des.isIncludingReportJobInfoModified()) {
                this.addEqualRestriction(crit, "alert.includingReportJobInfo", des.isIncludingReportJobInfo());
            }
            if (des.isJobStateModified()) {
                this.addEqualRestriction(crit, "alert.jobState", des.getJobState());
            }
            if (des.isRecipientModified()) {
                this.addEqualRestriction(crit, "alert.recipient", des.getRecipient());
            }
            if (des.isToAddressesModified()) {
                requireDetailSearch = true;
            }
        }
        List persistentJobs = hibernateTemplate.findByCriteria(crit);
        if (requireDetailSearch && persistentJobs != null) {
            for (int i = persistentJobs.size() - 1; i >= 0; --i) {
                if (this.detailCriteriaMatch((PersistentReportJob)persistentJobs.get(i), criteriaReportJob, context)) continue;
                persistentJobs.remove(i);
            }
        }
        return persistentJobs;
    }

    private void addEqualRestriction(DetachedCriteria crit, String propertyName, Object value) {
        if (value != null) {
            crit.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
        }
    }

    private void addLikeRestriction(DetachedCriteria crit, String propertyName, Object value) {
        if (value != null) {
            crit.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
        }
    }

    private boolean detailCriteriaMatch(PersistentReportJob reportJob, ReportJobModel jobModel, ExecutionContext context) {
        if (jobModel.isOutputFormatsModified() && jobModel.getOutputFormatsSet() != null && !jobModel.getOutputFormatsSet().isEmpty()) {
            if (reportJob.getOutputFormats() == null) {
                return false;
            }
            for (Byte outputFormat : jobModel.getOutputFormatsSet()) {
                if (reportJob.getOutputFormats().contains(outputFormat)) continue;
                return false;
            }
        }
        if (jobModel.isCreationDateModified() && jobModel.getCreationDate() != null && !this.matchRestriction(jobModel.getCreationDate(), reportJob.getCreationDate())) {
            return false;
        }
        if (jobModel.isTriggerModified() && jobModel.getTriggerModel() != null) {
            ReportJobSimpleTriggerModel simpleTriggerModel;
            ReportJobTrigger jobTrigger;
            ReportJobCalendarTriggerModel calendarTriggerModel;
            if (reportJob.getTrigger() == null) {
                return false;
            }
            if (jobModel.getTriggerModel() instanceof ReportJobCalendarTriggerModel && (calendarTriggerModel = (ReportJobCalendarTriggerModel)jobModel.getTriggerModel()).isModified()) {
                jobTrigger = reportJob.getTrigger().toClient();
                if (!(jobTrigger instanceof ReportJobCalendarTrigger)) {
                    return false;
                }
                ReportJobCalendarTrigger calendarTrigger = (ReportJobCalendarTrigger)jobTrigger;
                if (calendarTriggerModel.isStartDateModified() && !this.matchRestriction(calendarTriggerModel.getStartDate(), calendarTrigger.getStartDate())) {
                    return false;
                }
                if (calendarTriggerModel.isEndDateModified() && !this.matchRestriction(calendarTriggerModel.getEndDate(), calendarTrigger.getEndDate())) {
                    return false;
                }
                if (calendarTriggerModel.isStartTypeModified() && !this.matchRestriction(calendarTriggerModel.getStartType(), calendarTrigger.getStartType())) {
                    return false;
                }
                if (calendarTriggerModel.isTimezoneModified() && !this.matchRestriction(calendarTriggerModel.getTimezone(), calendarTrigger.getTimezone())) {
                    return false;
                }
                if (calendarTriggerModel.isCalendarNameModified() && !this.matchRestriction(calendarTriggerModel.getCalendarName(), calendarTrigger.getCalendarName())) {
                    return false;
                }
                if (calendarTriggerModel.isDaysTypeModified() && !this.matchRestriction(calendarTriggerModel.getDaysTypeCode(), calendarTrigger.getDaysTypeCode())) {
                    return false;
                }
                if (calendarTriggerModel.isHoursModified() && !this.matchRestriction(calendarTriggerModel.getHours(), calendarTrigger.getHours())) {
                    return false;
                }
                if (calendarTriggerModel.isMinutesModified() && !this.matchRestriction(calendarTriggerModel.getMinutes(), calendarTrigger.getMinutes())) {
                    return false;
                }
                if (calendarTriggerModel.isMonthDaysModified() && !this.matchRestriction(calendarTriggerModel.getMonthDays(), calendarTrigger.getMonthDays())) {
                    return false;
                }
                if (calendarTriggerModel.isMonthsModified() && calendarTriggerModel.getMonths() != null && !this.matchRestriction(PersistentReportJobCalendarTrigger.toEnumerationString(calendarTriggerModel.getMonths()), PersistentReportJobCalendarTrigger.toEnumerationString(calendarTrigger.getMonths()))) {
                    return false;
                }
                if (calendarTriggerModel.isWeekDaysModified() && !this.matchRestriction(calendarTriggerModel.getWeekDays(), calendarTrigger.getWeekDays())) {
                    return false;
                }
            }
            if (jobModel.getTriggerModel() instanceof ReportJobSimpleTriggerModel && (simpleTriggerModel = (ReportJobSimpleTriggerModel)jobModel.getTriggerModel()).isModified()) {
                jobTrigger = reportJob.getTrigger().toClient();
                if (!(jobTrigger instanceof ReportJobSimpleTrigger)) {
                    return false;
                }
                ReportJobSimpleTrigger simpleTrigger = (ReportJobSimpleTrigger)jobTrigger;
                if (simpleTriggerModel.isStartDateModified() && !this.matchRestriction(simpleTriggerModel.getStartDate(), simpleTrigger.getStartDate())) {
                    return false;
                }
                if (simpleTriggerModel.isEndDateModified() && !this.matchRestriction(simpleTriggerModel.getEndDate(), simpleTrigger.getEndDate())) {
                    return false;
                }
                if (simpleTriggerModel.isStartTypeModified() && !this.matchRestriction(simpleTriggerModel.getStartType(), simpleTrigger.getStartType())) {
                    return false;
                }
                if (simpleTriggerModel.isTimezoneModified() && !this.matchRestriction(simpleTriggerModel.getTimezone(), simpleTrigger.getTimezone())) {
                    return false;
                }
                if (simpleTriggerModel.isCalendarNameModified() && !this.matchRestriction(simpleTriggerModel.getCalendarName(), simpleTriggerModel.getCalendarName())) {
                    return false;
                }
                if (simpleTriggerModel.isOccurrenceCountModified() && !this.matchRestriction(simpleTriggerModel.getOccurrenceCount(), simpleTrigger.getOccurrenceCount())) {
                    return false;
                }
                if (simpleTriggerModel.isRecurrenceIntervalModified() && !this.matchRestriction(simpleTriggerModel.getRecurrenceInterval(), simpleTrigger.getRecurrenceInterval())) {
                    return false;
                }
                if (simpleTriggerModel.isRecurrenceIntervalUnitModified() && !this.matchRestriction(simpleTriggerModel.getRecurrenceIntervalUnit(), simpleTrigger.getRecurrenceIntervalUnit())) {
                    return false;
                }
            }
        }
        if (jobModel.isContentRespositoryDestinationModified() && jobModel.getContentRepositoryDestinationModel() != null) {
            if (reportJob.getMailNotification() == null) {
                return false;
            }
            ReportJobRepositoryDestinationModel destinationModel = jobModel.getContentRepositoryDestinationModel();
            if (destinationModel.isDefaultReportOutputFolderURIModified() && destinationModel.getDefaultReportOutputFolderURI() != null) {
                ReportJobRepositoryDestination destination = reportJob.getContentRepositoryDestination().toClient(this.getProfileAttributeService(), reportJob.getOwner(), context);
                if (!this.matchRestriction(destinationModel.getDefaultReportOutputFolderURI(), destination.getDefaultReportOutputFolderURI())) {
                    return false;
                }
            }
        }
        if (jobModel.isMailNotificationModified() && jobModel.getMailNotificationModel() != null) {
            if (reportJob.getMailNotification() == null) {
                return false;
            }
            ReportJobMailNotification mailNotification = reportJob.getMailNotification().toClient();
            ReportJobMailNotificationModel mailNotificationModel = jobModel.getMailNotificationModel();
            if (mailNotificationModel.isToAddressesModified() && !this.matchRestrictionList(mailNotificationModel.getToAddresses(), mailNotification.getToAddresses())) {
                return false;
            }
            if (mailNotificationModel.isCcAddressesModified() && !this.matchRestrictionList(mailNotificationModel.getCcAddresses(), mailNotification.getCcAddresses())) {
                return false;
            }
            if (mailNotificationModel.isBccAddressesModified() && !this.matchRestrictionList(mailNotificationModel.getBccAddresses(), mailNotification.getBccAddresses())) {
                return false;
            }
        }
        if (jobModel.isAlertModified() && jobModel.getAlertModel() != null) {
            if (reportJob.getAlert() == null) {
                return false;
            }
            ReportJobAlert alert = reportJob.getAlert().toClient();
            ReportJobAlertModel alertModel = jobModel.getAlertModel();
            if (alertModel.isToAddressesModified() && !this.matchRestrictionList(alertModel.getToAddresses(), alert.getToAddresses())) {
                return false;
            }
        }
        return true;
    }

    private boolean matchRestriction(Object model, Object value) {
        try {
            if (model == null) {
                return true;
            }
            if (model instanceof Date) {
                GregorianCalendar calendar1 = new GregorianCalendar();
                calendar1.setTime((Date)model);
                calendar1.set(13, 0);
                calendar1.set(14, 0);
                GregorianCalendar calendar2 = new GregorianCalendar();
                calendar2.setTime((Date)value);
                calendar2.set(13, 0);
                calendar2.set(14, 0);
                return calendar1.compareTo(calendar2) == 0;
            }
            if (model instanceof String) {
                return ((String)model).equalsIgnoreCase((String)value);
            }
            model.equals(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean matchRestrictionList(List modelList, List valueList) {
        if (modelList == null || modelList.size() == 0) {
            return true;
        }
        if (valueList == null) {
            return false;
        }
        for (Object item : modelList) {
            if (valueList.contains(item)) continue;
            return false;
        }
        return true;
    }

    protected List getAllJobs() {
        return this.getHibernateTemplate().loadAll(PersistentReportJob.class);
    }

    protected List getJobsByID(List<ReportJobIdHolder> jobIDList) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        DetachedCriteria crit = DetachedCriteria.forClass(PersistentReportJob.class);
        Disjunction criterion = Restrictions.disjunction();
        for (ReportJobIdHolder idHolder : jobIDList) {
            criterion.add((Criterion)Restrictions.eq((String)"id", (Object)idHolder.getId()));
        }
        crit.add((Criterion)criterion);
        List persistentJobs = hibernateTemplate.findByCriteria(crit);
        return persistentJobs;
    }

    protected List getJobs(List<ReportJob> jobIDList) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        DetachedCriteria crit = DetachedCriteria.forClass(PersistentReportJob.class);
        Disjunction criterion = Restrictions.disjunction();
        for (ReportJob idHolder : jobIDList) {
            criterion.add((Criterion)Restrictions.eq((String)"id", (Object)idHolder.getId()));
        }
        crit.add((Criterion)criterion);
        List persistentJobs = hibernateTemplate.findByCriteria(crit);
        return persistentJobs;
    }

    public List<ReportJobSummary> toClientSummary(List persistentJobs) {
        ArrayList<ReportJobSummary> jobs = new ArrayList<ReportJobSummary>(persistentJobs.size());
        for (PersistentReportJob persistentJob : persistentJobs) {
            jobs.add(this.toClientSummary(persistentJob));
        }
        return jobs;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public long[] deletePersistentJobs(List jobs) {
        long[] jobIds;
        if (jobs == null || jobs.isEmpty()) {
            jobIds = null;
        } else {
            jobIds = new long[jobs.size()];
            int c = 0;
            for (PersistentReportJob job : jobs) {
                jobIds[c] = job.getId();
                this.deleteJob(job);
                ++c;
            }
        }
        return jobIds;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public long[] updateReportUnitURI(final String oldURI, final String newURI) {
        return (long[])this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List jobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(oldURI);
                return HibernateReportJobsPersistenceService.this.updateReportURI(jobs, newURI);
            }
        }, false);
    }

    protected Object updateReportURI(List jobs, String newURI) {
        long[] jobIds;
        if (jobs == null || jobs.isEmpty()) {
            jobIds = null;
        } else {
            jobIds = new long[jobs.size()];
            int c = 0;
            for (PersistentReportJob job : jobs) {
                jobIds[c] = job.getId();
                job.getSource().setReportUnitURI(newURI);
                this.getHibernateTemplate().update((Object)job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updated report URI of job " + job.getId() + " to " + newURI));
                }
                ++c;
            }
        }
        return jobIds;
    }

    protected ReportJob toClient(PersistentReportJob persistentJob, ExecutionContext context) {
        ReportJob clientJob = persistentJob.toClient(this.profileAttributeService, context);
        clientJob.setUsername(this.userHandler.getClientUsername(persistentJob.getOwner()));
        return clientJob;
    }

    protected ReportJobSummary toClientSummary(PersistentReportJob persistentJob) {
        ReportJobSummary clientSummary = persistentJob.toSummary();
        clientSummary.setUsername(this.userHandler.getClientUsername(persistentJob.getOwner()));
        return clientSummary;
    }

    private Comparator<ReportJobSummary> getComparator(ExecutionContext context, final ReportJobModel.ReportJobSortType sortBy) {
        if (sortBy == null || sortBy == ReportJobModel.ReportJobSortType.NONE) {
            return null;
        }
        return new Comparator<ReportJobSummary>(){

            @Override
            public int compare(ReportJobSummary o1, ReportJobSummary o2) {
                switch (sortBy) {
                    case SORTBY_JOBID: {
                        return (int)(o1.getId() - o2.getId());
                    }
                    case SORTBY_JOBNAME: {
                        return HibernateReportJobsPersistenceService.compareObject(o1.getLabel(), o2.getLabel());
                    }
                    case SORTBY_REPORTURI: {
                        return HibernateReportJobsPersistenceService.compareObject(o1.getReportUnitURI(), o2.getReportUnitURI());
                    }
                    case SORTBY_REPORTNAME: 
                    case SORTBY_REPORTFOLDER: {
                        return HibernateReportJobsPersistenceService.this.compareURI(o1.getReportUnitURI() != null ? o1.getReportUnitURI() : null, o2.getReportUnitURI() != null ? o2.getReportUnitURI() : null, sortBy);
                    }
                    case SORTBY_OWNER: {
                        return HibernateReportJobsPersistenceService.compareObject(o1.getUsername(), o2.getUsername());
                    }
                }
                return 0;
            }
        };
    }

    private static Integer checkForNull(Object str1, Object str2) {
        if (str1 == null && str2 != null) {
            return -1;
        }
        if (str1 != null && str2 == null) {
            return 1;
        }
        if (str1 == null && str2 == null) {
            return 0;
        }
        return null;
    }

    private String getName(String uri, ReportJobModel.ReportJobSortType sorttype) {
        String folder = uri.replace('\\', '/');
        folder = uri.substring(0, folder.lastIndexOf("/"));
        if (sorttype == ReportJobModel.ReportJobSortType.SORTBY_REPORTFOLDER) {
            return folder;
        }
        return uri.substring(folder.length() + 1);
    }

    private int compareURI(String str1, String str2, ReportJobModel.ReportJobSortType sorttype) {
        Integer isNull = HibernateReportJobsPersistenceService.checkForNull(str1, str2);
        if (isNull != null) {
            return isNull;
        }
        return HibernateReportJobsPersistenceService.compareObject(this.getName(str1, sorttype), this.getName(str2, sorttype));
    }

    public static int compareObject(Object str1, Object str2) {
        Integer isNull = HibernateReportJobsPersistenceService.checkForNull(str1, str2);
        if (isNull != null) {
            return isNull;
        }
        if (str1 instanceof String) {
            return ((String)str1).compareTo((String)str2);
        }
        if (str1 instanceof Date) {
            return ((Date)str1).compareTo((Date)str2);
        }
        return 0;
    }

    private void p(String s) {
        System.out.println(this.getClass().getName() + " - ");
    }
}

