/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.Handler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryURLHandlerFactory
implements URLStreamHandlerFactory {
    protected static final Log log = LogFactory.getLog(RepositoryURLHandlerFactory.class);
    private static final RepositoryURLHandlerFactory instance = new RepositoryURLHandlerFactory();
    private final Handler repositoryHandler = new Handler();

    public static RepositoryURLHandlerFactory getInstance() {
        return instance;
    }

    protected RepositoryURLHandlerFactory() {
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol.equals("repo")) {
            return this.repositoryHandler;
        }
        return null;
    }

    public Handler getRepoHandler() {
        return this.repositoryHandler;
    }

    public static URL createRepoURL(String uri) {
        return RepositoryURLHandlerFactory.createRepoURL(uri, null);
    }

    public static URL createRepoURL(String uri, RepositoryContext repositoryContext) {
        Handler handler = repositoryContext == null ? RepositoryURLHandlerFactory.getInstance().getRepoHandler() : new Handler(repositoryContext);
        try {
            return new URL(null, "repo:" + uri, handler);
        }
        catch (MalformedURLException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }
}

