/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FileResourceImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRElementsVisitor;
import net.sf.jasperreports.engine.util.JRVisitorSupport;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class ResourceCollector
extends JRVisitorSupport {
    private static final String REPO_URL_PROTOCOL = "repo:";
    private List resources = new ArrayList();
    private Set resourceNames = new HashSet();

    private ResourceCollector() {
    }

    public static Resource[] getResources(InputStream jrxmlStream) {
        JasperDesign jasperDesign = null;
        try {
            jasperDesign = JRXmlLoader.load((InputStream)jrxmlStream);
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        ResourceCollector collector = new ResourceCollector();
        collector.collect((JRReport)jasperDesign);
        return collector.getResources();
    }

    private Resource[] getResources() {
        return this.resources.toArray(new Resource[this.resources.size()]);
    }

    private void collect(JRReport report) {
        if (report != null) {
            JRStyle[] styles = report.getStyles();
            if (styles != null) {
                for (int i = 0; i < styles.length; ++i) {
                    this.collect(styles[i]);
                }
            }
            JRElementsVisitor.visitReport((JRReport)report, (JRVisitor)this);
        }
    }

    private void collect(JRStyle style) {
        this.collectFont(style.getOwnPdfFontName());
        JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
        if (conditionalStyles != null) {
            for (int i = 0; i < conditionalStyles.length; ++i) {
                this.collect((JRStyle)conditionalStyles[i]);
            }
        }
    }

    public void visitImage(JRImage image) {
        this.collectFromExpression(image.getExpression(), "img");
    }

    public void visitStaticText(JRStaticText staticText) {
        this.collectFont(staticText.getOwnPdfFontName());
    }

    public void visitSubreport(JRSubreport subreport) {
        this.collectFromExpression(subreport.getExpression(), "jrxml");
    }

    public void visitTextField(JRTextField textField) {
        this.collectFont(textField.getOwnPdfFontName());
    }

    private void collectFont(String pdfFontName) {
        if (pdfFontName != null && pdfFontName.startsWith(REPO_URL_PROTOCOL) && pdfFontName.indexOf(47) < 0) {
            String resourceName = pdfFontName.substring(REPO_URL_PROTOCOL.length());
            this.collectResource(resourceName, "font");
        }
    }

    private void collectFromExpression(JRExpression expression, String resourceType) {
        String resourceName;
        JRExpressionChunk chunk;
        if (expression != null && expression.getChunks() != null && expression.getChunks().length == 1 && (chunk = expression.getChunks()[0]).getType() == 1 && (resourceName = chunk.getText().trim()).startsWith("\"repo:") && resourceName.indexOf(47) < 0 && resourceName.endsWith("\"")) {
            resourceName = resourceName.substring(REPO_URL_PROTOCOL.length() + 1, resourceName.length() - 1);
            this.collectResource(resourceName, resourceType);
        }
    }

    protected void collectResource(String name, String type) {
        if (!this.resourceNames.contains(name)) {
            FileResourceImpl resource = new FileResourceImpl();
            resource.setName(name);
            resource.setLabel(resource.getName());
            resource.setDescription(resource.getName());
            resource.setFileType(type);
            this.resources.add(resource);
            this.resourceNames.add(name);
        }
    }
}

