/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.PooledObjectEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PooledObjectCache {
    final Map cache = new HashMap();
    PooledObjectEntry first = null;
    PooledObjectEntry last = null;
    PooledObjectCacheLog log;

    public PooledObjectCacheLog getLog() {
        return this.log;
    }

    public void setLog(PooledObjectCacheLog log) {
        this.log = log;
    }

    public PooledObjectEntry get(Object key, long now) {
        PooledObjectEntry entry = (PooledObjectEntry)this.cache.get(key);
        if (entry == null) {
            return null;
        }
        this.moveFirst(entry);
        entry.access(now);
        return entry;
    }

    protected void moveFirst(PooledObjectEntry entry) {
        if (this.first != entry) {
            this.removeFromSequence(entry);
            this.addFirst(entry);
        }
    }

    protected void addFirst(PooledObjectEntry entry) {
        entry.next = this.first;
        entry.prev = null;
        if (this.first != null) {
            this.first.prev = entry;
        }
        this.first = entry;
        if (this.last == null) {
            this.last = entry;
        }
    }

    public void put(Object key, PooledObjectEntry entry, long now) {
        this.addFirst(entry);
        entry.access(now);
        this.cache.put(key, entry);
    }

    public List<PooledObjectEntry> removeExpired(long now, int timeout) {
        ArrayList<PooledObjectEntry> expired = new ArrayList<PooledObjectEntry>();
        long expTime = now - (long)(timeout * 1000);
        PooledObjectEntry entry = this.last;
        while (entry != null && entry.lastAccess < expTime) {
            if (entry.isActive()) {
                if (this.log != null) {
                    this.log.debug(entry.key, PooledObjectCacheLog.DebugCode.STILL_ACTIVE);
                }
            } else {
                if (this.log != null) {
                    this.log.debug(entry.key, PooledObjectCacheLog.DebugCode.EXPIRING);
                }
                expired.add(entry);
                this.remove(entry);
            }
            entry = entry.prev;
        }
        return expired;
    }

    protected void remove(PooledObjectEntry entry) {
        this.cache.remove(entry.key);
        this.removeFromSequence(entry);
    }

    protected void removeFromSequence(PooledObjectEntry entry) {
        if (entry.prev != null) {
            entry.prev.next = entry.next;
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
        if (this.first == entry) {
            this.first = entry.next;
        }
        if (this.last == entry) {
            this.last = entry.prev;
        }
    }

    public static interface PooledObjectCacheLog {
        public void debug(Object var1, DebugCode var2);

        public static enum DebugCode {
            STILL_ACTIVE,
            EXPIRING;

        }
    }
}

