/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceValidator;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDelegatedDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.util.JRProperties;
import org.springframework.beans.BeanWrapperImpl;

public class CustomDataSourceDefinition
implements Serializable {
    private static final long serialVersionUID = 8081959598490729657L;
    public static final String PARAM_NAME = "name";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_DEFAULT = "default";
    public static final String PARAM_HIDDEN = "hidden";
    private transient CustomReportDataSourceServiceFactory factory;
    private CustomDelegatedDataSourceServiceFactory customFactory;
    private String name;
    private String serviceClassName;
    private CustomDataSourceValidator validator;
    private List<Map<String, ?>> propertyDefinitions;
    private Map<String, String> queryExecuterMap;
    public static final String PROPERTY_MAP = "propertyMap";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFactory(CustomReportDataSourceServiceFactory factory) {
        this.factory = factory;
        factory.addDefinition(this);
    }

    public CustomReportDataSourceServiceFactory getFactory() {
        return this.factory;
    }

    public void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public void setValidator(CustomDataSourceValidator validator) {
        this.validator = validator;
    }

    public CustomDataSourceValidator getValidator() {
        return this.validator;
    }

    public void setPropertyDefinitions(List<Map<String, String>> propertyDefinitions) {
        this.propertyDefinitions = new ArrayList();
        for (Map<String, String> pd : propertyDefinitions) {
            HashMap<String, String> newPd = new HashMap<String, String>(pd);
            newPd.put(PARAM_LABEL, this.getParameterLabelName((String)newPd.get(PARAM_NAME)));
            this.propertyDefinitions.add(newPd);
        }
    }

    public List<Map<String, ?>> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public String getLabelName() {
        return this.name + ".name";
    }

    public String getParameterLabelName(String paramName) {
        return this.name + ".properties." + paramName;
    }

    public List<Map<String, ?>> getEditablePropertyDefinitions() {
        ArrayList list = new ArrayList(this.propertyDefinitions);
        Iterator pdi = list.iterator();
        while (pdi.hasNext()) {
            Map pd = (Map)pdi.next();
            String hidden = (String)pd.get(PARAM_HIDDEN);
            if (!Boolean.parseBoolean(hidden)) continue;
            pdi.remove();
        }
        return list;
    }

    public Map<String, String> getQueryExecuterMap() {
        return this.queryExecuterMap;
    }

    public void setQueryExecuterMap(Map<String, String> queryExecuterMap) {
        this.queryExecuterMap = queryExecuterMap;
        if (queryExecuterMap == null) {
            return;
        }
        for (String lang : queryExecuterMap.keySet()) {
            String qefClassName = queryExecuterMap.get(lang);
            JRProperties.setProperty((String)("net.sf.jasperreports.query.executer.factory." + lang), (String)qefClassName);
        }
    }

    public void setDefaultValues(CustomReportDataSource cds) {
        if (cds.getPropertyMap() == null) {
            cds.setPropertyMap(new HashMap());
        }
        for (Map<String, ?> pd : this.propertyDefinitions) {
            String value;
            String name = (String)pd.get(PARAM_NAME);
            Object def = pd.get(PARAM_DEFAULT);
            String hidden = (String)pd.get(PARAM_HIDDEN);
            if (Boolean.parseBoolean(hidden) || (value = (String)cds.getPropertyMap().get(name)) != null) continue;
            if (def == null) {
                def = "";
            }
            cds.getPropertyMap().put(name, (String)def);
        }
    }

    public void setDataSourceServiceProperties(CustomReportDataSource customDataSource, ReportDataSourceService service) {
        BeanWrapperImpl bw = new BeanWrapperImpl((Object)service);
        HashMap propMap = new HashMap();
        for (Map<String, ?> pd : this.getPropertyDefinitions()) {
            String name = (String)pd.get(PARAM_NAME);
            Object deflt = pd.get(PARAM_DEFAULT);
            Object value = customDataSource.getPropertyMap().get(name);
            if (value == null && deflt != null) {
                value = deflt;
            }
            if (value == null) continue;
            if (bw.isWritableProperty(name)) {
                bw.setPropertyValue(name, value);
            }
            propMap.put(name, value);
        }
        if (bw.isWritableProperty(PROPERTY_MAP)) {
            bw.setPropertyValue(PROPERTY_MAP, propMap);
        }
    }

    public void setCustomFactory(CustomDelegatedDataSourceServiceFactory customFactory) {
        this.customFactory = customFactory;
        customFactory.setCustomDataSourceDefinition(this);
    }

    public CustomDelegatedDataSourceServiceFactory getCustomFactory() {
        return this.customFactory;
    }
}

