/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DefaultDataCacheSnapshot;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.SavedDataCacheSnapshotDecorator;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshotMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DefaultDataCacheSnapshotMetadata;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.data.cache.ColumnDataCacheHandler;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.data.cache.DataRecorder;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.data.cache.DatasetRecorder;

public class ReportDataCacheProvider {
    private volatile DataCacheSnapshot snapshot;
    private boolean hadSavedSnapshot;

    public DataCacheSnapshot getSnapshot() {
        return this.snapshot;
    }

    public boolean hadSavedSnapshot() {
        return this.hadSavedSnapshot;
    }

    public void setSnapshot(DataCacheSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public void setSavedDataSnapshot(DataCacheSnapshot snapshot) {
        SavedDataCacheSnapshotDecorator persistenceSnapshot = new SavedDataCacheSnapshotDecorator(snapshot);
        this.setSnapshot(persistenceSnapshot);
    }

    public void setHadSavedSnapshot(boolean hadSavedSnapshot) {
        this.hadSavedSnapshot = hadSavedSnapshot;
    }

    public void clearSnapshot() {
        this.setSnapshot(null);
    }

    public DataCacheHandler createRecordHandler(Map<String, Object> parameters) {
        ColumnDataCacheHandler delegateHandler = new ColumnDataCacheHandler();
        return new RecordHandler(parameters, (DataCacheHandler)delegateHandler);
    }

    protected void setRecorderDataSnapshot(DataCacheSnapshot snapshot) {
        this.setSnapshot(snapshot);
    }

    protected class RecordHandler
    implements DataCacheHandler {
        private final Map<String, Object> parameters;
        private final DataCacheHandler delegate;
        private Date snasphotDate;

        public RecordHandler(Map<String, Object> parameters, DataCacheHandler delegate) {
            this.parameters = parameters;
            this.delegate = delegate;
            this.snasphotDate = new Date();
        }

        public boolean isRecordingEnabled() {
            return this.delegate.isRecordingEnabled();
        }

        public DataRecorder createDataRecorder() {
            DataRecorder dataRecorder = this.delegate.createDataRecorder();
            return new Recorder(dataRecorder);
        }

        public boolean isSnapshotPopulated() {
            return false;
        }

        public DataSnapshot getDataSnapshot() {
            return null;
        }

        protected void wrapDataSnapshot() {
            DataSnapshot dataSnapshot = this.delegate.getDataSnapshot();
            DefaultDataCacheSnapshotMetadata metadata = new DefaultDataCacheSnapshotMetadata(this.parameters, this.snasphotDate);
            DefaultDataCacheSnapshot snapshot = new DefaultDataCacheSnapshot(dataSnapshot, (DataCacheSnapshotMetadata)metadata);
            ReportDataCacheProvider.this.setRecorderDataSnapshot(snapshot);
        }

        protected class Recorder
        implements DataRecorder {
            final DataRecorder delegate;

            public Recorder(DataRecorder delegate) {
                this.delegate = delegate;
            }

            public DatasetRecorder createRecorder() {
                return this.delegate.createRecorder();
            }

            public void addRecordResult(Object key, Object recorded) {
                this.delegate.addRecordResult(key, recorded);
            }

            public void setSnapshotPopulated() {
                this.delegate.setSnapshotPopulated();
                if (this.isEnabled()) {
                    RecordHandler.this.wrapDataSnapshot();
                }
            }

            public void disableRecording() {
                this.delegate.disableRecording();
            }

            public void disablePersistence() {
                this.delegate.disablePersistence();
            }

            public boolean isEnabled() {
                return RecordHandler.this.isRecordingEnabled();
            }
        }
    }
}

